/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlSchemaViolationCause {
    private final List<Message> messages;

    public XmlSchemaViolationCause(SAXException e) {
        this.messages = Collections.singletonList(new Message(e.getMessage(), 0, 0));
    }

    public XmlSchemaViolationCause(List<SAXParseException> es) {
        this.messages = new ArrayList<Message>();
        for (SAXParseException e : es) {
            this.messages.add(new Message(e.getMessage(), e.getLineNumber(), e.getColumnNumber()));
        }
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public static class Message {
        private final String message;
        private final int line;
        private final int column;

        public Message(String message, int line, int column) {
            this.message = message;
            this.line = line;
            this.column = column;
        }

        public String getMessage() {
            return this.message;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

