/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.httpcomponents;

import guru.nidi.ramltester.core.AggregatingReportStore;
import guru.nidi.ramltester.core.RamlChecker;
import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.ReportAggregator;
import guru.nidi.ramltester.core.ReportStore;
import guru.nidi.ramltester.core.ThreadLocalReportStore;
import guru.nidi.ramltester.httpcomponents.HttpComponentsRamlRequest;
import guru.nidi.ramltester.httpcomponents.HttpComponentsRamlResponse;
import java.io.Closeable;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class RamlHttpClient
implements HttpClient,
Closeable {
    private static final String RAML_TESTED = "raml.tested";
    private static final BasicHttpResponse DUMMY_RESPONSE = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 204, "not sending");
    private final RamlChecker checker;
    private final boolean notSending;
    private final ReportStore reportStore;
    private final CloseableHttpClient delegate;

    public RamlHttpClient(RamlChecker checker, boolean notSending, ReportStore reportStore, CloseableHttpClient delegate) {
        this.checker = checker;
        this.notSending = notSending;
        this.reportStore = reportStore;
        this.delegate = delegate;
    }

    public RamlHttpClient(RamlChecker checker) {
        this(checker, false, new ThreadLocalReportStore(), HttpClientBuilder.create().build());
    }

    public RamlHttpClient(RamlChecker checker, CloseableHttpClient httpClient) {
        this(checker, false, new ThreadLocalReportStore(), httpClient);
    }

    public RamlHttpClient notSending() {
        return new RamlHttpClient(this.checker, true, this.reportStore, this.delegate);
    }

    public RamlHttpClient aggregating(ReportAggregator aggregator) {
        return new RamlHttpClient(this.checker, this.notSending, new AggregatingReportStore(this.reportStore, aggregator), this.delegate);
    }

    public RamlReport getLastReport() {
        return this.reportStore.getLastReport();
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        RamlReport report;
        BasicHttpResponse response;
        this.reportStore.storeReport(null);
        HttpComponentsRamlRequest ramlRequest = new HttpComponentsRamlRequest(target, request);
        if (this.notSending) {
            response = DUMMY_RESPONSE;
            report = this.checker.check(ramlRequest);
        } else {
            response = this.delegate.execute(target, request, context);
            report = this.checker.check(ramlRequest, new HttpComponentsRamlResponse((HttpResponse)response));
        }
        if (!this.alreadyTested(context)) {
            this.reportStore.storeReport(report);
        }
        return response;
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException {
        return this.execute(target, request, (HttpContext)new BasicHttpContext());
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
        RamlReport report;
        BasicHttpResponse response;
        this.reportStore.storeReport(null);
        HttpComponentsRamlRequest ramlRequest = new HttpComponentsRamlRequest(request);
        if (this.notSending) {
            response = DUMMY_RESPONSE;
            report = this.checker.check(ramlRequest);
        } else {
            response = this.delegate.execute(request, context);
            report = this.checker.check(ramlRequest, new HttpComponentsRamlResponse((HttpResponse)response));
        }
        if (!this.alreadyTested(context)) {
            this.reportStore.storeReport(report);
        }
        return response;
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        return this.execute(request, (HttpContext)new BasicHttpContext());
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        return (T)this.delegate.execute(request, responseHandler);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        return (T)this.delegate.execute(request, responseHandler, context);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        return (T)this.delegate.execute(target, request, responseHandler);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        return (T)this.delegate.execute(target, request, responseHandler, context);
    }

    @Deprecated
    public HttpParams getParams() {
        return this.delegate.getParams();
    }

    @Deprecated
    public ClientConnectionManager getConnectionManager() {
        return this.delegate.getConnectionManager();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private boolean alreadyTested(HttpContext context) {
        if (context.getAttribute(RAML_TESTED) != null) {
            return true;
        }
        context.setAttribute(RAML_TESTED, (Object)true);
        return false;
    }
}

