/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.jaxrs;

import guru.nidi.ramltester.core.RamlCheckerException;
import guru.nidi.ramltester.jaxrs.JaxrsContextRamlMessage;
import guru.nidi.ramltester.model.RamlResponse;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.util.IoUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.client.ClientResponseContext;

public class JaxrsContextRamlResponse
extends JaxrsContextRamlMessage
implements RamlResponse {
    private final ClientResponseContext context;
    private final byte[] content;

    public JaxrsContextRamlResponse(ClientResponseContext context) {
        this.context = context;
        try {
            this.content = IoUtils.readIntoByteArray(context.getEntityStream());
            context.setEntityStream((InputStream)new ByteArrayInputStream(this.content));
        }
        catch (IOException e) {
            throw new RamlCheckerException("Could not get response content", e);
        }
    }

    @Override
    public int getStatus() {
        return this.context.getStatus();
    }

    @Override
    public Values getHeaderValues() {
        return this.headersOf(this.context.getHeaders());
    }

    @Override
    public String getContentType() {
        return this.context.getMediaType() == null ? null : this.context.getMediaType().toString();
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }
}

