/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.restassured;

import com.jayway.restassured.filter.FilterContext;
import com.jayway.restassured.specification.FilterableRequestSpecification;
import guru.nidi.ramltester.core.RamlCheckerException;
import guru.nidi.ramltester.model.RamlRequest;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.restassured.RestAssuredRamlMessage;

class RestAssuredRamlRequest
extends RestAssuredRamlMessage
implements RamlRequest {
    private final FilterableRequestSpecification requestSpec;
    private final FilterContext filterContext;

    RestAssuredRamlRequest(FilterableRequestSpecification requestSpec, FilterContext filterContext) {
        this.requestSpec = requestSpec;
        this.filterContext = filterContext;
    }

    @Override
    public Values getHeaderValues() {
        return this.headersToValues(this.requestSpec.getHeaders());
    }

    @Override
    public String getContentType() {
        return this.requestSpec.getRequestContentType();
    }

    @Override
    public byte[] getContent() {
        Object body = this.requestSpec.getBody();
        if (body == null) {
            return null;
        }
        if (body instanceof String) {
            return ((String)body).getBytes();
        }
        if (body instanceof byte[]) {
            return (byte[])body;
        }
        throw new RamlCheckerException("Cannot process body of type " + body.getClass());
    }

    @Override
    public String getRequestUrl(String baseUri, boolean includeServletPath) {
        return baseUri == null || baseUri.length() == 0 ? this.filterContext.getRequestURI() : this.filterContext.getRequestURI().replace(this.requestSpec.getBaseUri(), baseUri);
    }

    @Override
    public String getMethod() {
        return this.filterContext.getRequestMethod().toString();
    }

    @Override
    public Values getQueryValues() {
        return this.mapToValues(this.requestSpec.getQueryParams());
    }

    @Override
    public Values getFormValues() {
        return this.mapToValues(this.requestSpec.getFormParams());
    }
}

