/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.servlet;

import guru.nidi.ramltester.core.RamlCheckerException;
import guru.nidi.ramltester.model.RamlRequest;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.servlet.DelegatingServletInputStream;
import guru.nidi.ramltester.util.FormDecoder;
import guru.nidi.ramltester.util.IoUtils;
import guru.nidi.ramltester.util.UriComponents;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ServletRamlRequest
extends HttpServletRequestWrapper
implements RamlRequest {
    private byte[] content;

    public ServletRamlRequest(HttpServletRequest delegate) {
        super(delegate);
    }

    private HttpServletRequest request() {
        return (HttpServletRequest)this.getRequest();
    }

    @Override
    public String getRequestUrl(String baseUri, boolean includeServletPath) {
        String servletPath = includeServletPath ? this.request().getServletPath() : "";
        String pathInfo = this.request().getPathInfo() == null ? "" : this.request().getPathInfo();
        return baseUri == null ? this.request().getRequestURL().toString() : baseUri + servletPath + pathInfo;
    }

    @Override
    public Values getQueryValues() {
        return UriComponents.parseQuery(this.request().getQueryString());
    }

    @Override
    public Values getFormValues() {
        return new FormDecoder().decode(this);
    }

    @Override
    public Values getHeaderValues() {
        return ServletRamlRequest.getHeaderValues(this.request());
    }

    public static Values getHeaderValues(HttpServletRequest request) {
        Values headers = new Values();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                headers.addValue(name, values.nextElement());
            }
        }
        return headers;
    }

    public ServletInputStream getInputStream() throws IOException {
        this.readContentIfNeeded();
        return new DelegatingServletInputStream(new ByteArrayInputStream(this.content));
    }

    public BufferedReader getReader() throws IOException {
        this.readContentIfNeeded();
        InputStreamReader in = this.getCharacterEncoding() == null ? new InputStreamReader(new ByteArrayInputStream(this.content)) : new InputStreamReader((InputStream)new ByteArrayInputStream(this.content), this.getCharacterEncoding());
        return new BufferedReader(in);
    }

    @Override
    public byte[] getContent() {
        try {
            this.readContentIfNeeded();
            return IoUtils.readIntoByteArray((InputStream)this.getInputStream());
        }
        catch (IOException e) {
            throw new RamlCheckerException("Could not read content", e);
        }
    }

    private void readContentIfNeeded() throws IOException {
        if (this.content == null) {
            this.content = IoUtils.readIntoByteArray((InputStream)super.getInputStream());
        }
    }
}

