/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.servlet;

import guru.nidi.ramltester.core.RamlCheckerException;
import guru.nidi.ramltester.model.RamlResponse;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.servlet.DelegatingServletOutputStream;
import guru.nidi.ramltester.servlet.DelegatingWriter;
import guru.nidi.ramltester.util.IoUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ServletRamlResponse
extends HttpServletResponseWrapper
implements RamlResponse {
    private String characterEncoding = "iso-8859-1";
    private final ByteArrayOutputStream content = new ByteArrayOutputStream(1024);
    private PrintWriter writer;
    private ServletOutputStream outputStream;
    private int status = 200;
    private final Values headers = new Values();

    public ServletRamlResponse(HttpServletResponse delegate) {
        super(delegate);
    }

    public void setStatus(int sc) {
        this.status = sc;
        super.setStatus(sc);
    }

    public void setStatus(int sc, String sm) {
        this.status = sc;
        super.setStatus(sc, sm);
    }

    public void setHeader(String name, String value) {
        this.headers.setValue(name, value);
        super.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.headers.addValue(name, value);
        super.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headers.setValue(name, Integer.toString(value));
        super.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.headers.addValue(name, Integer.toString(value));
        super.addIntHeader(name, value);
    }

    public void setDateHeader(String name, long date) {
        this.headers.setValue(name, this.dateToString(date));
        super.setDateHeader(name, date);
    }

    public void addDateHeader(String name, long date) {
        this.headers.addValue(name, this.dateToString(date));
        super.addDateHeader(name, date);
    }

    private String dateToString(long date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(new Date(date));
    }

    public void setCharacterEncoding(String charset) {
        super.setCharacterEncoding(charset);
        this.characterEncoding = charset;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            OutputStreamWriter targetWriter = this.characterEncoding == null ? new OutputStreamWriter(this.content) : new OutputStreamWriter((OutputStream)this.content, this.characterEncoding);
            this.writer = new PrintWriter(new DelegatingWriter(super.getWriter(), targetWriter));
        }
        return this.writer;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new DelegatingServletOutputStream((OutputStream)super.getOutputStream(), this.content);
        }
        return this.outputStream;
    }

    @Override
    public byte[] getContent() {
        try {
            this.flushBuffer();
            byte[] data = this.content.toByteArray();
            return "gzip".equalsIgnoreCase(this.getHeader("Content-Encoding")) ? this.gunzip(data) : data;
        }
        catch (IOException e) {
            throw new RamlCheckerException("Problem getting content", e);
        }
    }

    private byte[] gunzip(byte[] gzipped) throws IOException {
        return IoUtils.readIntoByteArray(new GZIPInputStream(new ByteArrayInputStream(gzipped)));
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public Values getHeaderValues() {
        return this.headers;
    }
}

