/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.spring;

import guru.nidi.ramltester.core.AggregatingReportStore;
import guru.nidi.ramltester.core.RamlChecker;
import guru.nidi.ramltester.core.RamlReport;
import guru.nidi.ramltester.core.ReportAggregator;
import guru.nidi.ramltester.core.ReportStore;
import guru.nidi.ramltester.core.ThreadLocalReportStore;
import guru.nidi.ramltester.spring.RamlRequestInterceptor;
import java.util.Collections;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.InterceptingClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class RamlRestTemplate
extends RestTemplate {
    private final RamlChecker ramlChecker;
    private final boolean notSending;
    private final ReportStore reportStore;
    private final ClientHttpRequestFactory originalRequestFactory;

    private RamlRestTemplate(RamlChecker ramlChecker, boolean notSending, ReportStore reportStore, ClientHttpRequestFactory requestFactory) {
        this.ramlChecker = ramlChecker;
        this.notSending = notSending;
        this.reportStore = reportStore;
        this.originalRequestFactory = requestFactory;
        RamlRequestInterceptor interceptor = new RamlRequestInterceptor(ramlChecker, notSending, reportStore);
        this.setRequestFactory((ClientHttpRequestFactory)new InterceptingClientHttpRequestFactory((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory(requestFactory), Collections.singletonList(interceptor)));
    }

    private RamlRestTemplate(RamlChecker ramlChecker, boolean notSending, ReportStore reportStore, RamlRestTemplate restTemplate) {
        this(ramlChecker, notSending, reportStore, restTemplate.originalRequestFactory);
        this.init(restTemplate);
    }

    private RamlRestTemplate(RamlChecker ramlChecker, boolean notSending, ReportStore reportStore, RestTemplate restTemplate) {
        this(ramlChecker, notSending, reportStore, restTemplate.getRequestFactory());
        this.init(restTemplate);
    }

    public RamlRestTemplate(RamlChecker ramlChecker, ClientHttpRequestFactory requestFactory) {
        this(ramlChecker, false, (ReportStore)new ThreadLocalReportStore(), requestFactory);
    }

    public RamlRestTemplate(RamlChecker ramlChecker, RestTemplate restTemplate) {
        this(ramlChecker, false, (ReportStore)new ThreadLocalReportStore(), restTemplate);
    }

    public RamlRestTemplate(RamlChecker ramlChecker, RamlRestTemplate restTemplate) {
        this(ramlChecker, false, (ReportStore)new ThreadLocalReportStore(), restTemplate);
    }

    public RamlRestTemplate notSending() {
        return new RamlRestTemplate(this.ramlChecker, true, this.reportStore, this);
    }

    public RamlRestTemplate aggregating(ReportAggregator aggregator) {
        return new RamlRestTemplate(this.ramlChecker, this.notSending, (ReportStore)new AggregatingReportStore(this.reportStore, aggregator), this);
    }

    private void init(RestTemplate restTemplate) {
        this.setErrorHandler(restTemplate.getErrorHandler());
        this.setMessageConverters(restTemplate.getMessageConverters());
    }

    public RamlReport getLastReport() {
        return this.reportStore.getLastReport();
    }
}

