/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.spring;

import guru.nidi.ramltester.core.RamlCheckerException;
import guru.nidi.ramltester.model.RamlResponse;
import guru.nidi.ramltester.model.Values;
import guru.nidi.ramltester.spring.SpringHttpRamlMessage;
import guru.nidi.ramltester.util.IoUtils;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;

public class SpringClientHttpRamlResponse
extends SpringHttpRamlMessage
implements ClientHttpResponse,
RamlResponse {
    private final ClientHttpResponse response;

    public SpringClientHttpRamlResponse(ClientHttpResponse response) {
        this.response = response;
    }

    @Override
    public int getStatus() {
        try {
            return this.getRawStatusCode();
        }
        catch (IOException e) {
            throw new RamlCheckerException("Problem getting status", e);
        }
    }

    @Override
    public String getContentType() {
        return this.contentTypeOf(this.getHeaders());
    }

    @Override
    public byte[] getContent() {
        try {
            return IoUtils.readIntoByteArray(this.getBody());
        }
        catch (IOException e) {
            throw new RamlCheckerException("Problem getting content", e);
        }
    }

    public HttpStatus getStatusCode() throws IOException {
        return this.response.getStatusCode();
    }

    public int getRawStatusCode() throws IOException {
        return this.response.getRawStatusCode();
    }

    public String getStatusText() throws IOException {
        return this.response.getStatusText();
    }

    public void close() {
        this.response.close();
    }

    public InputStream getBody() throws IOException {
        return this.response.getBody();
    }

    public HttpHeaders getHeaders() {
        return this.response.getHeaders();
    }

    @Override
    public Values getHeaderValues() {
        return this.headerValuesOf(this.response.getHeaders());
    }
}

