/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.util;

import guru.nidi.ramltester.util.InvalidMediaTypeException;
import guru.nidi.ramltester.util.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

public final class MediaType {
    public static final Comparator<MediaType> QUALITY_COMPARATOR = new Comparator<MediaType>(){

        @Override
        public int compare(MediaType m1, MediaType m2) {
            return Double.compare(m2.getQualityParameter(), m1.getQualityParameter());
        }
    };
    public static final MediaType JSON = MediaType.valueOf("application/json");
    public static final MediaType FORM_URL_ENCODED = MediaType.valueOf("application/x-www-form-urlencoded");
    public static final MediaType MULTIPART = MediaType.valueOf("multipart/form-data");
    private static final String CHARSET = "charset";
    private static final String WILDCARD_TYPE = "*";
    private static final Map<String, MediaType> KNOWN_SUFFICES = new HashMap<String, MediaType>();
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;

    private MediaType(String type, String subtype, Map<String, String> parameters) {
        this.type = type;
        this.subtype = subtype;
        this.parameters = parameters;
    }

    public static MediaType valueOf(String mimeType) {
        int subIndex;
        if (mimeType == null || mimeType.length() == 0) {
            throw new InvalidMediaTypeException(mimeType, new Message("mediaType.empty", new Object[0]));
        }
        String[] parts = MediaType.tokenizeToStringArray(mimeType, ";");
        String fullType = parts[0].trim();
        if (WILDCARD_TYPE.equals(fullType)) {
            fullType = "*/*";
        }
        if ((subIndex = fullType.indexOf(47)) == -1) {
            throw new InvalidMediaTypeException(mimeType, new Message("mediaType.noSlash", new Object[0]));
        }
        if (subIndex == fullType.length() - 1) {
            throw new InvalidMediaTypeException(mimeType, new Message("mediaType.noSubtype", new Object[0]));
        }
        String type = fullType.substring(0, subIndex);
        String subtype = fullType.substring(subIndex + 1, fullType.length());
        if (WILDCARD_TYPE.equals(type) && !WILDCARD_TYPE.equals(subtype)) {
            throw new InvalidMediaTypeException(mimeType, new Message("mediaType.wildcard.illegal", new Object[0]));
        }
        Map<String, String> parameters = MediaType.parseParameters(parts);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            MediaType.checkParameter(mimeType, entry.getKey(), entry.getValue());
        }
        return new MediaType(type, subtype, parameters);
    }

    private static Map<String, String> parseParameters(String[] parts) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(parts.length);
        if (parts.length > 1) {
            for (int i = 1; i < parts.length; ++i) {
                String parameter = parts[i];
                int eqIndex = parameter.indexOf(61);
                if (eqIndex == -1) continue;
                String attribute = parameter.substring(0, eqIndex);
                String value = parameter.substring(eqIndex + 1, parameter.length());
                parameters.put(attribute, value);
            }
        }
        return parameters;
    }

    public double getQualityParameter() {
        String q = MediaType.unquote(this.getParameter("q"));
        return q == null ? 1.0 : Double.parseDouble(q);
    }

    private static void checkParameter(String mimeType, String key, String value) {
        if ("q".equals(key)) {
            String unquoted = MediaType.unquote(value);
            try {
                double d = Double.parseDouble(unquoted);
                if (d < 0.0 || d > 1.0) {
                    throw new InvalidMediaTypeException(mimeType, new Message("mediaType.quality.illegal", unquoted));
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidMediaTypeException(mimeType, new Message("mediaType.quality.illegal", unquoted));
            }
        }
    }

    private static boolean isQuotedString(String s) {
        return s.length() >= 2 && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"));
    }

    private static String unquote(String s) {
        if (s == null) {
            return null;
        }
        return MediaType.isQuotedString(s) ? s.substring(1, s.length() - 1) : s;
    }

    public boolean isWildcardType() {
        return WILDCARD_TYPE.equals(this.getType());
    }

    public boolean isWildcardSubtype() {
        return WILDCARD_TYPE.equals(this.getSubtype()) || this.getSubtype().startsWith("*+");
    }

    public int similarity(MediaType other) {
        int i;
        int s = 0;
        int factor = 81;
        String[] myParts = this.parts();
        String[] otherParts = other.parts();
        for (i = 0; i < myParts.length; ++i) {
            if (WILDCARD_TYPE.equals(myParts[i]) || WILDCARD_TYPE.equals(otherParts[i])) {
                s += factor;
            } else {
                if (!myParts[i].equals(otherParts[i])) break;
                s += 2 * factor;
            }
            factor /= 3;
        }
        return i <= 1 ? 0 : s;
    }

    private String[] parts() {
        String[] stringArray;
        String suffix = this.getSuffix();
        if (suffix == null) {
            return new String[]{this.type, this.subtype, WILDCARD_TYPE, WILDCARD_TYPE, this.parameters.toString()};
        }
        MediaType known = KNOWN_SUFFICES.get(suffix);
        if (known == null) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = "unknown";
            stringArray2[1] = suffix;
            stringArray2[2] = this.type;
            stringArray2[3] = this.getPureSubtype();
            stringArray = stringArray2;
            stringArray2[4] = this.parameters.toString();
        } else {
            String[] stringArray3 = new String[5];
            stringArray3[0] = known.type;
            stringArray3[1] = known.subtype;
            stringArray3[2] = this.type;
            stringArray3[3] = this.getPureSubtype();
            stringArray = stringArray3;
            stringArray3[4] = this.parameters.toString();
        }
        return stringArray;
    }

    public boolean isCompatibleWith(MediaType other) {
        if (other == null) {
            return false;
        }
        if (this.isWildcardType() || other.isWildcardType()) {
            return true;
        }
        MediaType thisKnown = this.applyKnownSuffices();
        MediaType otherKnown = other.applyKnownSuffices();
        if ((thisKnown != this || otherKnown != other) && thisKnown.isCompatibleWith(otherKnown)) {
            return true;
        }
        if (!this.getType().equals(other.getType())) {
            return false;
        }
        if (this.getSubtype().equals(other.getSubtype())) {
            return true;
        }
        return this.isThisOrOtherWildcardSubtype(other) && this.hasSameSuffix(other);
    }

    private boolean isThisOrOtherWildcardSubtype(MediaType other) {
        return this.isWildcardSubtype() || other.isWildcardSubtype();
    }

    private boolean hasSameSuffix(MediaType other) {
        String thisSuffix = this.getSuffix();
        String otherSuffix = other.getSuffix();
        return thisSuffix == null && otherSuffix == null || thisSuffix != null && thisSuffix.equals(otherSuffix);
    }

    private MediaType applyKnownSuffices() {
        MediaType known = KNOWN_SUFFICES.get(this.getSuffix());
        return known == null ? this : known;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getPureSubtype() {
        int pos = this.getSubtype().indexOf(43);
        return pos == -1 ? this.getSubtype() : this.getSubtype().substring(0, pos);
    }

    public String getSuffix() {
        int pos = this.getSubtype().indexOf(43);
        return pos == -1 ? null : this.getSubtype().substring(pos + 1);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public String getCharset(String defaultCharset) {
        String charset = this.parameters.get(CHARSET);
        return charset == null ? defaultCharset : charset;
    }

    private static String[] tokenizeToStringArray(String str, String delimiters) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ((token = token.trim()).length() <= 0) continue;
            tokens.add(token);
        }
        return MediaType.toStringArray(tokens);
    }

    private static String[] toStringArray(Collection<String> collection) {
        return collection == null ? null : collection.toArray(new String[collection.size()]);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaType)) {
            return false;
        }
        MediaType otherType = (MediaType)other;
        return this.type.equalsIgnoreCase(otherType.type) && this.subtype.equalsIgnoreCase(otherType.subtype) && this.parameters.equals(otherType.parameters);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.subtype.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public String toString() {
        String res = this.type + "/" + this.subtype;
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            res = res + ";" + entry.getKey() + "=" + entry.getValue();
        }
        return res;
    }

    static {
        KNOWN_SUFFICES.put("json", JSON);
    }
}

