/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.validator;

import guru.nidi.loader.Loader;
import guru.nidi.loader.use.xml.LoaderLSResourceResolver;
import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.core.SchemaValidator;
import guru.nidi.ramltester.core.XmlSchemaViolationCause;
import guru.nidi.ramltester.util.MediaType;
import guru.nidi.ramltester.util.Message;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JavaXmlSchemaValidator
implements SchemaValidator {
    private static final MediaType APPLICATION_XML = MediaType.valueOf("application/xml");
    private static final MediaType TEXT_XML = MediaType.valueOf("text/xml");
    private final Loader loader;

    private JavaXmlSchemaValidator(Loader loader) {
        this.loader = loader;
    }

    public JavaXmlSchemaValidator() {
        this(null);
    }

    @Override
    public SchemaValidator withLoader(Loader loader) {
        return new JavaXmlSchemaValidator(loader);
    }

    @Override
    public boolean supports(MediaType mediaType) {
        return mediaType.isCompatibleWith(TEXT_XML) || mediaType.isCompatibleWith(APPLICATION_XML);
    }

    @Override
    public void validate(Reader content, Reader schema, RamlViolations violations, Message message) {
        try {
            SchemaFactory schemaFactory = LoaderLSResourceResolver.createXmlSchemaFactory((Loader)this.loader);
            Schema s = schemaFactory.newSchema(new StreamSource(schema));
            Validator validator = s.newValidator();
            ViolationsWritingErrorHandler errorHandler = new ViolationsWritingErrorHandler();
            validator.setErrorHandler(errorHandler);
            validator.validate(new StreamSource(content));
            if (!errorHandler.getExceptions().isEmpty()) {
                String msg = "";
                for (SAXParseException ex : errorHandler.getExceptions()) {
                    msg = msg + new Message("javaXmlSchemaValidator.message", ex.getLineNumber(), ex.getColumnNumber(), ex.getMessage());
                }
                violations.add(message.withParam(msg), (Object)new XmlSchemaViolationCause(errorHandler.getExceptions()));
            }
        }
        catch (SAXException e) {
            violations.add(message.withParam(new Message("schema.invalid", e.getMessage())), (Object)new XmlSchemaViolationCause(e));
        }
        catch (IOException e) {
            violations.add(message.withParam(new Message("schema.invalid", e.getMessage())));
        }
    }

    private static class ViolationsWritingErrorHandler
    implements ErrorHandler {
        private final List<SAXParseException> exceptions = new ArrayList<SAXParseException>();

        private ViolationsWritingErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.exceptions.add(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.exceptions.add(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.exceptions.add(e);
        }

        public List<SAXParseException> getExceptions() {
            return this.exceptions;
        }
    }
}

