/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.ramltester.validator;

import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.report.ReportProvider;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import guru.nidi.loader.Loader;
import guru.nidi.loader.use.jsonschema.LoaderUriDownloader;
import guru.nidi.ramltester.core.JsonSchemaViolationCause;
import guru.nidi.ramltester.core.RamlViolations;
import guru.nidi.ramltester.core.SchemaValidator;
import guru.nidi.ramltester.util.MediaType;
import guru.nidi.ramltester.util.Message;
import java.io.IOException;
import java.io.Reader;

public class JsonSchemaValidator
implements SchemaValidator {
    private JsonSchemaFactory factory;
    private final LoadingConfiguration loadingConfiguration;
    private final ReportProvider reportProvider;
    private final ValidationConfiguration validationConfiguration;
    private final Loader loader;

    private JsonSchemaValidator(Loader loader, LoadingConfiguration loadingConfiguration, ReportProvider reportProvider, ValidationConfiguration validationConfiguration) {
        this.loader = loader;
        this.loadingConfiguration = loadingConfiguration;
        this.reportProvider = reportProvider;
        this.validationConfiguration = validationConfiguration;
    }

    public JsonSchemaValidator() {
        this(null, null, null, null);
    }

    public JsonSchemaValidator using(LoadingConfiguration loadingConfiguration) {
        return new JsonSchemaValidator(this.loader, loadingConfiguration, this.reportProvider, this.validationConfiguration);
    }

    public JsonSchemaValidator using(ReportProvider reportProvider) {
        return new JsonSchemaValidator(this.loader, this.loadingConfiguration, reportProvider, this.validationConfiguration);
    }

    public JsonSchemaValidator using(ValidationConfiguration validationConfiguration) {
        return new JsonSchemaValidator(this.loader, this.loadingConfiguration, this.reportProvider, validationConfiguration);
    }

    @Override
    public SchemaValidator withLoader(Loader loader) {
        return new JsonSchemaValidator(loader, this.loadingConfiguration, this.reportProvider, this.validationConfiguration);
    }

    @Override
    public boolean supports(MediaType mediaType) {
        return mediaType.isCompatibleWith(MediaType.JSON);
    }

    private synchronized void init() {
        if (this.factory == null) {
            this.factory = this.loader == null ? JsonSchemaFactory.byDefault() : LoaderUriDownloader.createJsonSchemaFactory((Loader)this.loader, (LoadingConfiguration)this.loadingConfiguration, (ReportProvider)this.reportProvider, (ValidationConfiguration)this.validationConfiguration);
        }
    }

    @Override
    public void validate(Reader content, Reader schema, RamlViolations violations, Message message) {
        this.init();
        try (Reader s = schema;){
            JsonSchema jsonSchema = this.factory.getJsonSchema(JsonLoader.fromReader((Reader)schema));
            ProcessingReport report = jsonSchema.validate(JsonLoader.fromReader((Reader)content));
            if (!report.isSuccess()) {
                String msg = "";
                for (ProcessingMessage reportLine : report) {
                    msg = msg + new Message("jsonSchemaValidator.message", reportLine.toString());
                }
                violations.add(message.withParam(msg), (Object)new JsonSchemaViolationCause(report));
            }
        }
        catch (ProcessingException e) {
            violations.add(message.withMessageParam("schema.invalid", e.getMessage()), (Object)new JsonSchemaViolationCause(e));
        }
        catch (IOException e) {
            violations.add(message.withMessageParam("schema.invalid", e.getMessage()));
        }
    }
}

