/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.snippets;

import guru.nidi.snippets.IoUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Snippets {
    final Map<String, String> snippets;
    private final Pattern snippetStart;
    private final String snippetEnd;
    private final Pattern refStart;
    private final String refEnd;
    private final String prefix;
    private final String postfix;
    private final int tabSize;

    public Snippets(String snippetStart, String snippetEnd, String refStart, String refEnd, int tabSize) {
        this(Snippets.markPattern(snippetStart), snippetEnd, Snippets.markPattern(refStart), refEnd, tabSize, "", "", Collections.emptyMap());
    }

    private Snippets(Pattern snippetStart, String snippetEnd, Pattern refStart, String refEnd, int tabSize, String prefix, String postfix, Map<String, String> snippets) {
        this.snippetStart = snippetStart;
        this.snippetEnd = snippetEnd;
        this.refStart = refStart;
        this.refEnd = refEnd;
        this.prefix = prefix;
        this.postfix = postfix;
        this.snippets = snippets;
        this.tabSize = tabSize;
    }

    private static Pattern markPattern(String s) {
        int pos = s.indexOf("%name");
        if (pos < 0) {
            throw new IllegalArgumentException("Start pattern must contain '%name'");
        }
        return Pattern.compile("\\Q" + s.substring(0, pos) + "\\E([A-Za-z0-9]+)\\Q" + s.substring(pos + 5));
    }

    public Snippets prefix(String prefix) {
        return new Snippets(this.snippetStart, this.snippetEnd, this.refStart, this.refEnd, this.tabSize, prefix, this.postfix, this.snippets);
    }

    public Snippets postfix(String postfix) {
        return new Snippets(this.snippetStart, this.snippetEnd, this.refStart, this.refEnd, this.tabSize, this.prefix, postfix, this.snippets);
    }

    public Snippets withFile(File file, String encoding) throws IOException {
        try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), encoding);){
            Snippets snippets = new Snippets(this.snippetStart, this.snippetEnd, this.refStart, this.refEnd, this.tabSize, this.prefix, this.postfix, this.parse(in, new HashMap<String, String>(this.snippets)));
            return snippets;
        }
    }

    public Snippets withString(String code) {
        try {
            return new Snippets(this.snippetStart, this.snippetEnd, this.refStart, this.refEnd, this.tabSize, this.prefix, this.postfix, this.parse(new StringReader(code), new HashMap<String, String>(this.snippets)));
        }
        catch (IOException e) {
            throw new AssertionError("Cannot happen", e);
        }
    }

    public List<String> replaceRefs(File file, File output, String encoding) throws IOException {
        return this.replace(file, output, encoding, true);
    }

    public List<String> replaceSnippets(File file, String encoding) throws IOException {
        File temp = File.createTempFile("snippets", "txt");
        List<String> warnings = this.replace(file, temp, encoding, false);
        if (!file.delete()) {
            throw new IOException("Could not delete file " + file);
        }
        Files.move(temp.toPath(), file.toPath(), new CopyOption[0]);
        return warnings;
    }

    public String replaceRefs(String s) {
        return this.replace(s, true);
    }

    public String replaceSnippets(String s) {
        return this.replace(s, false);
    }

    public int size() {
        return this.snippets.size();
    }

    private List<String> replace(File file, File output, String encoding, boolean refs) throws IOException {
        ArrayList<String> warnings = new ArrayList<String>();
        output.getParentFile().mkdirs();
        try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
             OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(output), encoding);){
            List<String> warns = this.replace(in, out, refs);
            for (String warn : warns) {
                warnings.add("In file " + file.getName() + ": " + warn);
            }
        }
        return warnings;
    }

    private String replace(String s, boolean refs) {
        StringWriter sw = new StringWriter();
        try {
            this.replace(new StringReader(s), sw, refs);
            return sw.toString();
        }
        catch (IOException e) {
            throw new AssertionError("Cannot happen", e);
        }
    }

    private Map<String, String> parse(Reader in, Map<String, String> snippets) throws IOException {
        String code = IoUtils.read(in);
        Matcher matcher = this.snippetStart.matcher(code);
        int endPos = 0;
        while (matcher.find(endPos)) {
            endPos = code.indexOf(this.snippetEnd, matcher.end());
            if (endPos < 0) {
                throw new IllegalArgumentException("No snippetEnd marker found for snippetStart '" + code.substring(matcher.start(), matcher.end()) + "'");
            }
            String name = matcher.group(1);
            if (snippets.containsKey(name)) {
                throw new IllegalArgumentException("Snippet with name '" + name + "' already existing.");
            }
            snippets.put(name, this.trim(code.substring(matcher.end(), endPos)));
            endPos += this.snippetEnd.length();
        }
        return snippets;
    }

    private String trim(String s) {
        String[] lines = this.makeLines(s);
        int minIndent = this.findMinimalIndent(lines);
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line.length() >= minIndent ? line.substring(minIndent) : line).append('\n');
        }
        return s.endsWith("\n") ? sb.toString() : sb.substring(0, sb.length() - 1);
    }

    private String[] makeLines(String s) {
        String[] lines = s.split("\n");
        if (this.tabSize > 0) {
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = lines[i].replace("\t", this.tab());
            }
        }
        return lines;
    }

    private int findMinimalIndent(String[] lines) {
        int minIndent = 1000;
        for (String line : lines) {
            int pos;
            for (pos = 0; pos < line.length() && line.charAt(pos) <= ' '; ++pos) {
            }
            if (pos >= line.length() || pos >= minIndent) continue;
            minIndent = pos;
        }
        return minIndent;
    }

    private String tab() {
        StringBuilder s = new StringBuilder();
        while (s.length() < this.tabSize) {
            s.append(' ');
        }
        return s.toString();
    }

    private List<String> replace(Reader in, Writer out, boolean refs) throws IOException {
        ArrayList<String> warnings = new ArrayList<String>();
        String template = IoUtils.read(in);
        Matcher matcher = this.refStart.matcher(template);
        int matchPos = 0;
        int appendPos = 0;
        while (matcher.find(matchPos)) {
            if (refs) {
                out.write(template.substring(appendPos, matcher.start()));
                matchPos = appendPos = matcher.end();
            } else {
                out.write(template.substring(appendPos, matcher.end()));
                appendPos = template.indexOf(this.refEnd, matcher.end());
                if (appendPos < 0) {
                    throw new IllegalArgumentException("No refEnd marker found for refStart '" + template.substring(matcher.start(), matcher.end()) + "'");
                }
                matchPos = appendPos + this.refEnd.length();
            }
            String name = matcher.group(1);
            if (!this.snippets.containsKey(name)) {
                out.write(template.substring(matcher.end(), appendPos));
                warnings.add("Snippet '" + name + "' not defined.");
                continue;
            }
            out.write(this.prefix);
            out.write(this.snippets.get(name));
            out.write(this.postfix);
        }
        out.write(template.substring(appendPos));
        return warnings;
    }
}

