/*
 * Decompiled with CFR 0.152.
 */
package ch.ahdis.matchbox.engine;

import ch.ahdis.matchbox.engine.IgLoaderFromClassPath;
import ch.ahdis.matchbox.engine.MatchboxEngine;
import ch.ahdis.matchbox.engine.cli.VersionUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r5.context.IWorkerContextManager;
import org.hl7.fhir.validation.ValidationEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdaMappingEngine
extends MatchboxEngine {
    protected static final Logger log = LoggerFactory.getLogger(CdaMappingEngine.class);

    public CdaMappingEngine(ValidationEngine other) throws FHIRException, IOException {
        super(other);
    }

    public Bundle transformCdaToFhir(String cda, String mapUri) throws FHIRException, IOException {
        return (Bundle)this.transformToFhir(cda, false, mapUri);
    }

    public static class CdaMappingEngineBuilder
    extends ValidationEngine.ValidationEngineBuilder {
        public CdaMappingEngine getEngine() throws FHIRException, IOException, URISyntaxException {
            log.info("Initializing CDA Mapping Engine");
            log.info(VersionUtil.getPoweredBy());
            CdaMappingEngine engine = new CdaMappingEngine(super.fromNothing());
            engine.setVersion("4.0.1");
            IgLoaderFromClassPath igLoader = new IgLoaderFromClassPath(engine.getPcm(), engine.getContext(), engine.getVersion(), engine.isDebug());
            engine.setIgLoader(igLoader);
            igLoader.loadIg(engine.getIgs(), null, "/hl7.fhir.r4.core.tgz", false);
            igLoader.loadIg(engine.getIgs(), null, "/hl7.terminology#5.0.0.tgz", false);
            igLoader.loadIg(engine.getIgs(), null, "/cda-core-2.0#2.1.0-cibuild.tgz", false);
            engine.getContext().setCanRunWithoutTerminology(true);
            engine.getContext().setNoTerminologyServer(true);
            engine.getContext().setPackageTracker((IWorkerContextManager.IPackageLoadingTracker)engine);
            return engine;
        }

        public CdaMappingEngine getEngine(String mapIg) throws FHIRException, IOException, URISyntaxException {
            CdaMappingEngine engine = this.getEngine();
            engine.getIgLoader().loadIg(engine.getIgs(), null, mapIg, false);
            return engine;
        }
    }
}

