/*
 * Decompiled with CFR 0.152.
 */
package ch.ahdis.matchbox.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.validation.IgLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgLoaderFromClassPath
extends IgLoader {
    protected static final Logger log = LoggerFactory.getLogger(IgLoaderFromClassPath.class);

    public IgLoaderFromClassPath(FilesystemPackageCacheManager packageCacheManager, SimpleWorkerContext context, String theVersion, boolean debug) {
        super(packageCacheManager, context, theVersion, debug);
    }

    public void loadIg(List<ImplementationGuide> igs, Map<String, byte[]> binaries, String src, boolean recursive) throws IOException, FHIRException {
        if (binaries == null) {
            binaries = new HashMap<String, byte[]>();
        }
        super.loadIg(igs, binaries, src, recursive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, byte[]> loadIgSource(String src, boolean recursive, boolean explore) throws FHIRException, IOException {
        if (src.startsWith("/") && src.endsWith(".tgz") && src.lastIndexOf("/") == 0) {
            InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(src);
            if (stream == null) {
                throw new FHIRException("Unable to find/resolve/read from classpath" + src);
            }
            try {
                if (src.endsWith(".tgz")) {
                    Map<String, byte[]> map = this.loadPackage(NpmPackage.fromPackage((InputStream)stream), false);
                    return map;
                }
            }
            finally {
                stream.close();
            }
            throw new FHIRException("Unable to find/resolve/read from classpath" + src);
        }
        return super.loadIgSource(src, recursive, explore);
    }

    public Map<String, byte[]> loadPackage(NpmPackage pi, boolean loadInContext) throws FHIRException, IOException {
        HashMap<String, byte[]> res = new HashMap<String, byte[]>();
        this.getContext().getLoadedPackages().add(pi.name() + "#" + pi.version());
        log.info("Loading package " + pi.name() + "#" + pi.version() + "[FHIR] version=" + pi.fhirVersion());
        int count = 0;
        for (String s : pi.listResources(new String[]{"CodeSystem", "ConceptMap", "ImplementationGuide", "CapabilityStatement", "NamingSystem", "Questionnaire", "Conformance", "StructureMap", "ValueSet", "StructureDefinition"})) {
            ++count;
            res.put(s, TextFile.streamToBytes((InputStream)pi.load("package", s)));
        }
        String ini = "[FHIR]\r\nversion=" + pi.fhirVersion() + "\r\n";
        res.put("version.info", ini.getBytes());
        log.info("Finished loading " + count + " conformance resources for package " + pi.name() + "#" + pi.version());
        return res;
    }
}

