/*
 * Decompiled with CFR 0.152.
 */
package ch.ahdis.matchbox.engine;

import ch.ahdis.matchbox.engine.IgLoaderFromClassPath;
import ch.ahdis.matchbox.engine.cli.VersionUtil;
import ch.ahdis.matchbox.mappinglanguage.MatchboxStructureMapUtilities;
import ch.ahdis.matchbox.mappinglanguage.TransformSupportServices;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_43_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.formats.XmlParser;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4b.model.CanonicalResource;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.IWorkerContextManager;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.JsonParser;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.ExpressionNode;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.instance.InstanceValidator;
import org.hl7.fhir.validation.instance.utils.ValidatorHostContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchboxEngine
extends ValidationEngine {
    protected static final Logger log = LoggerFactory.getLogger(MatchboxEngine.class);

    public MatchboxEngine(ValidationEngine other) throws FHIRException, IOException {
        super(other);
    }

    public org.hl7.fhir.r4.model.Resource transformToFhir(String input, boolean inputJson, String mapUri) throws FHIRException, IOException {
        String transformedXml = this.transform(input, inputJson, mapUri, false);
        return new XmlParser().parse(transformedXml);
    }

    public String transform(String input, boolean inputJson, String mapUri, boolean outputJson) throws FHIRException, IOException {
        log.info("Start transform: " + mapUri);
        Element transformed = this.transform(input.getBytes("UTF-8"), inputJson ? Manager.FhirFormat.JSON : Manager.FhirFormat.XML, mapUri);
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        if (outputJson) {
            new JsonParser((IWorkerContext)this.getContext()).compose(transformed, (OutputStream)boas, IParser.OutputStyle.PRETTY, null);
        } else {
            new org.hl7.fhir.r5.elementmodel.XmlParser((IWorkerContext)this.getContext()).compose(transformed, boas, IParser.OutputStyle.PRETTY, null);
        }
        String result = new String(boas.toByteArray());
        boas.close();
        log.info("Transform finished: " + mapUri);
        return result;
    }

    public Element transform(byte[] source, Manager.FhirFormat cntType, String mapUri) throws FHIRException, IOException {
        SimpleWorkerContext context = this.getContext();
        Element src = Manager.parseSingle((IWorkerContext)context, (InputStream)new ByteArrayInputStream(source), (Manager.FhirFormat)cntType);
        return this.transform(src, mapUri);
    }

    public Element transform(Element src, String mapUri) throws FHIRException, IOException {
        SimpleWorkerContext context = this.getContext();
        ArrayList<Base> outputs = new ArrayList<Base>();
        MatchboxStructureMapUtilities scu = new MatchboxStructureMapUtilities((IWorkerContext)context, new TransformSupportServices((IWorkerContext)context, outputs), this);
        StructureMap map = (StructureMap)context.fetchResource(StructureMap.class, mapUri);
        if (map == null) {
            log.error("Unable to find map " + mapUri + " (Known Maps = " + context.listMapUrls() + ")");
            throw new Error("Unable to find map " + mapUri + " (Known Maps = " + context.listMapUrls() + ")");
        }
        log.info("Using map " + map.getUrl() + (String)(map.getVersion() != null ? "|" + map.getVersion() + " " : "") + (String)(map.getDateElement() != null && !map.getDateElement().isEmpty() ? "(" + map.getDateElement().asStringValue() + ")" : ""));
        Element resource = this.getTargetResourceFromStructureMap(map);
        scu.transform(null, (Base)src, map, (Base)resource);
        resource.populatePaths(null);
        return resource;
    }

    private Element getTargetResourceFromStructureMap(StructureMap map) {
        String targetTypeUrl = null;
        SimpleWorkerContext context = this.getContext();
        for (StructureMap.StructureMapStructureComponent component : map.getStructure()) {
            if (component.getMode() != StructureMap.StructureMapModelMode.TARGET) continue;
            targetTypeUrl = component.getUrl();
            break;
        }
        if (targetTypeUrl == null) {
            log.error("Unable to determine resource URL for target type");
            throw new FHIRException("Unable to determine resource URL for target type");
        }
        org.hl7.fhir.r5.model.StructureDefinition structureDefinition = null;
        for (org.hl7.fhir.r5.model.StructureDefinition sd : context.fetchResourcesByType(org.hl7.fhir.r5.model.StructureDefinition.class)) {
            if (!sd.getUrl().equalsIgnoreCase(targetTypeUrl)) continue;
            structureDefinition = sd;
            break;
        }
        if (structureDefinition == null) {
            log.error("Unable to find StructureDefinition for target type ('" + targetTypeUrl + "')");
            throw new FHIRException("Unable to find StructureDefinition for target type ('" + targetTypeUrl + "')");
        }
        return Manager.build((IWorkerContext)this.getContext(), structureDefinition);
    }

    public void addCanonicalResource(InputStream stream) throws FHIRException {
        this.getContext().loadFromFile(stream, "", null);
    }

    public void addCanonicalResource(org.hl7.fhir.r4.model.Resource resource) throws FHIRException {
        Resource r5 = VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)resource);
        this.getContext().cacheResource(r5);
    }

    public void addCanonicalResource(CanonicalResource resource) throws FHIRException {
        Resource r5 = VersionConvertorFactory_43_50.convertResource((org.hl7.fhir.r4b.model.Resource)resource);
        this.getContext().cacheResource(r5);
    }

    public void addCanonicalResource(org.hl7.fhir.r5.model.CanonicalResource resource) throws FHIRException {
        this.getContext().cacheResource((Resource)resource);
    }

    public OperationOutcome validate(InputStream stream, Manager.FhirFormat format, String profileUrl) throws FHIRException, IOException, EOperationOutcome {
        ArrayList<String> profiles = null;
        if (profileUrl != null) {
            profiles = new ArrayList<String>();
            profiles.add(profileUrl);
            List<org.hl7.fhir.r5.model.StructureDefinition> sds = this.asSdList(profiles);
            for (org.hl7.fhir.r5.model.StructureDefinition sd : sds) {
                log.info("Using profile for validation " + sd.getUrl() + "|" + sd.getVersion() + " " + (String)(sd.getDateElement() != null ? "(" + sd.getDateElement().asStringValue() + ")" : ""));
            }
        } else {
            log.info("validation on resource, no profile used");
        }
        org.hl7.fhir.r5.model.OperationOutcome outcome = super.validate(format, stream, profiles);
        return (OperationOutcome)VersionConvertorFactory_40_50.convertResource((Resource)outcome);
    }

    public OperationOutcome validate(org.hl7.fhir.r4.model.Resource resource, String profileUrl) throws FHIRException, IOException, EOperationOutcome {
        String result = new org.hl7.fhir.r4.formats.JsonParser().composeString(resource);
        return this.validate(new ByteArrayInputStream(result.getBytes("UTF-8")), Manager.FhirFormat.JSON, profileUrl);
    }

    public List<ValidationMessage> validate(Manager.FhirFormat format, InputStream stream, String profileUrl) throws FHIRException, IOException, EOperationOutcome {
        ArrayList<String> profiles = null;
        if (profileUrl != null) {
            profiles = new ArrayList<String>();
            profiles.add(profileUrl);
            List<org.hl7.fhir.r5.model.StructureDefinition> sds = this.asSdList(profiles);
            for (org.hl7.fhir.r5.model.StructureDefinition sd : sds) {
                log.info("Using profile for validation " + sd.getUrl() + "|" + sd.getVersion() + " " + (String)(sd.getDateElement() != null ? "(" + sd.getDateElement().asStringValue() + ")" : ""));
            }
        }
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        InstanceValidator validator = this.getValidator(format);
        validator.validate(null, messages, stream, format, this.asSdList(profiles));
        return messages;
    }

    public List<org.hl7.fhir.r5.model.StructureDefinition> asSdList(List<String> profiles) throws Error {
        ArrayList<org.hl7.fhir.r5.model.StructureDefinition> list = new ArrayList<org.hl7.fhir.r5.model.StructureDefinition>();
        if (profiles != null) {
            for (String p : profiles) {
                org.hl7.fhir.r5.model.StructureDefinition sd = (org.hl7.fhir.r5.model.StructureDefinition)this.getContext().fetchResource(org.hl7.fhir.r5.model.StructureDefinition.class, p);
                if (sd == null) {
                    log.error("Unable to resolve profile " + p);
                    throw new Error("Unable to resolve profile " + p);
                }
                list.add(sd);
            }
        }
        return list;
    }

    public StructureDefinition getStructureDefinition(String profile) {
        ArrayList<String> profiles = new ArrayList<String>();
        profiles.add(profile);
        try {
            List<org.hl7.fhir.r5.model.StructureDefinition> sds = this.asSdList(profiles);
            if (sds.size() > 0) {
                if (sds.size() > 1) {
                    log.debug("Multiple StructureDefinitions for profile " + profile);
                }
                return (StructureDefinition)VersionConvertorFactory_40_50.convertResource((Resource)((Resource)sds.get(0)));
            }
        }
        catch (Error error) {
            // empty catch block
        }
        return null;
    }

    public org.hl7.fhir.r4.model.Resource getCanonicalResource(String canonical) {
        Resource fetched2;
        Resource fetched = this.getContext().fetchResource(null, canonical);
        if (fetched != null && (fetched2 = this.getContext().fetchResource(fetched.getClass(), canonical)) != null) {
            return VersionConvertorFactory_40_50.convertResource((Resource)fetched2);
        }
        return null;
    }

    public IBaseResource getCanonicalResource(String canonical, String fhirVersion) {
        Resource fetched = this.getContext().fetchResource(null, canonical);
        if (fetched != null) {
            switch (fhirVersion) {
                case "4.0.1": {
                    return VersionConvertorFactory_40_50.convertResource((Resource)fetched);
                }
                case "4.3.0": {
                    return VersionConvertorFactory_43_50.convertResource((Resource)fetched);
                }
                case "5.0.0": {
                    return fetched;
                }
            }
        }
        return null;
    }

    public boolean fetchesCanonicalResource(IResourceValidator validator, String url) {
        return this.getCanonicalResource(url) != null;
    }

    public IBaseResource getCanonicalResourceById(String type, String id) {
        Resource fetched = this.getContext().fetchResourceById(type, id);
        if (fetched != null) {
            if ("5.0.0".equals(this.getVersion())) {
                return fetched;
            }
            if ("4.3.0".equals(this.getVersion())) {
                return VersionConvertorFactory_43_50.convertResource((Resource)fetched);
            }
            return VersionConvertorFactory_40_50.convertResource((Resource)fetched);
        }
        return null;
    }

    public StructureMap parseMapR5(String content) throws FHIRException {
        SimpleWorkerContext context = this.getContext();
        ArrayList<Base> outputs = new ArrayList<Base>();
        MatchboxStructureMapUtilities scu = new MatchboxStructureMapUtilities((IWorkerContext)context, new TransformSupportServices((IWorkerContext)context, outputs), this);
        StructureMap mapR5 = scu.parse(content, "map");
        mapR5.getText().setStatus(Narrative.NarrativeStatus.GENERATED);
        mapR5.getText().setDiv(new XhtmlNode(NodeType.Element, "div"));
        String render = StructureMapUtilities.render((StructureMap)mapR5);
        mapR5.getText().getDiv().addTag("pre").addText(render);
        return mapR5;
    }

    public org.hl7.fhir.r4.model.StructureMap parseMap(String content) throws FHIRException {
        StructureMap mapR5 = this.parseMapR5(content);
        return (org.hl7.fhir.r4.model.StructureMap)VersionConvertorFactory_40_50.convertResource((Resource)mapR5);
    }

    public StructureDefinition createSnapshot(StructureDefinition sd) throws FHIRException, IOException {
        org.hl7.fhir.r5.model.StructureDefinition sdR5 = (org.hl7.fhir.r5.model.StructureDefinition)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)sd);
        try {
            new ContextUtilities((IWorkerContext)this.getContext()).generateSnapshot(sdR5, sdR5.getKind() != null && sdR5.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL);
        }
        catch (Exception e) {
            log.error("Unable to generate snapshot for " + sd.getUrl(), (Throwable)e);
            return null;
        }
        return (StructureDefinition)VersionConvertorFactory_40_50.convertResource((Resource)sdR5);
    }

    public String evaluateFhirPath(String input, boolean inputJson, String expression) throws FHIRException, IOException {
        FHIRPathEngine fpe = this.getValidator(null).getFHIRPathEngine();
        Element e = Manager.parseSingle((IWorkerContext)this.getContext(), (InputStream)new ByteArrayInputStream(input.getBytes("UTF-8")), (Manager.FhirFormat)(inputJson ? Manager.FhirFormat.JSON : Manager.FhirFormat.XML));
        ExpressionNode exp = fpe.parse(expression);
        return fpe.evaluateToString((Object)new ValidatorHostContext((Object)this.getContext(), e), (Base)e, (Base)e, (Base)e, exp);
    }

    protected void txLog(String msg) {
        log.info("tx ", (Object)msg);
    }

    public static class MatchboxEngineBuilder
    extends ValidationEngine.ValidationEngineBuilder {
        public MatchboxEngine getEngineR4() throws FHIRException, IOException, URISyntaxException {
            log.info("Initializing Matchbox Engine (FHIR R4 with terminology provided in classpath)");
            log.info(VersionUtil.getPoweredBy());
            MatchboxEngine engine = new MatchboxEngine(super.fromNothing());
            engine.setVersion("4.0.1");
            IgLoaderFromClassPath igLoader = new IgLoaderFromClassPath(engine.getPcm(), engine.getContext(), engine.getVersion(), engine.isDebug());
            engine.setIgLoader(igLoader);
            igLoader.loadIg(engine.getIgs(), null, "/hl7.fhir.r4.core.tgz", false);
            igLoader.loadIg(engine.getIgs(), null, "/hl7.terminology#5.0.0.tgz", false);
            engine.getContext().setCanRunWithoutTerminology(true);
            engine.getContext().setNoTerminologyServer(true);
            engine.getContext().setPackageTracker((IWorkerContextManager.IPackageLoadingTracker)engine);
            return engine;
        }

        public MatchboxEngine getEngine() throws FHIRException, IOException, URISyntaxException {
            log.info("Initializing Matchbox Engine");
            log.info(VersionUtil.getPoweredBy());
            MatchboxEngine engine = new MatchboxEngine(super.fromNothing());
            engine.setVersion("4.0.1");
            engine.getContext().setCanRunWithoutTerminology(true);
            engine.getContext().setNoTerminologyServer(true);
            engine.getContext().setPackageTracker((IWorkerContextManager.IPackageLoadingTracker)engine);
            return engine;
        }
    }
}

