/*
 * Decompiled with CFR 0.152.
 */
package ch.ahdis.matchbox.engine.cli;

import ch.ahdis.matchbox.engine.MatchboxEngine;
import ch.ahdis.matchbox.engine.cli.MatchboxService;
import ch.ahdis.matchbox.engine.cli.VersionUtil;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Locale;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.terminologies.JurisdictionUtilities;
import org.hl7.fhir.utilities.FileFormat;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.validation.Scanner;
import org.hl7.fhir.validation.cli.model.CliContext;
import org.hl7.fhir.validation.cli.utils.Display;
import org.hl7.fhir.validation.cli.utils.EngineMode;
import org.hl7.fhir.validation.cli.utils.Params;
import org.hl7.fhir.validation.testexecutor.TestExecutor;
import org.hl7.fhir.validation.testexecutor.TestExecutorParams;

public class MatchboxCli {
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_PROXY_USER = "http.proxyUser";
    public static final String HTTP_PROXY_PASS = "http.proxyPassword";
    public static final String JAVA_DISABLED_TUNNELING_SCHEMES = "jdk.http.auth.tunneling.disabledSchemes";
    public static final String JAVA_DISABLED_PROXY_SCHEMES = "jdk.http.auth.proxying.disabledSchemes";
    public static final String JAVA_USE_SYSTEM_PROXIES = "java.net.useSystemProxies";
    private static MatchboxService matchboxService = new MatchboxService();

    public static void main(String[] args) throws Exception {
        String[] p;
        TimeTracker tt = new TimeTracker();
        TimeTracker.Session tts = tt.start("Loading");
        System.out.println(VersionUtil.getPoweredBy());
        Display.displaySystemInfo();
        if (Params.hasParam((String[])args, (String)"-proxy")) {
            assert (Params.getParam((String[])args, (String)"-proxy") != null) : "PROXY arg passed in was NULL";
            p = Params.getParam((String[])args, (String)"-proxy").split(":");
            System.setProperty(HTTP_PROXY_HOST, p[0]);
            System.setProperty(HTTP_PROXY_PORT, p[1]);
        }
        if (Params.hasParam((String[])args, (String)"-auth")) {
            assert (Params.getParam((String[])args, (String)"-proxy") != null) : "Cannot set PROXY_AUTH without setting PROXY...";
            assert (Params.getParam((String[])args, (String)"-auth") != null) : "PROXY_AUTH arg passed in was NULL...";
            p = Params.getParam((String[])args, (String)"-auth").split(":");
            final String authUser = p[0];
            final String authPass = p[1];
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(authUser, authPass.toCharArray());
                }
            });
            System.setProperty(HTTP_PROXY_USER, authUser);
            System.setProperty(HTTP_PROXY_PASS, authPass);
            System.setProperty(JAVA_USE_SYSTEM_PROXIES, "true");
            System.setProperty(JAVA_DISABLED_TUNNELING_SCHEMES, "");
            System.setProperty(JAVA_DISABLED_PROXY_SCHEMES, "");
        }
        CliContext cliContext = Params.loadCliContext((String[])args);
        FileFormat.checkCharsetAndWarnIfNotUTF8((PrintStream)System.out);
        if (MatchboxCli.shouldDisplayHelpToUser(args)) {
            Display.displayHelpDetails();
        } else if (Params.hasParam((String[])args, (String)"-tests")) {
            MatchboxCli.parseTestParamsAndExecute(args);
        } else {
            Display.printCliArgumentsAndInfo((String[])args);
            MatchboxCli.doValidation(tt, tts, cliContext);
        }
    }

    protected static void parseTestParamsAndExecute(String[] args) {
        String testModuleParam = Params.getParam((String[])args, (String)"-test-modules");
        String testClassnameFilter = Params.getParam((String[])args, (String)"-test-classname-filter");
        String testCasesDirectory = Params.getParam((String[])args, (String)"-tests");
        String txCacheDirectory = Params.getParam((String[])args, (String)"-txCache");
        assert (TestExecutorParams.isValidModuleParam((String)testModuleParam)) : "Invalid test module param: " + testModuleParam;
        String[] moduleNamesArg = TestExecutorParams.parseModuleParam((String)testModuleParam);
        assert (TestExecutorParams.isValidClassnameFilterParam((String)testClassnameFilter)) : "Invalid regex for test classname filter: " + testClassnameFilter;
        new TestExecutor(moduleNamesArg).executeTests(testClassnameFilter, txCacheDirectory, testCasesDirectory);
        System.exit(0);
    }

    private static boolean shouldDisplayHelpToUser(String[] args) {
        return args.length == 0 || Params.hasParam((String[])args, (String)"help") || Params.hasParam((String[])args, (String)"?") || Params.hasParam((String[])args, (String)"-?") || Params.hasParam((String[])args, (String)"/?");
    }

    private static void doValidation(TimeTracker tt, TimeTracker.Session tts, CliContext cliContext) throws Exception {
        if (cliContext.getSv() == null) {
            cliContext.setSv(matchboxService.determineVersion(cliContext));
        }
        if (cliContext.getJurisdiction() == null) {
            System.out.println("  Jurisdiction: None specified (locale = " + Locale.getDefault().getCountry() + ")");
            System.out.println("  Note that exceptions and validation failures may happen in the absense of a locale");
        } else {
            System.out.println("  Jurisdiction: " + JurisdictionUtilities.displayJurisdiction((String)cliContext.getJurisdiction()));
        }
        System.out.println("Loading");
        String definitions = "dev".equals(cliContext.getSv()) ? "hl7.fhir.r5.core#current" : VersionUtilities.packageForVersion((String)cliContext.getSv()) + "#" + VersionUtilities.getCurrentVersion((String)cliContext.getSv());
        MatchboxEngine validator = matchboxService.initializeValidator(cliContext, definitions, tt);
        tts.end();
        switch (cliContext.getMode()) {
            case TRANSFORM: {
                matchboxService.transform(cliContext, validator);
                break;
            }
            case COMPILE: {
                matchboxService.compile(cliContext, validator);
                break;
            }
            case NARRATIVE: {
                matchboxService.generateNarrative(cliContext, validator);
                break;
            }
            case SNAPSHOT: {
                matchboxService.generateSnapshot(cliContext, validator);
                break;
            }
            case CONVERT: {
                matchboxService.convertSources(cliContext, validator);
                break;
            }
            case FHIRPATH: {
                matchboxService.evaluateFhirpath(cliContext, validator);
                break;
            }
            case VERSION: {
                matchboxService.transformVersion(cliContext, validator);
                break;
            }
            default: {
                for (String s : cliContext.getProfiles()) {
                    if (validator.getContext().hasResource(StructureDefinition.class, s) || validator.getContext().hasResource(ImplementationGuide.class, s)) continue;
                    System.out.println("  Fetch Profile from " + s);
                    validator.loadProfile(cliContext.getLocations().getOrDefault(s, s));
                }
                System.out.println("Validating");
                if (cliContext.getMode() == EngineMode.SCAN) {
                    Scanner validationScanner = new Scanner(validator.getContext(), validator.getValidator(null), validator.getIgLoader(), validator.getFhirPathEngine());
                    validationScanner.validateScan(cliContext.getOutput(), cliContext.getSources());
                    break;
                }
                matchboxService.validateSources(cliContext, validator);
            }
        }
        System.out.println("Done. " + tt.report() + ". Max Memory = " + Utilities.describeSize((long)Runtime.getRuntime().maxMemory()));
    }
}

