/*
 * Decompiled with CFR 0.152.
 */
package ch.ahdis.matchbox.mappinglanguage;

import ch.ahdis.matchbox.engine.MatchboxEngine;
import ch.ahdis.matchbox.mappinglanguage.TransformSupportServices;
import java.util.ArrayList;
import java.util.EnumSet;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.profile.ProfileKnowledgeProvider;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.utils.structuremap.ITransformerServices;
import org.hl7.fhir.r5.utils.structuremap.SourceElementComponentWrapper;
import org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities;
import org.hl7.fhir.r5.utils.structuremap.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchboxStructureMapUtilities
extends StructureMapUtilities {
    private IWorkerContext worker;
    private MatchboxEngine engine;
    private ContextUtilities contextUtilites;
    protected static final Logger log = LoggerFactory.getLogger(TransformSupportServices.class);

    private void init(IWorkerContext worker, MatchboxEngine engine) {
        this.worker = worker;
        this.engine = engine;
        this.contextUtilites = new ContextUtilities(this.worker);
    }

    public MatchboxStructureMapUtilities(IWorkerContext worker, MatchboxEngine engine) {
        super(worker);
        this.init(worker, engine);
    }

    public MatchboxStructureMapUtilities(IWorkerContext worker, ITransformerServices services, ProfileKnowledgeProvider pkp, MatchboxEngine engine) {
        super(worker, services, pkp);
        this.init(worker, engine);
    }

    public MatchboxStructureMapUtilities(IWorkerContext worker, ITransformerServices services, MatchboxEngine engine) {
        super(worker, services);
        this.init(worker, engine);
    }

    public Base translate(TransformContext context, StructureMap map, Base source, String conceptMapUrl, String fieldToReturn) throws FHIRException {
        Base[] b;
        Coding src = new Coding();
        if (source.isPrimitive()) {
            src.setCode(source.primitiveValue());
        } else if ("Coding".equals(source.fhirType())) {
            b = source.getProperty("system".hashCode(), "system", true);
            if (b.length == 1) {
                src.setSystem(b[0].primitiveValue());
            }
            if ((b = source.getProperty("code".hashCode(), "code", true)).length == 1) {
                src.setCode(b[0].primitiveValue());
            }
        } else if (source.fhirType().endsWith("CE")) {
            b = source.getProperty("codeSystem".hashCode(), "codeSystem", true);
            if (b.length == 1) {
                src.setSystem(b[0].primitiveValue());
            }
            if ((b = source.getProperty("code".hashCode(), "code", true)).length == 1) {
                src.setCode(b[0].primitiveValue());
            }
        } else {
            throw new FHIRException("Unable to translate source " + source.fhirType());
        }
        Object su = conceptMapUrl;
        if (conceptMapUrl.equals("http://hl7.org/fhir/ConceptMap/special-oid2uri")) {
            Object uri = this.contextUtilites.oid2Uri(src.getCode());
            if (uri == null) {
                uri = "urn:oid:" + src.getCode();
            }
            if ("uri".equals(fieldToReturn)) {
                return new UriType((String)uri);
            }
            throw new FHIRException("Error in return code");
        }
        ConceptMap cmap = null;
        if (conceptMapUrl.startsWith("#")) {
            for (Resource r : map.getContained()) {
                if (!(r instanceof ConceptMap) || !r.getId().equals(conceptMapUrl.substring(1))) continue;
                cmap = (ConceptMap)r;
                su = map.getUrl() + "#" + conceptMapUrl;
            }
            if (cmap == null) {
                throw new FHIRException("Unable to translate - cannot find map " + conceptMapUrl);
            }
        } else {
            if (conceptMapUrl.contains("#")) {
                String[] p = conceptMapUrl.split("\\#");
                StructureMap mapU = (StructureMap)this.getWorker().fetchResource(StructureMap.class, p[0]);
                for (Resource r : mapU.getContained()) {
                    if (!(r instanceof ConceptMap) || !r.getId().equals(p[1])) continue;
                    cmap = (ConceptMap)r;
                    su = conceptMapUrl;
                }
            }
            if (cmap == null) {
                cmap = (ConceptMap)this.getWorker().fetchResource(ConceptMap.class, conceptMapUrl);
            }
        }
        Coding outcome = null;
        boolean done = false;
        String message = null;
        if (cmap == null) {
            if (this.getServices() == null) {
                message = "No map found for " + conceptMapUrl;
            } else {
                outcome = this.getServices().translate(context.getAppInfo(), src, conceptMapUrl);
                done = true;
            }
        } else {
            ArrayList<SourceElementComponentWrapper> list = new ArrayList<SourceElementComponentWrapper>();
            for (ConceptMap.ConceptMapGroupComponent g : cmap.getGroup()) {
                for (ConceptMap.SourceElementComponent e : g.getElement()) {
                    String srccode = src.getCode();
                    String srcsys = src.getSystem();
                    String ecode = e.getCode();
                    String gsys = g.getSource();
                    log.info("Src: " + srcsys + "#" + srccode + " <-> " + gsys + "#" + ecode);
                    if (!src.hasSystem() && srccode.equals(ecode)) {
                        list.add(new SourceElementComponentWrapper(g, e));
                        continue;
                    }
                    if (!src.hasSystem() || !srcsys.equals(gsys) || !srccode.equals(ecode)) continue;
                    list.add(new SourceElementComponentWrapper(g, e));
                }
            }
            if (list.size() == 0) {
                done = true;
            } else if (((SourceElementComponentWrapper)list.get(0)).getComp().getTarget().size() == 0) {
                message = "Concept map " + (String)su + " found no translation for " + src.getCode();
            } else {
                for (ConceptMap.TargetElementComponent tgt : ((SourceElementComponentWrapper)list.get(0)).getComp().getTarget()) {
                    if (outcome == null && ((SourceElementComponentWrapper)list.get(0)).getComp().getTarget().size() > 1) {
                        outcome = new CodeableConcept();
                    }
                    if (tgt.getRelationship() != null && !EnumSet.of(Enumerations.ConceptMapRelationship.RELATEDTO, Enumerations.ConceptMapRelationship.EQUIVALENT, Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET, Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET).contains(tgt.getRelationship())) continue;
                    if (done && "code".equals(fieldToReturn)) {
                        message = "Concept map " + (String)su + " found multiple matches for " + src.getCode();
                        done = false;
                        continue;
                    }
                    done = true;
                    if (outcome instanceof CodeableConcept) {
                        ((CodeableConcept)outcome).addCoding(new Coding().setCode(tgt.getCode()).setSystem(((SourceElementComponentWrapper)list.get(0)).getGroup().getTarget()).setDisplay(tgt.getDisplay()));
                        continue;
                    }
                    outcome = new Coding().setCode(tgt.getCode()).setSystem(((SourceElementComponentWrapper)list.get(0)).getGroup().getTarget()).setDisplay(tgt.getDisplay());
                }
                if (!done) {
                    message = "Concept map " + (String)su + " found no usable translation for " + src.getCode();
                }
            }
        }
        if (!done) {
            throw new FHIRException(message);
        }
        if (outcome == null) {
            return null;
        }
        if (outcome instanceof Coding) {
            if ("code".equals(fieldToReturn)) {
                return new CodeType(outcome.getCode()).setSystem(outcome.getSystem());
            }
            if ("system".equals(fieldToReturn)) {
                return new StringType(outcome.getSystem());
            }
            if ("display".equals(fieldToReturn)) {
                return new StringType(outcome.getDisplay());
            }
            if ("CodeableConcept".equals(fieldToReturn)) {
                return new CodeableConcept(outcome);
            }
        }
        if (outcome instanceof CodeableConcept && ((CodeableConcept)outcome).getCoding().size() > 0) {
            if ("code".equals(fieldToReturn)) {
                return new CodeType(((CodeableConcept)outcome).getCodingFirstRep().getCode()).setSystem(((CodeableConcept)outcome).getCodingFirstRep().getSystem());
            }
            if ("system".equals(fieldToReturn)) {
                return new StringType(((CodeableConcept)outcome).getCodingFirstRep().getSystem());
            }
            if ("display".equals(fieldToReturn)) {
                return new StringType(((CodeableConcept)outcome).getCodingFirstRep().getDisplay());
            }
            if ("Coding".equals(fieldToReturn)) {
                return ((CodeableConcept)outcome).getCodingFirstRep();
            }
        }
        return outcome;
    }

    public MatchboxEngine getEngine() {
        return this.engine;
    }
}

