/*
 * Decompiled with CFR 0.152.
 */
package ch.ahdis.matchbox.engine;

import ch.ahdis.matchbox.engine.ValidationPolicyAdvisor;
import ch.ahdis.matchbox.engine.cli.VersionUtil;
import ch.ahdis.matchbox.engine.exception.IgLoadException;
import ch.ahdis.matchbox.engine.exception.MatchboxEngineCreationException;
import ch.ahdis.matchbox.engine.exception.TerminologyServerException;
import ch.ahdis.matchbox.mappinglanguage.MatchboxStructureMapUtilities;
import ch.ahdis.matchbox.mappinglanguage.TransformSupportServices;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.fhir.ucum.UcumEssenceService;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_43_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.formats.XmlParser;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IContextResourceLoader;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.IWorkerContextManager;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.JsonParser;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.OperationOutcomeUtilities;
import org.hl7.fhir.r5.utils.structuremap.ITransformerServices;
import org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.IValidationPolicyAdvisor;
import org.hl7.fhir.r5.utils.validation.constants.ReferenceValidationPolicy;
import org.hl7.fhir.utilities.ByteProvider;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.validation.IgLoader;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.ValidatorUtils;
import org.hl7.fhir.validation.cli.services.PassiveExpiringSessionCache;
import org.hl7.fhir.validation.instance.InstanceValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchboxEngine
extends ValidationEngine {
    protected static final Logger log = LoggerFactory.getLogger(MatchboxEngine.class);
    protected List<String> suppressedWarnInfoPatterns = new ArrayList<String>();
    protected PassiveExpiringSessionCache sessionCache = new PassiveExpiringSessionCache();
    protected static ValidationEngine nullEngine;

    private Parameters makeExpProfile() {
        Parameters ep = new Parameters();
        ep.addParameter("profile-url", "http://hl7.org/fhir/ExpansionProfile/dc8fd4bc-091a-424a-8a3b-6198ef146891");
        return ep;
    }

    public MatchboxEngine(SimpleWorkerContext context) throws FHIRException, IOException {
        super(nullEngine);
        this.setContext(context);
        this.setVersion(context.getVersion());
        context.setCanNoTS(true);
        NpmPackage npmX = this.getPcm().loadPackage("hl7.fhir.xver-extensions", "0.1.0");
        context.loadFromPackage(npmX, null);
        this.setIgLoader(new IgLoader(this.getPcm(), this.getContext(), this.getVersion(), this.isDebug()));
        try {
            ClassLoader classLoader = ValidationEngine.class.getClassLoader();
            InputStream ue = classLoader.getResourceAsStream("ucum-essence.xml");
            context.setUcumService((UcumService)new UcumEssenceService(ue));
        }
        catch (Exception e) {
            throw new FHIRException("Error loading UCUM from embedded ucum-essence.xml: " + e.getMessage(), (Throwable)e);
        }
        context.setExpansionParameters(this.makeExpProfile());
        FHIRPathEngine fhirPathEngine = new FHIRPathEngine((IWorkerContext)context);
        fhirPathEngine.setAllowDoubleQuotes(false);
        this.setFhirPathEngine(fhirPathEngine);
        try {
            this.setPcm(new FilesystemPackageCacheManager.Builder().build());
        }
        catch (IOException e) {
            throw new MatchboxEngineCreationException(e);
        }
    }

    public MatchboxEngine(@NonNull ValidationEngine other) throws FHIRException, IOException {
        super(other);
        if (other instanceof MatchboxEngine) {
            MatchboxEngine otherMatchboxEgine = (MatchboxEngine)other;
            this.sessionCache = otherMatchboxEgine.sessionCache;
            this.suppressedWarnInfoPatterns = otherMatchboxEgine.suppressedWarnInfoPatterns;
        }
        this.setIgLoader(new IgLoader(this.getPcm(), this.getContext(), this.getVersion(), this.isDebug()));
        try {
            this.setPcm(new FilesystemPackageCacheManager.Builder().build());
        }
        catch (IOException e) {
            throw new MatchboxEngineCreationException(e);
        }
    }

    public void cacheXVersionEngine(MatchboxEngine engine) {
        this.sessionCache.cacheSession(engine.getVersion().substring(0, 3), (ValidationEngine)engine);
    }

    public FilesystemPackageCacheManager getPcm() {
        try {
            return super.getPcm();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public org.hl7.fhir.r4.model.Resource transformToFhir(String input, boolean inputJson, String mapUri) throws FHIRException, IOException {
        String transformedXml = this.transform(input, inputJson, mapUri, false);
        return new XmlParser().parse(transformedXml);
    }

    public String transform(String input, boolean inputJson, String mapUri, boolean outputJson) throws FHIRException, IOException {
        log.info("Start transform: " + mapUri);
        SimpleWorkerContext context = this.getContext();
        StructureMap map = (StructureMap)context.fetchResource(StructureMap.class, mapUri);
        String fhirVersionTarget = this.getFhirVersion(this.getCanonicalFromStructureMap(map, StructureMap.StructureMapModelMode.TARGET));
        if (fhirVersionTarget != null && (fhirVersionTarget.startsWith("4.0") || fhirVersionTarget.startsWith("4.3") || fhirVersionTarget.startsWith("5.0")) && !fhirVersionTarget.equals(this.getVersion().substring(0, 3))) {
            log.info("Loading additional FHIR version for Target into context " + fhirVersionTarget);
            context = this.getContextForFhirVersion(fhirVersionTarget);
        }
        Element transformed = this.transform(ByteProvider.forBytes((byte[])input.getBytes("UTF-8")), inputJson ? Manager.FhirFormat.JSON : Manager.FhirFormat.XML, mapUri, context);
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        if (outputJson) {
            new JsonParser((IWorkerContext)context).compose(transformed, (OutputStream)boas, IParser.OutputStyle.PRETTY, null);
        } else {
            new org.hl7.fhir.r5.elementmodel.XmlParser((IWorkerContext)context).compose(transformed, boas, IParser.OutputStyle.PRETTY, null);
        }
        String result = new String(boas.toByteArray());
        boas.close();
        log.info("Transform finished: " + mapUri);
        return result;
    }

    public Element transform(ByteProvider source, Manager.FhirFormat cntType, String mapUri, SimpleWorkerContext targetContext) throws FHIRException, IOException {
        SimpleWorkerContext context = this.getContext();
        StructureMap map = (StructureMap)context.fetchResource(StructureMap.class, mapUri);
        String fhirVersionSource = this.getFhirVersion(this.getCanonicalFromStructureMap(map, StructureMap.StructureMapModelMode.SOURCE));
        if (fhirVersionSource != null && (fhirVersionSource.startsWith("4.0") || fhirVersionSource.startsWith("4.3") || fhirVersionSource.startsWith("5.0")) && !fhirVersionSource.equals(this.getVersion().substring(0, 3))) {
            log.info("Loading additional FHIR version for Source into context " + fhirVersionSource);
            context = this.getContextForFhirVersion(fhirVersionSource);
        }
        Element src = Manager.parseSingle((IWorkerContext)context, (InputStream)new ByteArrayInputStream(source.getBytes()), (Manager.FhirFormat)cntType);
        return this.transform(src, mapUri, targetContext);
    }

    public SimpleWorkerContext getContextForFhirVersion(String fhirVersion) throws FHIRException, IOException {
        ValidationEngine engine;
        SimpleWorkerContext contextForFhirVersion = null;
        if (fhirVersion.startsWith("4.0")) {
            engine = this.sessionCache.fetchSessionValidatorEngine(fhirVersion.substring(0, 3));
            if (engine == null) {
                engine = new MatchboxEngineBuilder().getEngineR4();
                this.sessionCache.cacheSession(fhirVersion.substring(0, 3), engine);
            }
            contextForFhirVersion = engine.getContext();
        }
        if (fhirVersion.startsWith("4.3")) {
            engine = this.sessionCache.fetchSessionValidatorEngine(fhirVersion.substring(0, 3));
            if (engine == null) {
                engine = new MatchboxEngineBuilder().getEngineR4B();
                this.sessionCache.cacheSession(fhirVersion.substring(0, 3), engine);
            }
            contextForFhirVersion = engine.getContext();
        }
        if (fhirVersion.startsWith("5.0")) {
            engine = this.sessionCache.fetchSessionValidatorEngine(fhirVersion.substring(0, 3));
            if (engine == null) {
                engine = new MatchboxEngineBuilder().getEngineR5();
                this.sessionCache.cacheSession(fhirVersion.substring(0, 3), engine);
            }
            contextForFhirVersion = engine.getContext();
        }
        if (contextForFhirVersion != null && this.getContext().fetchResource(org.hl7.fhir.r5.model.StructureDefinition.class, "http://hl7.org/fhir/" + fhirVersion.substring(0, 3) + "/StructureDefinition/StructureDefinition") == null) {
            int len = "http://hl7.org/fhir/".length();
            for (org.hl7.fhir.r5.model.StructureDefinition sd : contextForFhirVersion.listStructures()) {
                if (!sd.getUrl().startsWith("http://hl7.org/fhir/") || sd.getKind() == null || sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL || "Extensions".equals(sd.getType()) || Character.isDigit(sd.getUrl().charAt(len))) continue;
                org.hl7.fhir.r5.model.StructureDefinition sdn = sd.copy();
                sdn.setUrl(sdn.getUrl().replace("http://hl7.org/fhir/", "http://hl7.org/fhir/" + fhirVersion.substring(0, 3) + "/"));
                sdn.addExtension().setUrl("http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace").setValue((DataType)new UriType("http://hl7.org/fhir"));
                this.getContext().cacheResource((Resource)sdn);
            }
        }
        return contextForFhirVersion;
    }

    public Element transform(Element src, String mapUri, SimpleWorkerContext targetContext) throws FHIRException, IOException {
        SimpleWorkerContext context = this.getContext();
        ArrayList<Base> outputs = new ArrayList<Base>();
        MatchboxStructureMapUtilities scu = new MatchboxStructureMapUtilities((IWorkerContext)context, (ITransformerServices)new TransformSupportServices((IWorkerContext)(targetContext != null ? targetContext : context), outputs), this);
        StructureMap map = (StructureMap)context.fetchResource(StructureMap.class, mapUri);
        if (map == null) {
            log.error("Unable to find map " + mapUri + " (Known Maps = " + context.listMapUrls() + ")");
            throw new Error("Unable to find map " + mapUri + " (Known Maps = " + context.listMapUrls() + ")");
        }
        log.info("Using map " + map.getUrl() + (String)(map.getVersion() != null ? "|" + map.getVersion() + " " : "") + (String)(map.getDateElement() != null && !map.getDateElement().isEmpty() ? "(" + map.getDateElement().asStringValue() + ")" : ""));
        Element resource = this.getTargetResourceFromStructureMap(map, targetContext);
        scu.transform(null, (Base)src, map, (Base)resource);
        resource.populatePaths(null);
        return resource;
    }

    private String getFhirVersion(String url) {
        return VersionUtilities.getMajMin((String)url);
    }

    private String getCanonicalFromStructureMap(StructureMap map, StructureMap.StructureMapModelMode mode) {
        String targetTypeUrl = null;
        for (StructureMap.StructureMapStructureComponent component : map.getStructure()) {
            if (component.getMode() != mode) continue;
            targetTypeUrl = component.getUrl();
            break;
        }
        return targetTypeUrl;
    }

    private Element getTargetResourceFromStructureMap(StructureMap map, SimpleWorkerContext targetContext) {
        int index;
        Object targetTypeUrl = null;
        SimpleWorkerContext context = targetContext != null ? targetContext : this.getContext();
        for (StructureMap.StructureMapStructureComponent component : map.getStructure()) {
            if (component.getMode() != StructureMap.StructureMapModelMode.TARGET) continue;
            targetTypeUrl = component.getUrl();
            break;
        }
        if (targetTypeUrl == null) {
            log.error("Unable to determine resource URL for target type");
            throw new FHIRException("Unable to determine resource URL for target type");
        }
        if (Utilities.isAbsoluteUrl(targetTypeUrl) && (index = ((String)targetTypeUrl).indexOf("/" + context.getVersion().substring(0, 3) + "/")) >= 0) {
            targetTypeUrl = ((String)targetTypeUrl).substring(0, index) + ((String)targetTypeUrl).substring(index + 4);
        }
        org.hl7.fhir.r5.model.StructureDefinition structureDefinition = null;
        for (org.hl7.fhir.r5.model.StructureDefinition sd : context.fetchResourcesByType(org.hl7.fhir.r5.model.StructureDefinition.class)) {
            if (!sd.getUrl().equalsIgnoreCase((String)targetTypeUrl)) continue;
            structureDefinition = sd;
            break;
        }
        if (structureDefinition == null) {
            log.error("Unable to find StructureDefinition for target type ('" + (String)targetTypeUrl + "')");
            throw new FHIRException("Unable to find StructureDefinition for target type ('" + (String)targetTypeUrl + "')");
        }
        return Manager.build((IWorkerContext)context, structureDefinition);
    }

    public void addCanonicalResource(InputStream stream) throws FHIRException {
        this.getContext().loadFromFile(stream, "", null);
    }

    public void addCanonicalResource(org.hl7.fhir.r4.model.Resource resource) throws FHIRException {
        Resource r5 = VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)resource);
        this.getContext().cacheResource(r5);
    }

    public void addCanonicalResource(org.hl7.fhir.r4b.model.CanonicalResource resource) throws FHIRException {
        Resource r5 = VersionConvertorFactory_43_50.convertResource((org.hl7.fhir.r4b.model.Resource)resource);
        this.getContext().cacheResource(r5);
    }

    public void addCanonicalResource(CanonicalResource resource) throws FHIRException {
        this.getContext().cacheResource((Resource)resource);
    }

    public OperationOutcome validate(@NonNull InputStream stream, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Manager.FhirFormat format, @Nullable String profileUrl) throws FHIRException, IOException, EOperationOutcome {
        return this.messagesToOutcome(this.validate(format, stream, profileUrl), this.getContext());
    }

    public OperationOutcome validate(@NonNull org.hl7.fhir.r4.model.Resource resource, @Nullable String profileUrl) throws FHIRException, IOException, EOperationOutcome {
        byte[] result = new org.hl7.fhir.r4.formats.JsonParser().composeBytes(resource);
        return this.validate(new ByteArrayInputStream(result), Manager.FhirFormat.JSON, profileUrl);
    }

    public List<ValidationMessage> validate(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Manager.FhirFormat format, @NonNull InputStream stream, @Nullable String profileUrl) throws FHIRException, IOException, EOperationOutcome {
        org.hl7.fhir.r5.model.StructureDefinition sd = null;
        if (profileUrl != null) {
            sd = this.getStructureDefinitionR5(profileUrl);
            log.info("Using profile for validation " + sd.getUrl() + "|" + sd.getVersion() + " " + (String)(sd.getDateElement() != null ? "(" + sd.getDateElement().asStringValue() + ")" : ""));
        }
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        InstanceValidator validator = this.getValidator(format);
        validator.setPolicyAdvisor((IValidationPolicyAdvisor)new ValidationPolicyAdvisor(ReferenceValidationPolicy.CHECK_VALID));
        validator.validate(null, messages, stream, format, (List<org.hl7.fhir.r5.model.StructureDefinition>)(sd != null ? new ArrayList<org.hl7.fhir.r5.model.StructureDefinition>(List.of(sd)) : new ArrayList()));
        return this.filterValidationMessages(messages);
    }

    public org.hl7.fhir.r5.model.StructureDefinition getStructureDefinitionR5(String profile) {
        return (org.hl7.fhir.r5.model.StructureDefinition)this.getContext().fetchResource(org.hl7.fhir.r5.model.StructureDefinition.class, profile);
    }

    public IBaseResource getCanonicalResource(String canonical, String fhirVersion) {
        Resource fetched2;
        Resource fetched = this.getContext().fetchResource(null, canonical);
        if (fetched != null && (fetched2 = this.getContext().fetchResource(fetched.getClass(), canonical)) != null) {
            switch (fhirVersion) {
                case "4.0.1": {
                    return VersionConvertorFactory_40_50.convertResource((Resource)fetched2);
                }
                case "4.3.0": {
                    return VersionConvertorFactory_43_50.convertResource((Resource)fetched2);
                }
                case "5.0.0": {
                    return fetched2;
                }
            }
        }
        return null;
    }

    public boolean fetchesCanonicalResource(IResourceValidator validator, String url) {
        return this.getCanonicalResource(url, "5.0.0") != null;
    }

    public IBaseResource getCanonicalResourceById(String type, @NonNull String id) {
        Resource fetched = this.getContext().fetchResourceById(type, id);
        if (fetched != null) {
            if ("5.0.0".equals(this.getVersion())) {
                return fetched;
            }
            if ("4.3.0".equals(this.getVersion())) {
                return VersionConvertorFactory_43_50.convertResource((Resource)fetched);
            }
            return VersionConvertorFactory_40_50.convertResource((Resource)fetched);
        }
        return null;
    }

    public StructureMap parseMapR5(String content) throws FHIRException {
        SimpleWorkerContext context = this.getContext();
        ArrayList<Base> outputs = new ArrayList<Base>();
        MatchboxStructureMapUtilities scu = new MatchboxStructureMapUtilities((IWorkerContext)context, (ITransformerServices)new TransformSupportServices((IWorkerContext)context, outputs), this);
        StructureMap mapR5 = scu.parse(content, "map");
        mapR5.getText().setStatus(Narrative.NarrativeStatus.GENERATED);
        mapR5.getText().setDiv(new XhtmlNode(NodeType.Element, "div"));
        String render = StructureMapUtilities.render(mapR5);
        mapR5.getText().getDiv().addTag("pre").addText(render);
        return mapR5;
    }

    public org.hl7.fhir.r4.model.StructureMap parseMap(String content) throws FHIRException {
        StructureMap mapR5 = this.parseMapR5(content);
        return (org.hl7.fhir.r4.model.StructureMap)VersionConvertorFactory_40_50.convertResource((Resource)mapR5);
    }

    public StructureDefinition createSnapshot(StructureDefinition sd) throws FHIRException, IOException {
        org.hl7.fhir.r5.model.StructureDefinition sdR5 = (org.hl7.fhir.r5.model.StructureDefinition)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)sd);
        try {
            new ContextUtilities((IWorkerContext)this.getContext()).generateSnapshot(sdR5);
        }
        catch (Exception e) {
            log.error("Unable to generate snapshot for " + sd.getUrl(), (Throwable)e);
            return null;
        }
        return (StructureDefinition)VersionConvertorFactory_40_50.convertResource((Resource)sdR5);
    }

    public org.hl7.fhir.r5.model.StructureDefinition createSnapshot(org.hl7.fhir.r5.model.StructureDefinition sd) throws FHIRException, IOException {
        org.hl7.fhir.r5.model.StructureDefinition sdR5 = sd;
        try {
            new ContextUtilities((IWorkerContext)this.getContext()).generateSnapshot(sdR5);
        }
        catch (Exception e) {
            log.error("Unable to generate snapshot for " + sd.getUrl(), (Throwable)e);
            return null;
        }
        return sd;
    }

    public String evaluateFhirPath(@NonNull String input, boolean inputJson, @NonNull String expression) throws FHIRException, IOException {
        FHIRPathEngine fpe = this.getValidator(null).getFHIRPathEngine();
        Element e = Manager.parseSingle((IWorkerContext)this.getContext(), (InputStream)new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8)), (Manager.FhirFormat)(inputJson ? Manager.FhirFormat.JSON : Manager.FhirFormat.XML));
        return fpe.evaluateToString((Base)e, expression);
    }

    public String convert(@NonNull String input, boolean inputJson) throws FHIRException, IOException {
        Element e = Manager.parseSingle((IWorkerContext)this.getContext(), (InputStream)new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8)), (Manager.FhirFormat)(inputJson ? Manager.FhirFormat.JSON : Manager.FhirFormat.XML));
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        Manager.compose((IWorkerContext)this.getContext(), (Element)e, (OutputStream)bs, (Manager.FhirFormat)(inputJson ? Manager.FhirFormat.XML : Manager.FhirFormat.JSON), (IParser.OutputStyle)IParser.OutputStyle.PRETTY, null);
        String result = new String(bs.toByteArray());
        bs.close();
        return result;
    }

    public void loadPackage(@NonNull InputStream inputStream) throws IOException {
        NpmPackage npmPackage = NpmPackage.fromPackage(Objects.requireNonNull(inputStream));
        npmPackage.getNpm().set("dependencies", (JsonElement)new JsonObject());
        this.getIgLoader().loadPackage(npmPackage, true);
    }

    public List<ValidationMessage> filterValidationMessages(@NonNull List<ValidationMessage> messages) {
        List<Pattern> ignoredPatterns = this.compileSuppressedWarnInfoPatterns();
        return messages.stream().filter(message -> {
            if (message.getLevel() != ValidationMessage.IssueSeverity.WARNING && message.getLevel() != ValidationMessage.IssueSeverity.INFORMATION) {
                return true;
            }
            return ignoredPatterns.parallelStream().noneMatch(pattern -> pattern.matcher(message.getMessage()).find());
        }).collect(Collectors.toList());
    }

    public List<String> filterSlicingMessages(String[] messages) {
        List<Pattern> ignoredPatterns = this.compileSuppressedWarnInfoPatterns();
        return Arrays.asList(messages).stream().filter(message -> ignoredPatterns.parallelStream().noneMatch(pattern -> pattern.matcher((CharSequence)message).find())).collect(Collectors.toList());
    }

    public void addSuppressedWarnInfo(@NonNull String text) {
        this.suppressedWarnInfoPatterns.add(Pattern.quote(Objects.requireNonNull(text)));
    }

    public void addSuppressedWarnInfoPattern(@NonNull String pattern) {
        this.suppressedWarnInfoPatterns.add(Objects.requireNonNull(pattern));
    }

    public List<String> getSuppressedWarnInfoPatterns() {
        return this.suppressedWarnInfoPatterns;
    }

    protected List<Pattern> compileSuppressedWarnInfoPatterns() {
        return this.suppressedWarnInfoPatterns.stream().map(Pattern::compile).collect(Collectors.toList());
    }

    protected OperationOutcome messagesToOutcome(@NonNull List<ValidationMessage> messages, @NonNull SimpleWorkerContext context) throws IOException, FHIRException, EOperationOutcome {
        org.hl7.fhir.r5.model.OperationOutcome op = new org.hl7.fhir.r5.model.OperationOutcome();
        messages.stream().map(vm -> OperationOutcomeUtilities.convertToIssue((ValidationMessage)vm, (org.hl7.fhir.r5.model.OperationOutcome)op)).forEach(op.getIssue()::add);
        RenderingContext rc = new RenderingContext((IWorkerContext)context, null, null, "http://hl7.org/fhir", "", null, RenderingContext.ResourceRendererMode.END_USER, RenderingContext.GenerationRules.VALID_RESOURCE);
        RendererFactory.factory((Resource)op, (RenderingContext)rc).renderResource(ResourceWrapper.forResource((ContextUtilities)rc.getContextUtilities(), (Resource)op));
        return (OperationOutcome)VersionConvertorFactory_40_50.convertResource((Resource)op);
    }

    public void initTxCache(String cacheDir) throws FileNotFoundException, FHIRException, IOException {
        if (cacheDir != null) {
            this.getContext().initTxCache(cacheDir);
            this.getContext().setCachingAllowed(true);
        } else {
            this.getContext().setCachingAllowed(false);
        }
    }

    static {
        try {
            nullEngine = new ValidationEngine.ValidationEngineBuilder().fromNothing();
        }
        catch (IOException e) {
            log.error("problem with inizializin", (Throwable)e);
        }
    }

    public static class MatchboxEngineBuilder
    extends ValidationEngine.ValidationEngineBuilder {
        private String txServer = null;
        private FilesystemPackageCacheMode packageCacheMode = FilesystemPackageCacheMode.USER;
        private String packageCachePath = null;
        private FhirPublication fhirVersion = FhirPublication.R4;
        private boolean withXVersion = false;

        public MatchboxEngineBuilder withXVersion(boolean withXVersion) {
            this.withXVersion = withXVersion;
            return this;
        }

        public void setTxServer(String txServer) {
            this.txServer = txServer;
        }

        public void setPackageCacheMode(FilesystemPackageCacheMode packageCacheMode) {
            this.packageCacheMode = packageCacheMode;
        }

        public void setPackageCachePath(String packageCachePath) {
            this.packageCacheMode = FilesystemPackageCacheMode.CUSTOM;
            this.packageCachePath = packageCachePath;
        }

        public MatchboxEngine getEngineR4() throws MatchboxEngineCreationException {
            MatchboxEngine engine;
            log.info("Initializing Matchbox Engine (FHIR R4 with terminology provided in classpath)");
            log.info(VersionUtil.getPoweredBy());
            try {
                engine = new MatchboxEngine(new SimpleWorkerContext.SimpleWorkerContextBuilder().fromPackage(NpmPackage.fromPackage(((Object)((Object)this)).getClass().getResourceAsStream("/hl7.fhir.r4.core.tgz")), (IContextResourceLoader)ValidatorUtils.loaderForVersion((String)"4.0.1"), false));
            }
            catch (Exception e) {
                throw new MatchboxEngineCreationException(e);
            }
            log.info("loaded hl7.fhir.r4.core#4.0.1");
            engine.setVersion(FhirPublication.R4.toCode());
            try {
                engine.loadPackage(((Object)((Object)this)).getClass().getResourceAsStream("/hl7.terminology#5.4.0.tgz"));
                log.info("loaded hl7.terminology#5.4.0");
                engine.loadPackage(((Object)((Object)this)).getClass().getResourceAsStream("/hl7.fhir.uv.extensions.r4#1.0.0.tgz"));
                log.info("loaded hl7.fhir.uv.extensions.r4");
                if (this.withXVersion) {
                    this.removeStructureMaps(engine);
                    log.info("removed maps");
                    engine.loadPackage(((Object)((Object)this)).getClass().getResourceAsStream("/hl7.fhir.uv.xver#0.1.0@mb.tgz"));
                    log.info("loaded xversion");
                }
            }
            catch (IOException e) {
                throw new IgLoadException(e);
            }
            if (this.txServer == null) {
                engine.getContext().setCanRunWithoutTerminology(true);
                engine.getContext().setNoTerminologyServer(true);
            } else {
                engine.getContext().setCanRunWithoutTerminology(false);
                engine.getContext().setNoTerminologyServer(false);
                try {
                    engine.setTerminologyServer(this.txServer, null, FhirPublication.R4, true);
                }
                catch (Exception e) {
                    throw new TerminologyServerException(e);
                }
            }
            engine.getContext().setPackageTracker((IWorkerContextManager.IPackageLoadingTracker)engine);
            engine.setPcm(this.getFilesystemPackageCacheManager());
            engine.setPolicyAdvisor((IValidationPolicyAdvisor)new ValidationPolicyAdvisor(ReferenceValidationPolicy.CHECK_VALID));
            engine.setAllowExampleUrls(true);
            return engine;
        }

        public MatchboxEngine getEngineR4B() throws MatchboxEngineCreationException {
            MatchboxEngine engine;
            log.info("Initializing Matchbox Engine (FHIR R4B with terminology provided in classpath)");
            log.info(VersionUtil.getPoweredBy());
            try {
                engine = new MatchboxEngine(new SimpleWorkerContext.SimpleWorkerContextBuilder().fromPackage(NpmPackage.fromPackage(((Object)((Object)this)).getClass().getResourceAsStream("/hl7.fhir.r4b.core.tgz")), (IContextResourceLoader)ValidatorUtils.loaderForVersion((String)"4.3.0"), false));
            }
            catch (Exception e) {
                throw new MatchboxEngineCreationException(e);
            }
            engine.setVersion(FhirPublication.R4B.toCode());
            try {
                engine.loadPackage(((Object)((Object)this)).getClass().getResourceAsStream("/hl7.terminology#5.4.0.tgz"));
                engine.loadPackage(((Object)((Object)this)).getClass().getResourceAsStream("/hl7.fhir.uv.extensions.r4#1.0.0.tgz"));
                if (this.withXVersion) {
                    this.removeStructureMaps(engine);
                    engine.loadPackage(((Object)((Object)this)).getClass().getResourceAsStream("/hl7.fhir.uv.xver#0.1.0@mb.tgz"));
                }
            }
            catch (IOException e) {
                throw new IgLoadException(e);
            }
            if (this.txServer == null) {
                engine.getContext().setCanRunWithoutTerminology(true);
                engine.getContext().setNoTerminologyServer(true);
            } else {
                engine.getContext().setCanRunWithoutTerminology(false);
                engine.getContext().setNoTerminologyServer(false);
                try {
                    engine.setTerminologyServer(this.txServer, null, FhirPublication.R4, true);
                }
                catch (Exception e) {
                    throw new TerminologyServerException(e);
                }
            }
            engine.getContext().setPackageTracker((IWorkerContextManager.IPackageLoadingTracker)engine);
            engine.setPcm(this.getFilesystemPackageCacheManager());
            engine.setPolicyAdvisor((IValidationPolicyAdvisor)new ValidationPolicyAdvisor(ReferenceValidationPolicy.CHECK_VALID));
            engine.setAllowExampleUrls(true);
            return engine;
        }

        public void removeStructureMaps(MatchboxEngine engine) {
            for (StructureMap map : engine.getContext().fetchResourcesByType(StructureMap.class)) {
                engine.getContext().dropResource((Resource)map);
            }
        }

        public MatchboxEngine getEngineR5() throws MatchboxEngineCreationException {
            MatchboxEngine engine;
            log.info("Initializing Matchbox Engine (FHIR R5 with terminology provided in classpath)");
            log.info(VersionUtil.getPoweredBy());
            try {
                engine = new MatchboxEngine(new SimpleWorkerContext.SimpleWorkerContextBuilder().fromPackage(NpmPackage.fromPackage(((Object)((Object)this)).getClass().getResourceAsStream("/hl7.fhir.r5.core.tgz")), (IContextResourceLoader)ValidatorUtils.loaderForVersion((String)"5.0.0"), false));
            }
            catch (Exception e) {
                throw new MatchboxEngineCreationException(e);
            }
            engine.setVersion(FhirPublication.R5.toCode());
            try {
                engine.loadPackage(((Object)((Object)this)).getClass().getResourceAsStream("/hl7.terminology#5.4.0.tgz"));
                engine.loadPackage(((Object)((Object)this)).getClass().getResourceAsStream("/hl7.fhir.uv.extensions#1.0.0.tgz"));
                if (this.withXVersion) {
                    this.removeStructureMaps(engine);
                    engine.loadPackage(((Object)((Object)this)).getClass().getResourceAsStream("/hl7.fhir.uv.xver#0.1.0@mb.tgz"));
                }
            }
            catch (IOException e) {
                throw new IgLoadException(e);
            }
            if (this.txServer == null) {
                engine.getContext().setCanRunWithoutTerminology(true);
                engine.getContext().setNoTerminologyServer(true);
            } else {
                engine.getContext().setCanRunWithoutTerminology(false);
                engine.getContext().setNoTerminologyServer(false);
                try {
                    engine.setTerminologyServer(this.txServer, null, FhirPublication.R5, true);
                }
                catch (Exception e) {
                    throw new TerminologyServerException(e);
                }
            }
            engine.setPolicyAdvisor((IValidationPolicyAdvisor)new ValidationPolicyAdvisor(ReferenceValidationPolicy.CHECK_VALID));
            engine.setAllowExampleUrls(true);
            engine.getContext().setPackageTracker((IWorkerContextManager.IPackageLoadingTracker)engine);
            engine.setPcm(this.getFilesystemPackageCacheManager());
            return engine;
        }

        public MatchboxEngine getEngine() throws MatchboxEngineCreationException {
            MatchboxEngine engine;
            log.info("Initializing Matchbox Engine");
            log.info(VersionUtil.getPoweredBy());
            try {
                engine = new MatchboxEngine(this.fromNothing());
            }
            catch (IOException e) {
                throw new MatchboxEngineCreationException(e);
            }
            engine.setVersion(this.fhirVersion.toCode());
            engine.getContext().setAllowLoadingDuplicates(false);
            if (this.txServer == null) {
                engine.getContext().setCanRunWithoutTerminology(true);
                engine.getContext().setNoTerminologyServer(true);
            } else {
                engine.getContext().setCanRunWithoutTerminology(false);
                engine.getContext().setNoTerminologyServer(false);
                try {
                    engine.setTerminologyServer(this.txServer, null, this.fhirVersion, true);
                }
                catch (Exception e) {
                    throw new TerminologyServerException(e);
                }
            }
            engine.getContext().setPackageTracker((IWorkerContextManager.IPackageLoadingTracker)engine);
            engine.setPcm(this.getFilesystemPackageCacheManager());
            engine.setPolicyAdvisor((IValidationPolicyAdvisor)new ValidationPolicyAdvisor(ReferenceValidationPolicy.CHECK_VALID));
            engine.setAllowExampleUrls(true);
            return engine;
        }

        public ValidationEngine fromNothing() throws MatchboxEngineCreationException {
            try {
                return super.fromNothing();
            }
            catch (IOException e) {
                throw new MatchboxEngineCreationException(e);
            }
        }

        public ValidationEngine fromSource(String src) throws IOException, URISyntaxException {
            try {
                return super.fromSource(src);
            }
            catch (IOException e) {
                throw new MatchboxEngineCreationException(e);
            }
        }

        public MatchboxEngineBuilder withVersion(String version) {
            super.withVersion(version);
            this.fhirVersion = FhirPublication.fromCode((String)version);
            return this;
        }

        private FilesystemPackageCacheManager getFilesystemPackageCacheManager() throws MatchboxEngineCreationException {
            try {
                return switch (this.packageCacheMode.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> new FilesystemPackageCacheManager.Builder().build();
                    case 1 -> new FilesystemPackageCacheManager.Builder().withSystemCacheFolder().build();
                    case 2 -> new FilesystemPackageCacheManager.Builder().withTestingCacheFolder().build();
                    case 3 -> new FilesystemPackageCacheManager.Builder().withCacheFolder(this.packageCachePath).build();
                };
            }
            catch (IOException e) {
                throw new MatchboxEngineCreationException(e);
            }
        }
    }

    public static enum FilesystemPackageCacheMode {
        USER,
        SYSTEM,
        TESTING,
        CUSTOM;

    }
}

