/*
 * Decompiled with CFR 0.152.
 */
package ch.ahdis.matchbox.engine.cli;

import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.utilities.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(VersionUtil.class);
    private static String ourVersion;
    private static String ourBuildNumber;
    private static String ourBuildTime;

    public static String getBuildNumber() {
        return ourBuildNumber;
    }

    public static String getBuildTime() {
        return ourBuildTime;
    }

    public static String getVersion() {
        return ourVersion;
    }

    public static String getPoweredBy() {
        return "powered by matchbox " + VersionUtil.getVersion() + ", hapi-fhir " + ca.uhn.fhir.util.VersionUtil.getVersion() + " and org.hl7.fhir.core " + org.hl7.fhir.utilities.VersionUtil.getVersion();
    }

    public static String getMemory() {
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        return "Memory used " + Utilities.describeSize((long)(mbean.getHeapMemoryUsage().getUsed() + mbean.getNonHeapMemoryUsage().getUsed()));
    }

    private static void initialize() {
        try (InputStream is = ca.uhn.fhir.util.VersionUtil.class.getResourceAsStream("/matchbox-build.properties");){
            Properties p = new Properties();
            if (is != null) {
                p.load(is);
            }
            ourVersion = p.getProperty("matchbox.version");
            ourVersion = (String)StringUtils.defaultIfBlank((CharSequence)ourVersion, (CharSequence)"(unknown)");
            ourBuildNumber = p.getProperty("matchbox.buildnumber");
            ourBuildTime = p.getProperty("matchbox.timestamp");
        }
        catch (Exception e) {
            ourLog.warn("Unable to determine version information", (Throwable)e);
        }
    }

    public static String getVersionString() {
        return "Version " + VersionUtil.getVersion() + " (Git# " + StringUtils.left((String)VersionUtil.getBuildNumber(), (int)12) + "). Built " + VersionUtil.getBuildTime();
    }

    static {
        VersionUtil.initialize();
    }
}

