/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.structuremap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.profile.ProfileKnowledgeProvider;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.elementmodel.Property;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRLexer;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.fhirpath.TypeDetails;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceFactory;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UuidType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.structuremap.FHIRPathHostServices;
import org.hl7.fhir.r5.utils.structuremap.ITransformerServices;
import org.hl7.fhir.r5.utils.structuremap.PropertyWithType;
import org.hl7.fhir.r5.utils.structuremap.ResolvedGroup;
import org.hl7.fhir.r5.utils.structuremap.SourceElementComponentWrapper;
import org.hl7.fhir.r5.utils.structuremap.StructureMapAnalysis;
import org.hl7.fhir.r5.utils.structuremap.TargetWriter;
import org.hl7.fhir.r5.utils.structuremap.TransformContext;
import org.hl7.fhir.r5.utils.structuremap.VariableForProfiling;
import org.hl7.fhir.r5.utils.structuremap.VariableMode;
import org.hl7.fhir.r5.utils.structuremap.Variables;
import org.hl7.fhir.r5.utils.structuremap.VariablesForProfiling;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class StructureMapUtilities {
    public static final String MAP_WHERE_CHECK = "map.where.check";
    public static final String MAP_WHERE_LOG = "map.where.log";
    public static final String MAP_WHERE_EXPRESSION = "map.where.expression";
    public static final String MAP_SEARCH_EXPRESSION = "map.search.expression";
    public static final String MAP_EXPRESSION = "map.transform.expression";
    private static final boolean MULTIPLE_TARGETS_ONELINE = true;
    public static final String AUTO_VAR_NAME = "vvv";
    public static final String DEF_GROUP_NAME = "DefaultMappingGroupAnonymousAlias";
    private final IWorkerContext worker;
    private final FHIRPathEngine fpe;
    private ITransformerServices services;
    private ProfileKnowledgeProvider pkp;
    private final Map<String, Integer> ids = new HashMap<String, Integer>();
    private ValidationOptions terminologyServiceOptions = new ValidationOptions(FhirPublication.R5);
    private final ProfileUtilities profileUtilities;
    private boolean exceptionsForChecks = true;
    private boolean debug;

    public StructureMapUtilities(IWorkerContext worker, ITransformerServices services, ProfileKnowledgeProvider pkp) {
        this.worker = worker;
        this.services = services;
        this.pkp = pkp;
        this.fpe = new FHIRPathEngine(worker);
        this.fpe.setHostServices(new FHIRPathHostServices(this));
        this.profileUtilities = new ProfileUtilities(worker, null, null);
    }

    public StructureMapUtilities(IWorkerContext worker, ITransformerServices services) {
        this.worker = worker;
        this.services = services;
        this.fpe = new FHIRPathEngine(worker);
        this.fpe.setHostServices(new FHIRPathHostServices(this));
        this.profileUtilities = new ProfileUtilities(worker, null, null);
    }

    public StructureMapUtilities(IWorkerContext worker) {
        this.worker = worker;
        this.fpe = new FHIRPathEngine(worker);
        this.fpe.setHostServices(new FHIRPathHostServices(this));
        this.profileUtilities = new ProfileUtilities(worker, null, null);
    }

    public static String render(StructureMap map) {
        StringBuilder b = new StringBuilder();
        b.append("/// url = \"" + map.getUrl() + "\"\r\n");
        b.append("/// name = \"" + map.getName() + "\"\r\n");
        b.append("/// title = \"" + map.getTitle() + "\"\r\n");
        b.append("/// status = \"" + map.getStatus().toCode() + "\"\r\n");
        b.append("\r\n");
        if (map.getDescription() != null) {
            StructureMapUtilities.renderMultilineDoco(b, map.getDescription(), 0);
            b.append("\r\n");
        }
        StructureMapUtilities.renderConceptMaps(b, map);
        StructureMapUtilities.renderUses(b, map);
        StructureMapUtilities.renderImports(b, map);
        for (StructureMap.StructureMapGroupComponent g : map.getGroup()) {
            StructureMapUtilities.renderGroup(b, g);
        }
        return b.toString();
    }

    private static void renderConceptMaps(StringBuilder b, StructureMap map) {
        for (Resource r : map.getContained()) {
            if (!(r instanceof ConceptMap)) continue;
            StructureMapUtilities.produceConceptMap(b, (ConceptMap)r);
        }
    }

    private static void produceConceptMap(StringBuilder b, ConceptMap cm) {
        b.append("conceptmap \"");
        b.append(cm.getId());
        b.append("\" {\r\n");
        HashMap<String, String> prefixesSrc = new HashMap<String, String>();
        HashMap<String, String> prefixesTgt = new HashMap<String, String>();
        char prefix = 's';
        for (ConceptMap.ConceptMapGroupComponent cg : cm.getGroup()) {
            if (!prefixesSrc.containsKey(cg.getSource())) {
                prefixesSrc.put(cg.getSource(), String.valueOf(prefix));
                b.append("  prefix ");
                b.append(prefix);
                b.append(" = \"");
                b.append(cg.getSource());
                b.append("\"\r\n");
                prefix = (char)(prefix + '\u0001');
            }
            if (prefixesTgt.containsKey(cg.getTarget())) continue;
            prefixesTgt.put(cg.getTarget(), String.valueOf(prefix));
            b.append("  prefix ");
            b.append(prefix);
            b.append(" = \"");
            b.append(cg.getTarget());
            b.append("\"\r\n");
            prefix = (char)(prefix + '\u0001');
        }
        b.append("\r\n");
        for (ConceptMap.ConceptMapGroupComponent cg : cm.getGroup()) {
            if (!cg.hasUnmapped()) continue;
            b.append("  unmapped for ");
            b.append((String)prefixesSrc.get(cg.getSource()));
            b.append(" = ");
            b.append(cg.getUnmapped().getMode().toCode());
            b.append("\r\n");
        }
        for (ConceptMap.ConceptMapGroupComponent cg : cm.getGroup()) {
            for (ConceptMap.SourceElementComponent ce : cg.getElement()) {
                b.append("  ");
                b.append((String)prefixesSrc.get(cg.getSource()));
                b.append(":");
                if (Utilities.isToken((String)ce.getCode())) {
                    b.append(ce.getCode());
                } else {
                    b.append("\"");
                    b.append(ce.getCode());
                    b.append("\"");
                }
                b.append(" ");
                b.append(StructureMapUtilities.getChar(ce.getTargetFirstRep().getRelationship()));
                b.append(" ");
                b.append((String)prefixesTgt.get(cg.getTarget()));
                b.append(":");
                if (Utilities.isToken((String)ce.getTargetFirstRep().getCode())) {
                    b.append(ce.getTargetFirstRep().getCode());
                } else {
                    b.append("\"");
                    b.append(ce.getTargetFirstRep().getCode());
                    b.append("\"");
                }
                b.append("\r\n");
            }
        }
        b.append("}\r\n\r\n");
    }

    private static Object getChar(Enumerations.ConceptMapRelationship relationship) {
        switch (relationship) {
            case RELATEDTO: {
                return "-";
            }
            case EQUIVALENT: {
                return "==";
            }
            case NOTRELATEDTO: {
                return "!=";
            }
            case SOURCEISNARROWERTHANTARGET: {
                return "<=";
            }
            case SOURCEISBROADERTHANTARGET: {
                return ">=";
            }
        }
        return "??";
    }

    private static void renderUses(StringBuilder b, StructureMap map) {
        for (StructureMap.StructureMapStructureComponent s : map.getStructure()) {
            b.append("uses \"");
            b.append(s.getUrl());
            b.append("\" ");
            if (s.hasAlias()) {
                b.append("alias ");
                b.append(s.getAlias());
                b.append(" ");
            }
            b.append("as ");
            b.append(s.getMode().toCode());
            StructureMapUtilities.renderDoco(b, s.getDocumentation());
            b.append("\r\n");
        }
        if (map.hasStructure()) {
            b.append("\r\n");
        }
    }

    private static void renderImports(StringBuilder b, StructureMap map) {
        for (UriType s : map.getImport()) {
            b.append("imports \"");
            b.append((String)s.getValue());
            b.append("\"\r\n");
        }
        if (map.hasImport()) {
            b.append("\r\n");
        }
    }

    public static String groupToString(StructureMap.StructureMapGroupComponent g) {
        StringBuilder b = new StringBuilder();
        StructureMapUtilities.renderGroup(b, g);
        return b.toString();
    }

    private static void renderGroup(StringBuilder b, StructureMap.StructureMapGroupComponent g) {
        if (g.hasDocumentation()) {
            StructureMapUtilities.renderMultilineDoco(b, g.getDocumentation(), 0);
        }
        b.append("group ");
        b.append(g.getName());
        b.append("(");
        boolean first = true;
        for (StructureMap.StructureMapGroupInputComponent gi : g.getInput()) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(gi.getMode().toCode());
            b.append(" ");
            b.append(gi.getName());
            if (!gi.hasType()) continue;
            b.append(" : ");
            b.append(gi.getType());
        }
        b.append(")");
        if (g.hasExtends()) {
            b.append(" extends ");
            b.append(g.getExtends());
        }
        if (g.hasTypeMode()) {
            switch (g.getTypeMode()) {
                case TYPES: {
                    b.append(" <<types>>");
                    break;
                }
                case TYPEANDTYPES: {
                    b.append(" <<type+>>");
                    break;
                }
            }
        }
        b.append(" {\r\n");
        for (StructureMap.StructureMapGroupRuleComponent r : g.getRule()) {
            StructureMapUtilities.renderRule(b, r, 2);
        }
        b.append("}\r\n\r\n");
    }

    public static String ruleToString(StructureMap.StructureMapGroupRuleComponent r) {
        StringBuilder b = new StringBuilder();
        StructureMapUtilities.renderRule(b, r, 0);
        return b.toString();
    }

    private static void renderRule(StringBuilder b, StructureMap.StructureMapGroupRuleComponent r, int indent) {
        if (r.hasFormatCommentPre()) {
            StructureMapUtilities.renderMultilineDoco(b, r.getFormatCommentsPre(), indent);
        }
        for (int i = 0; i < indent; ++i) {
            b.append(' ');
        }
        boolean canBeAbbreviated = StructureMapUtilities.checkisSimple(r);
        boolean first = true;
        for (StructureMap.StructureMapGroupRuleSourceComponent rs : r.getSource()) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            StructureMapUtilities.renderSource(b, rs, canBeAbbreviated);
        }
        if (r.getTarget().size() > 1) {
            b.append(" -> ");
            first = true;
            for (StructureMap.StructureMapGroupRuleTargetComponent rt : r.getTarget()) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append(' ');
                StructureMapUtilities.renderTarget(b, rt, false);
            }
        } else if (r.hasTarget()) {
            b.append(" -> ");
            StructureMapUtilities.renderTarget(b, (StructureMap.StructureMapGroupRuleTargetComponent)r.getTarget().get(0), canBeAbbreviated);
        }
        if (r.hasRule()) {
            b.append(" then {\r\n");
            for (StructureMap.StructureMapGroupRuleComponent ir : r.getRule()) {
                StructureMapUtilities.renderRule(b, ir, indent + 2);
            }
            for (int i = 0; i < indent; ++i) {
                b.append(' ');
            }
            b.append("}");
        } else if (!canBeAbbreviated && r.hasDependent()) {
            b.append(" then ");
            first = true;
            for (StructureMap.StructureMapGroupRuleDependentComponent rd : r.getDependent()) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append(rd.getName());
                b.append("(");
                boolean ifirst = true;
                for (StructureMap.StructureMapGroupRuleTargetParameterComponent rdp : rd.getParameter()) {
                    if (ifirst) {
                        ifirst = false;
                    } else {
                        b.append(", ");
                    }
                    StructureMapUtilities.renderTransformParam(b, rdp);
                }
                b.append(")");
            }
        }
        if (r.hasName()) {
            Object n = StructureMapUtilities.ntail(r.getName());
            if (!((String)n).startsWith("\"")) {
                n = "\"" + (String)n + "\"";
            }
            if (!StructureMapUtilities.matchesName((String)n, r.getSource())) {
                b.append(" ");
                b.append((String)n);
            }
        }
        b.append(";");
        b.append("\r\n");
    }

    private static boolean matchesName(String n, List<StructureMap.StructureMapGroupRuleSourceComponent> source) {
        if (source.size() != 1) {
            return false;
        }
        if (!source.get(0).hasElement()) {
            return false;
        }
        Object s = source.get(0).getElement();
        if (n.equals(s) || n.equals("\"" + (String)s + "\"")) {
            return true;
        }
        if (source.get(0).hasType()) {
            s = source.get(0).getElement() + "-" + source.get(0).getType();
            return n.equals(s) || n.equals("\"" + (String)s + "\"");
        }
        return false;
    }

    private static String ntail(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("\"")) {
            name = name.substring(1);
            name = name.substring(0, name.length() - 1);
        }
        return "\"" + (name.contains(".") ? name.substring(name.lastIndexOf(".") + 1) : name) + "\"";
    }

    private static boolean checkisSimple(StructureMap.StructureMapGroupRuleComponent r) {
        return r.getSource().size() == 1 && r.getSourceFirstRep().hasElement() && r.getSourceFirstRep().hasVariable() && r.getTarget().size() == 1 && r.getTargetFirstRep().hasVariable() && (r.getTargetFirstRep().getTransform() == null || r.getTargetFirstRep().getTransform() == StructureMap.StructureMapTransform.CREATE) && r.getTargetFirstRep().getParameter().size() == 0 && (r.getDependent().size() == 0 || r.getDependent().size() == 1 && DEF_GROUP_NAME.equals(r.getDependentFirstRep().getName())) && r.getRule().size() == 0;
    }

    public static String sourceToString(StructureMap.StructureMapGroupRuleSourceComponent r) {
        StringBuilder b = new StringBuilder();
        StructureMapUtilities.renderSource(b, r, false);
        return b.toString();
    }

    private static void renderSource(StringBuilder b, StructureMap.StructureMapGroupRuleSourceComponent rs, boolean abbreviate) {
        b.append(rs.getContext());
        if (rs.getContext().equals("@search")) {
            b.append('(');
            b.append(rs.getElement());
            b.append(')');
        } else if (rs.hasElement()) {
            b.append('.');
            b.append(rs.getElement());
        }
        if (rs.hasType()) {
            b.append(" : ");
            b.append(rs.getType());
            if (rs.hasMin()) {
                b.append(" ");
                b.append(rs.getMin());
                b.append("..");
                b.append(rs.getMax());
            }
        }
        if (rs.hasListMode()) {
            b.append(" ");
            b.append(rs.getListMode().toCode());
        }
        if (rs.hasDefaultValue()) {
            b.append(" default ");
            b.append("\"" + Utilities.escapeJson((String)rs.getDefaultValue()) + "\"");
        }
        if (!abbreviate && rs.hasVariable()) {
            b.append(" as ");
            b.append(rs.getVariable());
        }
        if (rs.hasCondition()) {
            b.append(" where ");
            b.append(rs.getCondition());
        }
        if (rs.hasCheck()) {
            b.append(" check ");
            b.append(rs.getCheck());
        }
        if (rs.hasLogMessage()) {
            b.append(" log ");
            b.append(rs.getLogMessage());
        }
    }

    public static String targetToString(StructureMap.StructureMapGroupRuleTargetComponent rt) {
        StringBuilder b = new StringBuilder();
        StructureMapUtilities.renderTarget(b, rt, false);
        return b.toString();
    }

    private static void renderTarget(StringBuilder b, StructureMap.StructureMapGroupRuleTargetComponent rt, boolean abbreviate) {
        if (rt.hasContext()) {
            b.append(rt.getContext());
            if (rt.hasElement()) {
                b.append('.');
                b.append(rt.getElement());
            }
        }
        if (!abbreviate && rt.hasTransform()) {
            if (rt.hasContext()) {
                b.append(" = ");
            }
            if (rt.getTransform() == StructureMap.StructureMapTransform.COPY && rt.getParameter().size() == 1) {
                StructureMapUtilities.renderTransformParam(b, (StructureMap.StructureMapGroupRuleTargetParameterComponent)rt.getParameter().get(0));
            } else if (rt.getTransform() == StructureMap.StructureMapTransform.EVALUATE && rt.getParameter().size() == 1) {
                b.append("(");
                b.append(((StringType)((StructureMap.StructureMapGroupRuleTargetParameterComponent)rt.getParameter().get(0)).getValue()).asStringValue());
                b.append(")");
            } else if (rt.getTransform() == StructureMap.StructureMapTransform.EVALUATE && rt.getParameter().size() == 2) {
                b.append(rt.getTransform().toCode());
                b.append("(");
                b.append(((IdType)((StructureMap.StructureMapGroupRuleTargetParameterComponent)rt.getParameter().get(0)).getValue()).asStringValue());
                b.append(", ");
                b.append(((StringType)((StructureMap.StructureMapGroupRuleTargetParameterComponent)rt.getParameter().get(1)).getValue()).asStringValue());
                b.append(")");
            } else {
                b.append(rt.getTransform().toCode());
                b.append("(");
                boolean first = true;
                for (StructureMap.StructureMapGroupRuleTargetParameterComponent rtp : rt.getParameter()) {
                    if (first) {
                        first = false;
                    } else {
                        b.append(", ");
                    }
                    StructureMapUtilities.renderTransformParam(b, rtp);
                }
                b.append(")");
            }
        }
        if (!abbreviate && rt.hasVariable()) {
            b.append(" as ");
            b.append(rt.getVariable());
        }
        for (Enumeration lm : rt.getListMode()) {
            b.append(" ");
            b.append(((StructureMap.StructureMapTargetListMode)lm.getValue()).toCode());
            if (lm.getValue() != StructureMap.StructureMapTargetListMode.SHARE) continue;
            b.append(" ");
            b.append(rt.getListRuleId());
        }
    }

    public static String paramToString(StructureMap.StructureMapGroupRuleTargetParameterComponent rtp) {
        StringBuilder b = new StringBuilder();
        StructureMapUtilities.renderTransformParam(b, rtp);
        return b.toString();
    }

    private static void renderTransformParam(StringBuilder b, StructureMap.StructureMapGroupRuleTargetParameterComponent rtp) {
        try {
            if (rtp.hasValueBooleanType()) {
                b.append(rtp.getValueBooleanType().asStringValue());
            } else if (rtp.hasValueDecimalType()) {
                b.append(rtp.getValueDecimalType().asStringValue());
            } else if (rtp.hasValueIdType()) {
                b.append(rtp.getValueIdType().asStringValue());
            } else if (rtp.hasValueIntegerType()) {
                b.append(rtp.getValueIntegerType().asStringValue());
            } else {
                b.append("'" + Utilities.escapeJava((String)rtp.getValueStringType().asStringValue()) + "'");
            }
        }
        catch (FHIRException e) {
            e.printStackTrace();
            b.append("error!");
        }
    }

    private static void renderDoco(StringBuilder b, String doco) {
        if (Utilities.noString((String)doco)) {
            return;
        }
        if (b != null && b.length() > 1 && b.charAt(b.length() - 1) != '\n' && b.charAt(b.length() - 1) != ' ') {
            b.append(" ");
        }
        b.append("// ");
        b.append(doco.replace("\r\n", " ").replace("\r", " ").replace("\n", " "));
    }

    private static void renderMultilineDoco(StringBuilder b, String doco, int indent) {
        String[] lines;
        if (Utilities.noString((String)doco)) {
            return;
        }
        for (String line : lines = doco.split("\\r?\\n")) {
            for (int i = 0; i < indent; ++i) {
                b.append(' ');
            }
            StructureMapUtilities.renderDoco(b, line);
            b.append("\r\n");
        }
    }

    private static void renderMultilineDoco(StringBuilder b, List<String> doco, int indent) {
        if (doco == null || doco.isEmpty()) {
            return;
        }
        for (String line : doco) {
            for (int i = 0; i < indent; ++i) {
                b.append(' ');
            }
            StructureMapUtilities.renderDoco(b, line);
            b.append("\r\n");
        }
    }

    public ITransformerServices getServices() {
        return this.services;
    }

    public IWorkerContext getWorker() {
        return this.worker;
    }

    public StructureMap parse(String text, String srcName) throws FHIRException {
        String id;
        FHIRLexer lexer = new FHIRLexer(Utilities.stripBOM((String)text), srcName, true, true);
        if (lexer.done()) {
            throw lexer.error("Map Input cannot be empty");
        }
        StructureMap result = new StructureMap();
        if (lexer.hasToken("map")) {
            lexer.token("map");
            result.setUrl(lexer.readConstant("url"));
            lexer.token("=");
            result.setName(lexer.readConstant("name"));
            result.setDescription(lexer.getAllComments());
            result.setStatus(Enumerations.PublicationStatus.DRAFT);
        }
        block14: while (lexer.hasToken("///")) {
            lexer.next();
            String fid = lexer.takeDottedToken();
            lexer.token("=");
            switch (fid) {
                case "url": {
                    result.setUrl(lexer.readConstant("url"));
                    continue block14;
                }
                case "name": {
                    result.setName(lexer.readConstant("name"));
                    continue block14;
                }
                case "title": {
                    result.setTitle(lexer.readConstant("title"));
                    continue block14;
                }
                case "description": {
                    result.setTitle(lexer.readConstant("description"));
                    continue block14;
                }
                case "status": {
                    result.setStatus(Enumerations.PublicationStatus.fromCode((String)lexer.readConstant("status")));
                    continue block14;
                }
            }
            lexer.readConstant("nothing");
        }
        if (!result.hasId() && result.hasName() && !Utilities.noString((String)(id = Utilities.makeId((String)result.getName())))) {
            result.setId(id);
        }
        if (!result.hasStatus()) {
            result.setStatus(Enumerations.PublicationStatus.DRAFT);
        }
        if (!result.hasDescription() && result.hasTitle()) {
            result.setDescription(result.getTitle());
        }
        while (lexer.hasToken("conceptmap")) {
            this.parseConceptMap(result, lexer);
        }
        while (lexer.hasToken("uses")) {
            this.parseUses(result, lexer);
        }
        while (lexer.hasToken("imports")) {
            this.parseImports(result, lexer);
        }
        while (lexer.hasToken("conceptmap")) {
            this.parseConceptMap(result, lexer);
        }
        while (!lexer.done()) {
            this.parseGroup(result, lexer);
        }
        return result;
    }

    private void parseConceptMap(StructureMap result, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        List comments;
        ConceptMap map = new ConceptMap();
        map.addFormatCommentsPre(lexer.getComments());
        lexer.token("conceptmap");
        String id = lexer.readConstant("map id");
        if (id.startsWith("#")) {
            throw lexer.error("Concept Map identifier must start with #");
        }
        map.setId(id);
        map.setStatus(Enumerations.PublicationStatus.DRAFT);
        result.getContained().add(map);
        lexer.token("{");
        HashMap<String, String> prefixes = new HashMap<String, String>();
        while (lexer.hasToken("prefix")) {
            lexer.token("prefix");
            String n = lexer.take();
            lexer.token("=");
            String v = lexer.readConstant("prefix url");
            prefixes.put(n, v);
        }
        while (lexer.hasToken("unmapped")) {
            comments = lexer.cloneComments();
            lexer.token("unmapped");
            lexer.token("for");
            String n = this.readPrefix(prefixes, lexer);
            ConceptMap.ConceptMapGroupComponent g = this.getGroup(map, n, null);
            g.addFormatCommentsPre(comments);
            lexer.token("=");
            String v = lexer.take();
            if (v.equals("provided")) {
                g.getUnmapped().setMode(ConceptMap.ConceptMapGroupUnmappedMode.USESOURCECODE);
                continue;
            }
            throw lexer.error("Only unmapped mode PROVIDED is supported at this time");
        }
        while (!lexer.hasToken("}")) {
            comments = lexer.cloneComments();
            String srcs = this.readPrefix(prefixes, lexer);
            lexer.token(":");
            String sc = lexer.getCurrent().startsWith("\"") ? lexer.readConstant("code") : lexer.take();
            Enumerations.ConceptMapRelationship rel = this.readRelationship(lexer);
            String tgts = this.readPrefix(prefixes, lexer);
            ConceptMap.ConceptMapGroupComponent g = this.getGroup(map, srcs, tgts);
            ConceptMap.SourceElementComponent e = g.addElement();
            e.addFormatCommentsPre(comments);
            e.setCode(sc);
            if (e.getCode().startsWith("\"")) {
                e.setCode(lexer.processConstant(e.getCode()));
            }
            ConceptMap.TargetElementComponent tgt = e.addTarget();
            tgt.setRelationship(rel);
            lexer.token(":");
            tgt.setCode(lexer.take());
            if (!tgt.getCode().startsWith("\"")) continue;
            tgt.setCode(lexer.processConstant(tgt.getCode()));
        }
        map.addFormatCommentsPost(lexer.getComments());
        lexer.token("}");
    }

    private ConceptMap.ConceptMapGroupComponent getGroup(ConceptMap map, String srcs, String tgts) {
        for (ConceptMap.ConceptMapGroupComponent grp : map.getGroup()) {
            if (!grp.getSource().equals(srcs) || grp.hasTarget() && tgts != null && !tgts.equals(grp.getTarget())) continue;
            if (!grp.hasTarget() && tgts != null) {
                grp.setTarget(tgts);
            }
            return grp;
        }
        ConceptMap.ConceptMapGroupComponent grp = map.addGroup();
        grp.setSource(srcs);
        grp.setTarget(tgts);
        return grp;
    }

    private String readPrefix(Map<String, String> prefixes, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        String prefix = lexer.take();
        if (!prefixes.containsKey(prefix)) {
            throw lexer.error("Unknown prefix '" + prefix + "'");
        }
        return prefixes.get(prefix);
    }

    private Enumerations.ConceptMapRelationship readRelationship(FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        String token = lexer.take();
        if (token.equals("-")) {
            return Enumerations.ConceptMapRelationship.RELATEDTO;
        }
        if (token.equals("==")) {
            return Enumerations.ConceptMapRelationship.EQUIVALENT;
        }
        if (token.equals("!=")) {
            return Enumerations.ConceptMapRelationship.NOTRELATEDTO;
        }
        if (token.equals("<=")) {
            return Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET;
        }
        if (token.equals(">=")) {
            return Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET;
        }
        throw lexer.error("Unknown relationship token '" + token + "'");
    }

    private void parseUses(StructureMap result, FHIRLexer lexer) throws FHIRException {
        String doco;
        lexer.token("uses");
        StructureMap.StructureMapStructureComponent st = result.addStructure();
        st.setUrl(lexer.readConstant("url"));
        if (lexer.hasToken("alias")) {
            lexer.token("alias");
            st.setAlias(lexer.take());
        }
        lexer.token("as");
        if (lexer.getCurrent().equals("source")) {
            st.setMode(StructureMap.StructureMapModelMode.SOURCE);
            doco = lexer.tokenWithTrailingComment("source");
        } else if (lexer.getCurrent().equals("target")) {
            st.setMode(StructureMap.StructureMapModelMode.TARGET);
            doco = lexer.tokenWithTrailingComment("target");
        } else {
            throw lexer.error("Found '" + lexer.getCurrent() + "' expecting 'source' or 'target'");
        }
        if (lexer.hasToken(";")) {
            doco = lexer.tokenWithTrailingComment(";");
        }
        st.setDocumentation(doco);
    }

    private void parseImports(StructureMap result, FHIRLexer lexer) throws FHIRException {
        lexer.token("imports");
        result.addImport(lexer.readConstant("url"));
        lexer.skipToken(";");
    }

    private void parseGroup(StructureMap result, FHIRLexer lexer) throws FHIRException {
        String comment = lexer.getAllComments();
        lexer.token("group");
        StructureMap.StructureMapGroupComponent group = result.addGroup();
        if (comment != null) {
            group.setDocumentation(comment);
        }
        boolean newFmt = false;
        if (lexer.hasToken("for")) {
            lexer.token("for");
            if ("type".equals(lexer.getCurrent())) {
                lexer.token("type");
                lexer.token("+");
                lexer.token("types");
                group.setTypeMode(StructureMap.StructureMapGroupTypeMode.TYPEANDTYPES);
            } else {
                lexer.token("types");
                group.setTypeMode(StructureMap.StructureMapGroupTypeMode.TYPES);
            }
        }
        group.setName(lexer.take());
        if (lexer.hasToken("(")) {
            newFmt = true;
            lexer.take();
            while (!lexer.hasToken(")")) {
                this.parseInput(group, lexer, true);
                if (!lexer.hasToken(",")) continue;
                lexer.token(",");
            }
            lexer.take();
        }
        if (lexer.hasToken("extends")) {
            lexer.next();
            group.setExtends(lexer.take());
        }
        if (newFmt) {
            if (lexer.hasToken("<")) {
                lexer.token("<");
                lexer.token("<");
                if (lexer.hasToken("types")) {
                    group.setTypeMode(StructureMap.StructureMapGroupTypeMode.TYPES);
                    lexer.token("types");
                } else {
                    lexer.token("type");
                    lexer.token("+");
                    group.setTypeMode(StructureMap.StructureMapGroupTypeMode.TYPEANDTYPES);
                }
                lexer.token(">");
                lexer.token(">");
            }
            lexer.token("{");
        }
        if (newFmt) {
            while (!lexer.hasToken("}")) {
                if (lexer.done()) {
                    throw lexer.error("premature termination expecting 'endgroup'");
                }
                this.parseRule(result, group.getRule(), lexer, true);
            }
        } else {
            while (lexer.hasToken("input")) {
                this.parseInput(group, lexer, false);
            }
            while (!lexer.hasToken("endgroup")) {
                if (lexer.done()) {
                    throw lexer.error("premature termination expecting 'endgroup'");
                }
                this.parseRule(result, group.getRule(), lexer, false);
            }
        }
        group.addFormatCommentsPost(lexer.getComments());
        lexer.next();
        if (newFmt && lexer.hasToken(";")) {
            lexer.next();
        }
    }

    private void parseInput(StructureMap.StructureMapGroupComponent group, FHIRLexer lexer, boolean newFmt) throws FHIRException {
        StructureMap.StructureMapGroupInputComponent input = group.addInput();
        if (newFmt) {
            input.setMode(StructureMap.StructureMapInputMode.fromCode((String)lexer.take()));
        } else {
            lexer.token("input");
        }
        input.setName(lexer.take());
        if (lexer.hasToken(":")) {
            lexer.token(":");
            input.setType(lexer.take());
        }
        if (!newFmt) {
            lexer.token("as");
            input.setMode(StructureMap.StructureMapInputMode.fromCode((String)lexer.take()));
            input.setDocumentation(lexer.getAllComments());
            lexer.skipToken(";");
        }
    }

    private void parseRule(StructureMap map, List<StructureMap.StructureMapGroupRuleComponent> list, FHIRLexer lexer, boolean newFmt) throws FHIRException {
        StructureMap.StructureMapGroupRuleComponent rule = new StructureMap.StructureMapGroupRuleComponent();
        if (!newFmt) {
            rule.setName(lexer.takeDottedToken());
            lexer.token(":");
            lexer.token("for");
        } else {
            rule.addFormatCommentsPre(lexer.getComments());
        }
        list.add(rule);
        boolean done = false;
        while (!done) {
            this.parseSource(rule, lexer);
            done = !lexer.hasToken(",");
            if (done) continue;
            lexer.next();
        }
        if (newFmt && lexer.hasToken("->") || !newFmt && lexer.hasToken("make")) {
            lexer.token(newFmt ? "->" : "make");
            done = false;
            while (!done) {
                this.parseTarget(rule, lexer);
                done = !lexer.hasToken(",");
                if (done) continue;
                lexer.next();
            }
        }
        if (lexer.hasToken("then")) {
            lexer.token("then");
            if (lexer.hasToken("{")) {
                lexer.token("{");
                while (!lexer.hasToken("}")) {
                    if (lexer.done()) {
                        throw lexer.error("premature termination expecting '}' in nested group");
                    }
                    this.parseRule(map, rule.getRule(), lexer, newFmt);
                }
                lexer.token("}");
            } else {
                done = false;
                while (!done) {
                    this.parseRuleReference(rule, lexer);
                    done = !lexer.hasToken(",");
                    if (done) continue;
                    lexer.next();
                }
            }
        }
        if (this.isSimpleSyntax(rule)) {
            rule.getSourceFirstRep().setVariable(AUTO_VAR_NAME);
            rule.getTargetFirstRep().setVariable(AUTO_VAR_NAME);
            rule.getTargetFirstRep().setTransform(StructureMap.StructureMapTransform.CREATE);
        }
        if (newFmt) {
            if (lexer.isConstant()) {
                if (lexer.isStringConstant()) {
                    rule.setName(this.fixName(lexer.readConstant("ruleName")));
                } else {
                    rule.setName(lexer.take());
                }
            } else {
                if (rule.getSource().size() != 1 || !rule.getSourceFirstRep().hasElement() && this.exceptionsForChecks) {
                    throw lexer.error("Complex rules must have an explicit name");
                }
                if (rule.getSourceFirstRep().hasType()) {
                    rule.setName(rule.getSourceFirstRep().getElement() + Utilities.capitalize((String)rule.getSourceFirstRep().getType()));
                } else {
                    rule.setName(rule.getSourceFirstRep().getElement());
                }
            }
            String doco = lexer.tokenWithTrailingComment(";");
            if (doco != null) {
                rule.setDocumentation(doco);
            }
        }
    }

    private String fixName(String c) {
        return c.replace("-", "");
    }

    private boolean isSimpleSyntax(StructureMap.StructureMapGroupRuleComponent rule) {
        return rule.getSource().size() == 1 && rule.getSourceFirstRep().hasContext() && rule.getSourceFirstRep().hasElement() && !rule.getSourceFirstRep().hasVariable() && rule.getTarget().size() == 1 && rule.getTargetFirstRep().hasContext() && rule.getTargetFirstRep().hasElement() && !rule.getTargetFirstRep().hasVariable() && !rule.getTargetFirstRep().hasParameter() && rule.getDependent().size() == 0 && rule.getRule().size() == 0;
    }

    private void parseRuleReference(StructureMap.StructureMapGroupRuleComponent rule, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        StructureMap.StructureMapGroupRuleDependentComponent ref = rule.addDependent();
        ref.setName(lexer.take());
        lexer.token("(");
        boolean done = false;
        while (!done) {
            this.parseParameter(ref, lexer);
            done = !lexer.hasToken(",");
            if (done) continue;
            lexer.next();
        }
        lexer.token(")");
    }

    private void parseSource(StructureMap.StructureMapGroupRuleComponent rule, FHIRLexer lexer) throws FHIRException {
        ExpressionNode node;
        StructureMap.StructureMapGroupRuleSourceComponent source = rule.addSource();
        source.setContext(lexer.take());
        if (source.getContext().equals("search") && lexer.hasToken("(")) {
            source.setContext("@search");
            lexer.take();
            node = this.fpe.parse(lexer);
            source.setUserData(MAP_SEARCH_EXPRESSION, (Object)node);
            source.setElement(node.toString());
            lexer.token(")");
        } else if (lexer.hasToken(".")) {
            lexer.token(".");
            source.setElement(this.readAsStringOrProcessedConstant(lexer.take(), lexer));
        }
        if (lexer.hasToken(":")) {
            lexer.token(":");
            source.setType(lexer.takeDottedToken());
        }
        if (Utilities.isInteger((String)lexer.getCurrent())) {
            source.setMin(lexer.takeInt());
            lexer.token("..");
            source.setMax(lexer.take());
        }
        if (lexer.hasToken("default")) {
            lexer.token("default");
            source.setDefaultValue(lexer.readConstant("default value"));
        }
        if (Utilities.existsInList((String)lexer.getCurrent(), (String[])new String[]{"first", "last", "not_first", "not_last", "only_one"})) {
            source.setListMode(StructureMap.StructureMapSourceListMode.fromCode((String)lexer.take()));
        }
        if (lexer.hasToken("as")) {
            lexer.take();
            source.setVariable(lexer.take());
        }
        if (lexer.hasToken("where")) {
            lexer.take();
            node = this.fpe.parse(lexer);
            source.setUserData(MAP_WHERE_EXPRESSION, (Object)node);
            source.setCondition(node.toString());
        }
        if (lexer.hasToken("check")) {
            lexer.take();
            node = this.fpe.parse(lexer);
            source.setUserData(MAP_WHERE_CHECK, (Object)node);
            source.setCheck(node.toString());
        }
        if (lexer.hasToken("log")) {
            lexer.take();
            node = this.fpe.parse(lexer);
            source.setUserData(MAP_WHERE_CHECK, (Object)node);
            source.setLogMessage(node.toString());
        }
    }

    private String readAsStringOrProcessedConstant(String s, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        if (s.startsWith("\"") || s.startsWith("`")) {
            return lexer.processConstant(s);
        }
        return s;
    }

    private void parseTarget(StructureMap.StructureMapGroupRuleComponent rule, FHIRLexer lexer) throws FHIRException {
        String name;
        StructureMap.StructureMapGroupRuleTargetComponent target = rule.addTarget();
        String start = lexer.take();
        if (lexer.hasToken(".")) {
            target.setContext(start);
            start = null;
            lexer.token(".");
            target.setElement(lexer.take());
        }
        boolean isConstant = false;
        if (lexer.hasToken("=")) {
            if (start != null) {
                target.setContext(start);
            }
            lexer.token("=");
            isConstant = lexer.isConstant();
            name = lexer.take();
        } else {
            name = start;
        }
        if ("(".equals(name)) {
            target.setTransform(StructureMap.StructureMapTransform.EVALUATE);
            node = this.fpe.parse(lexer);
            target.setUserData(MAP_EXPRESSION, (Object)node);
            target.addParameter().setValue((DataType)new StringType(node.toString()));
            lexer.token(")");
        } else if (lexer.hasToken("(")) {
            target.setTransform(StructureMap.StructureMapTransform.fromCode((String)name));
            lexer.token("(");
            if (target.getTransform() == StructureMap.StructureMapTransform.EVALUATE) {
                this.parseParameter(target, lexer);
                lexer.token(",");
                node = this.fpe.parse(lexer);
                target.setUserData(MAP_EXPRESSION, (Object)node);
                target.addParameter().setValue((DataType)new StringType(node.toString()));
            } else {
                while (!lexer.hasToken(")")) {
                    this.parseParameter(target, lexer);
                    if (lexer.hasToken(")")) continue;
                    lexer.token(",");
                }
            }
            lexer.token(")");
        } else if (name != null) {
            if (target.getContext() != null) {
                target.setTransform(StructureMap.StructureMapTransform.COPY);
                if (!isConstant) {
                    Object id = name;
                    while (lexer.hasToken(".")) {
                        id = (String)id + lexer.take() + lexer.take();
                    }
                    target.addParameter().setValue((DataType)new IdType((String)id));
                } else {
                    target.addParameter().setValue(this.readConstant(name, lexer));
                }
            } else {
                target.setContext(name);
            }
        }
        if (lexer.hasToken("as")) {
            lexer.take();
            target.setVariable(lexer.take());
        }
        while (Utilities.existsInList((String)lexer.getCurrent(), (String[])new String[]{"first", "last", "share", "collate"})) {
            if (lexer.getCurrent().equals("share")) {
                target.addListMode(StructureMap.StructureMapTargetListMode.SHARE);
                lexer.next();
                target.setListRuleId(lexer.take());
                continue;
            }
            if (lexer.getCurrent().equals("first")) {
                target.addListMode(StructureMap.StructureMapTargetListMode.FIRST);
            } else {
                target.addListMode(StructureMap.StructureMapTargetListMode.LAST);
            }
            lexer.next();
        }
    }

    private void parseParameter(StructureMap.StructureMapGroupRuleDependentComponent ref, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException, FHIRFormatError {
        if (!lexer.isConstant()) {
            ref.addParameter().setValue((DataType)new IdType(lexer.take()));
        } else if (lexer.isStringConstant()) {
            ref.addParameter().setValue((DataType)new StringType(lexer.readConstant("??")));
        } else {
            ref.addParameter().setValue(this.readConstant(lexer.take(), lexer));
        }
    }

    private void parseParameter(StructureMap.StructureMapGroupRuleTargetComponent target, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException, FHIRFormatError {
        if (!lexer.isConstant()) {
            target.addParameter().setValue((DataType)new IdType(lexer.take()));
        } else if (lexer.isStringConstant()) {
            target.addParameter().setValue((DataType)new StringType(lexer.readConstant("??")));
        } else {
            target.addParameter().setValue(this.readConstant(lexer.take(), lexer));
        }
    }

    private DataType readConstant(String s, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        if (Utilities.isInteger((String)s)) {
            return new IntegerType(s);
        }
        if (Utilities.isDecimal((String)s, (boolean)false)) {
            return new DecimalType(s);
        }
        if (Utilities.existsInList((String)s, (String[])new String[]{"true", "false"})) {
            return new BooleanType(s.equals("true"));
        }
        return new StringType(lexer.processConstant(s));
    }

    public StructureDefinition getTargetType(StructureMap map) throws FHIRException {
        boolean found = false;
        StructureDefinition res = null;
        for (StructureMap.StructureMapStructureComponent uses : map.getStructure()) {
            if (uses.getMode() != StructureMap.StructureMapModelMode.TARGET) continue;
            if (found) {
                throw new FHIRException("Multiple targets found in map " + map.getUrl());
            }
            found = true;
            res = (StructureDefinition)this.worker.fetchResource(StructureDefinition.class, uses.getUrl());
            if (res != null) continue;
            throw new FHIRException("Unable to find " + uses.getUrl() + " referenced from map " + map.getUrl());
        }
        if (res == null) {
            throw new FHIRException("No targets found in map " + map.getUrl());
        }
        return res;
    }

    private void log(String cnt) {
        if (this.debug) {
            if (this.getServices() != null) {
                this.getServices().log(cnt);
            } else {
                System.out.println(cnt);
            }
        }
    }

    protected void getChildrenByName(Base item, String name, List<Base> result) throws FHIRException {
        for (Base v : item.listChildrenByName(name, true)) {
            if (v == null) continue;
            result.add(v);
        }
    }

    public void transform(Object appInfo, Base source, StructureMap map, Base target) throws FHIRException {
        TransformContext context = new TransformContext(appInfo);
        this.log("Start Transform " + map.getUrl());
        StructureMap.StructureMapGroupComponent g = (StructureMap.StructureMapGroupComponent)map.getGroup().get(0);
        Variables vars = new Variables();
        vars.add(VariableMode.INPUT, this.getInputName(g, StructureMap.StructureMapInputMode.SOURCE, "source"), source);
        if (target != null) {
            vars.add(VariableMode.OUTPUT, this.getInputName(g, StructureMap.StructureMapInputMode.TARGET, "target"), target);
        } else if (this.getInputName(g, StructureMap.StructureMapInputMode.TARGET, null) != null) {
            String type = this.getInputType(g, StructureMap.StructureMapInputMode.TARGET);
            throw new FHIRException("not handled yet: creating a type of " + type);
        }
        this.executeGroup("", context, map, vars, g, true);
        if (target instanceof Element) {
            ((Element)target).sort();
        }
    }

    private String getInputType(StructureMap.StructureMapGroupComponent g, StructureMap.StructureMapInputMode mode) {
        String type = null;
        for (StructureMap.StructureMapGroupInputComponent inp : g.getInput()) {
            if (inp.getMode() != mode) continue;
            if (type != null) {
                throw new DefinitionException("This engine does not support multiple source inputs");
            }
            type = inp.getType();
        }
        return type;
    }

    private String getInputName(StructureMap.StructureMapGroupComponent g, StructureMap.StructureMapInputMode mode, String def) throws DefinitionException {
        String name = null;
        for (StructureMap.StructureMapGroupInputComponent inp : g.getInput()) {
            if (inp.getMode() != mode) continue;
            if (name != null) {
                throw new DefinitionException("This engine does not support multiple source inputs");
            }
            name = inp.getName();
        }
        return name == null ? def : name;
    }

    private void executeGroup(String indent, TransformContext context, StructureMap map, Variables vars, StructureMap.StructureMapGroupComponent group, boolean atRoot) throws FHIRException {
        this.log(indent + "Group : " + group.getName() + "; vars = " + vars.summary());
        if (group.hasExtends()) {
            ResolvedGroup rg = this.resolveGroupReference(map, group, group.getExtends());
            this.executeGroup(indent + " ", context, rg.getTargetMap(), vars, rg.getTargetGroup(), false);
        }
        for (StructureMap.StructureMapGroupRuleComponent r : group.getRule()) {
            this.executeRule(indent + "  ", context, map, vars, group, r, atRoot);
        }
    }

    private void executeRule(String indent, TransformContext context, StructureMap map, Variables vars, StructureMap.StructureMapGroupComponent group, StructureMap.StructureMapGroupRuleComponent rule, boolean atRoot) throws FHIRException {
        this.log(indent + "rule : " + rule.getName() + "; vars = " + vars.summary());
        Variables srcVars = vars.copy();
        if (rule.getSource().size() != 1) {
            throw new FHIRException("Rule \"" + rule.getName() + "\": not handled yet");
        }
        List<Variables> source = this.processSource(rule.getName(), context, srcVars, (StructureMap.StructureMapGroupRuleSourceComponent)rule.getSource().get(0), map.getUrl(), indent);
        if (source != null) {
            for (Variables v : source) {
                for (StructureMap.StructureMapGroupRuleTargetComponent t : rule.getTarget()) {
                    this.processTarget(map.getName() + "|" + group.getName() + "|" + rule.getName(), context, v, map, group, t, rule.getSource().size() == 1 ? rule.getSourceFirstRep().getVariable() : null, atRoot, vars);
                }
                if (rule.hasRule()) {
                    for (StructureMap.StructureMapGroupRuleComponent childrule : rule.getRule()) {
                        this.executeRule(indent + "  ", context, map, v, group, childrule, false);
                    }
                    continue;
                }
                if (rule.hasDependent() && !StructureMapUtilities.checkisSimple(rule)) {
                    for (StructureMap.StructureMapGroupRuleDependentComponent dependent : rule.getDependent()) {
                        this.executeDependency(indent + "  ", context, map, v, group, dependent);
                    }
                    continue;
                }
                if (!StructureMapUtilities.checkisSimple(rule) && (rule.getSource().size() != 1 || !rule.getSourceFirstRep().hasVariable() || rule.getTarget().size() != 1 || !rule.getTargetFirstRep().hasVariable() || rule.getTargetFirstRep().getTransform() != StructureMap.StructureMapTransform.CREATE || rule.getTargetFirstRep().hasParameter())) continue;
                if (this.debug) {
                    this.log(v.summary());
                }
                Base src = v.get(VariableMode.INPUT, rule.getSourceFirstRep().getVariable());
                Base tgt = v.get(VariableMode.OUTPUT, rule.getTargetFirstRep().getVariable());
                String srcType = src.fhirType();
                String tgtType = tgt.fhirType();
                ResolvedGroup defGroup = this.resolveGroupByTypes(map, rule.getName(), group, srcType, tgtType);
                Variables vdef = new Variables();
                vdef.add(VariableMode.INPUT, ((StructureMap.StructureMapGroupInputComponent)defGroup.getTargetGroup().getInput().get(0)).getName(), src);
                vdef.add(VariableMode.OUTPUT, ((StructureMap.StructureMapGroupInputComponent)defGroup.getTargetGroup().getInput().get(1)).getName(), tgt);
                this.executeGroup(indent + "  ", context, defGroup.getTargetMap(), vdef, defGroup.getTargetGroup(), false);
            }
        }
    }

    private void executeDependency(String indent, TransformContext context, StructureMap map, Variables vin, StructureMap.StructureMapGroupComponent group, StructureMap.StructureMapGroupRuleDependentComponent dependent) throws FHIRException {
        ResolvedGroup rg = this.resolveGroupReference(map, group, dependent.getName());
        if (rg.getTargetGroup().getInput().size() != dependent.getParameter().size()) {
            throw new FHIRException("Rule '" + dependent.getName() + "' has " + rg.getTargetGroup().getInput().size() + " but the invocation has " + dependent.getParameter().size() + " variables");
        }
        Variables v = new Variables();
        for (int i = 0; i < rg.getTargetGroup().getInput().size(); ++i) {
            StructureMap.StructureMapGroupInputComponent input = (StructureMap.StructureMapGroupInputComponent)rg.getTargetGroup().getInput().get(i);
            StructureMap.StructureMapGroupRuleTargetParameterComponent rdp = (StructureMap.StructureMapGroupRuleTargetParameterComponent)dependent.getParameter().get(i);
            String var = rdp.getValue().primitiveValue();
            VariableMode mode = input.getMode() == StructureMap.StructureMapInputMode.SOURCE ? VariableMode.INPUT : VariableMode.OUTPUT;
            Base vv = vin.get(mode, var);
            if (vv == null && mode == VariableMode.INPUT) {
                vv = vin.get(VariableMode.OUTPUT, var);
            }
            if (vv == null) {
                throw new FHIRException("Rule '" + dependent.getName() + "' " + mode.toString() + " variable '" + input.getName() + "' named as '" + var + "' has no value (vars = " + vin.summary() + ")");
            }
            v.add(mode, input.getName(), vv);
        }
        this.executeGroup(indent + "  ", context, rg.getTargetMap(), v, rg.getTargetGroup(), false);
    }

    private String determineTypeFromSourceType(StructureMap map, StructureMap.StructureMapGroupComponent source, Base base, String[] types) throws FHIRException {
        Object result;
        String type = base.fhirType();
        String kn = "type^" + type;
        if (source.hasUserData(kn)) {
            return source.getUserString(kn);
        }
        ResolvedGroup res = new ResolvedGroup(null, null);
        for (StructureMap.StructureMapGroupComponent grp : map.getGroup()) {
            if (!this.matchesByType(map, grp, type)) continue;
            if (res.getTargetMap() == null) {
                res.setTargetMap(map);
                res.setTargetGroup(grp);
                continue;
            }
            throw new FHIRException("Multiple possible matches looking for default rule for '" + type + "'");
        }
        if (res.getTargetMap() != null) {
            result = this.getActualType(res.getTargetMap(), ((StructureMap.StructureMapGroupInputComponent)res.getTargetGroup().getInput().get(1)).getType());
            source.setUserData(kn, result);
            return result;
        }
        for (UriType imp : map.getImport()) {
            List<StructureMap> impMapList = this.findMatchingMaps((String)imp.getValue());
            if (impMapList.size() == 0) {
                throw new FHIRException("Unable to find map(s) for " + (String)imp.getValue());
            }
            for (StructureMap impMap : impMapList) {
                if (impMap.getUrl().equals(map.getUrl())) continue;
                for (StructureMap.StructureMapGroupComponent grp : impMap.getGroup()) {
                    if (!this.matchesByType(impMap, grp, type)) continue;
                    if (res.getTargetMap() == null) {
                        res.setTargetMap(impMap);
                        res.setTargetGroup(grp);
                        continue;
                    }
                    throw new FHIRException("Multiple possible matches for default rule for '" + type + "' in " + res.getTargetMap().getUrl() + " (" + res.getTargetGroup().getName() + ") and " + impMap.getUrl() + " (" + grp.getName() + ")");
                }
            }
        }
        if (res.getTargetGroup() == null) {
            throw new FHIRException("No matches found for default rule for '" + type + "' from " + map.getUrl());
        }
        result = this.getActualType(res.getTargetMap(), ((StructureMap.StructureMapGroupInputComponent)res.getTargetGroup().getInput().get(1)).getType());
        source.setUserData(kn, result);
        return result;
    }

    private List<StructureMap> findMatchingMaps(String value) {
        ArrayList<StructureMap> res = new ArrayList<StructureMap>();
        if (value.contains("*")) {
            for (StructureMap sm : this.worker.fetchResourcesByType(StructureMap.class)) {
                if (!this.urlMatches(value, sm.getUrl())) continue;
                res.add(sm);
            }
        } else {
            StructureMap sm = (StructureMap)this.worker.fetchResource(StructureMap.class, value);
            if (sm != null) {
                res.add(sm);
            }
        }
        HashSet<String> check = new HashSet<String>();
        for (StructureMap sm : res) {
            if (check.contains(sm.getUrl())) {
                throw new FHIRException("duplicate");
            }
            check.add(sm.getUrl());
        }
        return res;
    }

    private boolean urlMatches(String mask, String url) {
        return url.length() > mask.length() && url.startsWith(mask.substring(0, mask.indexOf("*"))) && url.endsWith(mask.substring(mask.indexOf("*") + 1));
    }

    private ResolvedGroup resolveGroupByTypes(StructureMap map, String ruleid, StructureMap.StructureMapGroupComponent source, String srcType, String tgtType) throws FHIRException {
        String kn = "types^" + srcType + ":" + tgtType;
        if (source.hasUserData(kn)) {
            return (ResolvedGroup)source.getUserData(kn);
        }
        ResolvedGroup res = new ResolvedGroup(null, null);
        for (StructureMap.StructureMapGroupComponent grp : map.getGroup()) {
            if (!this.matchesByType(map, grp, srcType, tgtType)) continue;
            if (res.getTargetMap() == null) {
                res.setTargetMap(map);
                res.setTargetGroup(grp);
                continue;
            }
            throw new FHIRException("Multiple possible matches looking for rule for '" + srcType + "/" + tgtType + "', from rule '" + ruleid + "'");
        }
        if (res.getTargetMap() != null) {
            source.setUserData(kn, (Object)res);
            return res;
        }
        for (UriType imp : map.getImport()) {
            List<StructureMap> impMapList = this.findMatchingMaps((String)imp.getValue());
            if (impMapList.size() == 0) {
                throw new FHIRException("Unable to find map(s) for " + (String)imp.getValue());
            }
            for (StructureMap impMap : impMapList) {
                if (impMap.getUrl().equals(map.getUrl())) continue;
                for (StructureMap.StructureMapGroupComponent grp : impMap.getGroup()) {
                    if (!this.matchesByType(impMap, grp, srcType, tgtType)) continue;
                    if (res.getTargetMap() == null) {
                        res.setTargetMap(impMap);
                        res.setTargetGroup(grp);
                        continue;
                    }
                    throw new FHIRException("Multiple possible matches for rule for '" + srcType + "/" + tgtType + "' in " + res.getTargetMap().getUrl() + " and " + impMap.getUrl() + ", from rule '" + ruleid + "'");
                }
            }
        }
        if (res.getTargetGroup() == null) {
            throw new FHIRException("No matches found for rule for '" + srcType + " to " + tgtType + "' from " + map.getUrl() + ", from rule '" + ruleid + "'");
        }
        source.setUserData(kn, (Object)res);
        return res;
    }

    private boolean matchesByType(StructureMap map, StructureMap.StructureMapGroupComponent grp, String type) throws FHIRException {
        if (grp.getTypeMode() != StructureMap.StructureMapGroupTypeMode.TYPEANDTYPES) {
            return false;
        }
        if (grp.getInput().size() != 2 || ((StructureMap.StructureMapGroupInputComponent)grp.getInput().get(0)).getMode() != StructureMap.StructureMapInputMode.SOURCE || ((StructureMap.StructureMapGroupInputComponent)grp.getInput().get(1)).getMode() != StructureMap.StructureMapInputMode.TARGET) {
            return false;
        }
        return this.matchesType(map, type, ((StructureMap.StructureMapGroupInputComponent)grp.getInput().get(0)).getType());
    }

    private boolean matchesByType(StructureMap map, StructureMap.StructureMapGroupComponent grp, String srcType, String tgtType) throws FHIRException {
        if (!grp.hasTypeMode()) {
            return false;
        }
        if (grp.getInput().size() != 2 || ((StructureMap.StructureMapGroupInputComponent)grp.getInput().get(0)).getMode() != StructureMap.StructureMapInputMode.SOURCE || ((StructureMap.StructureMapGroupInputComponent)grp.getInput().get(1)).getMode() != StructureMap.StructureMapInputMode.TARGET) {
            return false;
        }
        if (!((StructureMap.StructureMapGroupInputComponent)grp.getInput().get(0)).hasType() || !((StructureMap.StructureMapGroupInputComponent)grp.getInput().get(1)).hasType()) {
            return false;
        }
        return this.matchesType(map, srcType, ((StructureMap.StructureMapGroupInputComponent)grp.getInput().get(0)).getType()) && this.matchesType(map, tgtType, ((StructureMap.StructureMapGroupInputComponent)grp.getInput().get(1)).getType());
    }

    private boolean matchesType(StructureMap map, String actualType, String statedType) throws FHIRException {
        StructureDefinition sd;
        StructureDefinition sd2;
        for (StructureMap.StructureMapStructureComponent imp : map.getStructure()) {
            if (!imp.hasAlias() || !statedType.equals(imp.getAlias())) continue;
            sd2 = (StructureDefinition)this.worker.fetchResource(StructureDefinition.class, imp.getUrl());
            if (sd2 == null) break;
            statedType = sd2.getType();
            break;
        }
        for (StructureMap.StructureMapStructureComponent imp : map.getStructure()) {
            if (!imp.hasAlias() || !actualType.equals(imp.getAlias())) continue;
            sd2 = (StructureDefinition)this.worker.fetchResource(StructureDefinition.class, imp.getUrl());
            if (sd2 == null) break;
            actualType = sd2.getType();
            break;
        }
        if (Utilities.isAbsoluteUrl((String)actualType) && (sd = (StructureDefinition)this.worker.fetchResource(StructureDefinition.class, actualType)) != null) {
            actualType = sd.getType();
        }
        if (Utilities.isAbsoluteUrl((String)statedType) && (sd = (StructureDefinition)this.worker.fetchResource(StructureDefinition.class, statedType)) != null) {
            statedType = sd.getType();
        }
        return actualType.equals(statedType);
    }

    private String getActualType(StructureMap map, String statedType) throws FHIRException {
        for (StructureMap.StructureMapStructureComponent imp : map.getStructure()) {
            if (!imp.hasAlias() || !statedType.equals(imp.getAlias())) continue;
            StructureDefinition sd = (StructureDefinition)this.worker.fetchResource(StructureDefinition.class, imp.getUrl());
            if (sd == null) {
                throw new FHIRException("Unable to resolve structure " + imp.getUrl());
            }
            return sd.getId();
        }
        return statedType;
    }

    private ResolvedGroup resolveGroupReference(StructureMap map, StructureMap.StructureMapGroupComponent source, String name) throws FHIRException {
        String kn = "ref^" + name;
        if (source.hasUserData(kn)) {
            return (ResolvedGroup)source.getUserData(kn);
        }
        ResolvedGroup res = new ResolvedGroup(null, null);
        for (StructureMap.StructureMapGroupComponent grp : map.getGroup()) {
            if (!grp.getName().equals(name)) continue;
            if (res.getTargetMap() == null) {
                res.setTargetMap(map);
                res.setTargetGroup(grp);
                continue;
            }
            throw new FHIRException("Multiple possible matches for rule '" + name + "'");
        }
        if (res.getTargetMap() != null) {
            source.setUserData(kn, (Object)res);
            return res;
        }
        for (UriType imp : map.getImport()) {
            List<StructureMap> impMapList = this.findMatchingMaps((String)imp.getValue());
            if (impMapList.size() == 0) {
                throw new FHIRException("Unable to find map(s) for " + (String)imp.getValue());
            }
            for (StructureMap impMap : impMapList) {
                if (impMap.getUrl().equals(map.getUrl())) continue;
                for (StructureMap.StructureMapGroupComponent grp : impMap.getGroup()) {
                    if (!grp.getName().equals(name)) continue;
                    if (res.getTargetMap() == null) {
                        res.setTargetMap(impMap);
                        res.setTargetGroup(grp);
                        continue;
                    }
                    throw new FHIRException("Multiple possible matches for rule group '" + name + "' in " + res.getTargetMap().getUrl() + "#" + res.getTargetGroup().getName() + " and " + impMap.getUrl() + "#" + grp.getName());
                }
            }
        }
        if (res.getTargetGroup() == null) {
            throw new FHIRException("No matches found for rule '" + name + "'. Reference found in " + map.getUrl());
        }
        source.setUserData(kn, (Object)res);
        return res;
    }

    private List<Variables> processSource(String ruleId, TransformContext context, Variables vars, StructureMap.StructureMapGroupRuleSourceComponent src, String pathForErrors, String indent) throws FHIRException {
        ArrayList<Base> remove;
        List<Object> items;
        ExpressionNode expr;
        if (src.getContext().equals("@search")) {
            expr = (ExpressionNode)src.getUserData(MAP_SEARCH_EXPRESSION);
            if (expr == null) {
                expr = this.fpe.parse(src.getElement());
                src.setUserData(MAP_SEARCH_EXPRESSION, (Object)expr);
            }
            String search = this.fpe.evaluateToString(vars, null, null, (Base)new StringType(), expr);
            items = this.services.performSearch(context.getAppInfo(), search);
        } else {
            items = new ArrayList<Base>();
            Base b = vars.get(VariableMode.INPUT, src.getContext());
            if (b == null) {
                throw new FHIRException("Unknown input variable " + src.getContext() + " in " + pathForErrors + " rule " + ruleId + " (vars = " + vars.summary() + ")");
            }
            if (!src.hasElement()) {
                items.add(b);
            } else {
                this.getChildrenByName(b, src.getElement(), items);
                if (items.size() == 0 && src.hasDefaultValue()) {
                    items.add(src.getDefaultValueElement());
                }
            }
        }
        if (src.hasType()) {
            ArrayList<Base> remove2 = new ArrayList<Base>();
            for (Base base : items) {
                if (base == null || this.isType(base, src.getType())) continue;
                remove2.add(base);
            }
            items.removeAll(remove2);
        }
        if (src.hasCondition()) {
            expr = (ExpressionNode)src.getUserData(MAP_WHERE_EXPRESSION);
            if (expr == null) {
                expr = this.fpe.parse(src.getCondition());
                src.setUserData(MAP_WHERE_EXPRESSION, (Object)expr);
            }
            remove = new ArrayList<Base>();
            for (Base base : items) {
                if (!this.fpe.evaluateToBoolean((Object)vars, (Resource)null, (Resource)null, base, expr)) {
                    this.log(indent + "  condition [" + src.getCondition() + "] for " + base.toString() + " : false");
                    remove.add(base);
                    continue;
                }
                this.log(indent + "  condition [" + src.getCondition() + "] for " + base.toString() + " : true");
            }
            items.removeAll(remove);
        }
        if (src.hasCheck()) {
            expr = (ExpressionNode)src.getUserData(MAP_WHERE_CHECK);
            if (expr == null) {
                expr = this.fpe.parse(src.getCheck());
                src.setUserData(MAP_WHERE_CHECK, (Object)expr);
            }
            remove = new ArrayList();
            for (Base base : items) {
                if (this.fpe.evaluateToBoolean((Object)vars, (Resource)null, (Resource)null, base, expr)) continue;
                throw new FHIRException("Rule \"" + ruleId + "\": Check condition failed");
            }
        }
        if (src.hasLogMessage()) {
            expr = (ExpressionNode)src.getUserData(MAP_WHERE_LOG);
            if (expr == null) {
                expr = this.fpe.parse(src.getLogMessage());
                src.setUserData(MAP_WHERE_LOG, (Object)expr);
            }
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (Base base : items) {
                b.appendIfNotNull(this.fpe.evaluateToString(vars, null, null, base, expr));
            }
            if (b.length() > 0) {
                this.services.log(b.toString());
            }
        }
        if (src.hasListMode() && !items.isEmpty()) {
            switch (src.getListMode()) {
                case FIRST: {
                    Base bt = (Base)items.get(0);
                    items.clear();
                    items.add(bt);
                    break;
                }
                case NOTFIRST: {
                    if (items.size() <= 0) break;
                    items.remove(0);
                    break;
                }
                case LAST: {
                    Base bt = (Base)items.get(items.size() - 1);
                    items.clear();
                    items.add(bt);
                    break;
                }
                case NOTLAST: {
                    if (items.size() <= 0) break;
                    items.remove(items.size() - 1);
                    break;
                }
                case ONLYONE: {
                    if (items.size() <= 1) break;
                    throw new FHIRException("Rule \"" + ruleId + "\": Check condition failed: the collection has more than one item");
                }
            }
        }
        ArrayList<Variables> result = new ArrayList<Variables>();
        for (Base base : items) {
            Variables variables = vars.copy();
            if (src.hasVariable()) {
                variables.add(VariableMode.INPUT, src.getVariable(), base);
            }
            result.add(variables);
        }
        return result;
    }

    private boolean isType(Base item, String type) {
        return type.equals(item.fhirType());
    }

    private void processTarget(String rulePath, TransformContext context, Variables vars, StructureMap map, StructureMap.StructureMapGroupComponent group, StructureMap.StructureMapGroupRuleTargetComponent tgt, String srcVar, boolean atRoot, Variables sharedVars) throws FHIRException {
        Base dest = null;
        if (tgt.hasContext() && (dest = vars.get(VariableMode.OUTPUT, tgt.getContext())) == null) {
            throw new FHIRException("Rul \"" + rulePath + "\": target context not known: " + tgt.getContext());
        }
        Base v = null;
        if (tgt.hasTransform()) {
            v = this.runTransform(rulePath, context, map, group, tgt, vars, dest, tgt.getElement(), srcVar, atRoot);
            if (v != null && dest != null) {
                try {
                    v = dest.setProperty(tgt.getElement().hashCode(), tgt.getElement(), v);
                }
                catch (Exception e) {
                    throw new FHIRException("Error setting " + tgt.getElement() + " on " + dest.fhirType() + " for rule " + rulePath + " to value " + v.toString() + ": " + e.getMessage(), (Throwable)e);
                }
            }
        } else if (dest != null) {
            if (tgt.hasListMode(StructureMap.StructureMapTargetListMode.SHARE)) {
                v = sharedVars.get(VariableMode.SHARED, tgt.getListRuleId());
                if (v == null) {
                    v = dest.makeProperty(tgt.getElement().hashCode(), tgt.getElement());
                    sharedVars.add(VariableMode.SHARED, tgt.getListRuleId(), v);
                }
            } else {
                v = tgt.hasElement() ? dest.makeProperty(tgt.getElement().hashCode(), tgt.getElement()) : dest;
            }
        }
        if (tgt.hasVariable() && v != null) {
            vars.add(VariableMode.OUTPUT, tgt.getVariable(), v);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Base runTransform(String rulePath, TransformContext context, StructureMap map, StructureMap.StructureMapGroupComponent group, StructureMap.StructureMapGroupRuleTargetComponent tgt, Variables vars, Base dest, String element, String srcVar, boolean root) throws FHIRException {
        try {
            switch (tgt.getTransform()) {
                case CREATE: {
                    Base res;
                    Object tn;
                    if (tgt.getParameter().isEmpty()) {
                        String[] types = dest.getTypesForProperty(element.hashCode(), element);
                        if (types.length == 1 && !"*".equals(types[0]) && !((String)types[0]).equals("Resource")) {
                            tn = types[0];
                        } else {
                            if (srcVar == null) throw new FHIRException("Cannot determine type implicitly because there is no single input variable");
                            tn = this.determineTypeFromSourceType(map, group, vars.get(VariableMode.INPUT, srcVar), types);
                        }
                    } else {
                        tn = this.getParamStringNoNull(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(0), tgt.toString());
                        for (StructureMap.StructureMapStructureComponent uses : map.getStructure()) {
                            if (uses.getMode() != StructureMap.StructureMapModelMode.TARGET || !uses.hasAlias() || !((String)tn).equals(uses.getAlias())) continue;
                            tn = uses.getUrl();
                            break;
                        }
                    }
                    Base base = res = this.services != null ? this.services.createType(context.getAppInfo(), (String)tn) : this.typeFactory((String)tn);
                    if (res.isResource() && !res.fhirType().equals("Parameters") && this.services != null) {
                        res = this.services.createResource(context.getAppInfo(), res, root);
                    }
                    if (!tgt.hasUserData("profile")) return res;
                    res.setUserData("profile", tgt.getUserData("profile"));
                    return res;
                }
                case COPY: {
                    return this.getParam(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(0));
                }
                case EVALUATE: {
                    List<Base> v;
                    ExpressionNode expr = (ExpressionNode)tgt.getUserData(MAP_EXPRESSION);
                    if (expr == null) {
                        expr = this.fpe.parse(this.getParamStringNoNull(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(tgt.getParameter().size() - 1), tgt.toString()));
                        tgt.setUserData(MAP_EXPRESSION, (Object)expr);
                    }
                    if ((v = this.fpe.evaluate((Object)vars, (Resource)null, (Resource)null, (Base)(tgt.getParameter().size() == 2 ? this.getParam(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(0)) : new BooleanType(false)), expr)).size() == 0) {
                        return null;
                    }
                    if (v.size() == 1) return v.get(0);
                    throw new FHIRException("Rule \"" + rulePath + "\": Evaluation of " + expr.toString() + " returned " + v.size() + " objects");
                }
                case TRUNCATE: {
                    String src = this.getParamString(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(0));
                    String len = this.getParamStringNoNull(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(1), tgt.toString());
                    if (!Utilities.isInteger((String)len)) return new StringType(src);
                    int l = Integer.parseInt(len);
                    if (src.length() <= l) return new StringType(src);
                    src = src.substring(0, l);
                    return new StringType(src);
                }
                case ESCAPE: {
                    throw new FHIRException("Rule \"" + rulePath + "\": Transform " + tgt.getTransform().toCode() + " not supported yet");
                }
                case CAST: {
                    String t;
                    String src = this.getParamString(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(0));
                    if (tgt.getParameter().size() == 1) {
                        throw new FHIRException("Implicit type parameters on cast not yet supported");
                    }
                    switch (t = this.getParamString(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(1))) {
                        case "boolean": {
                            return new BooleanType(src);
                        }
                        case "integer": {
                            return new IntegerType(src);
                        }
                        case "integer64": {
                            return new Integer64Type(src);
                        }
                        case "string": {
                            return new StringType(src);
                        }
                        case "decimal": {
                            return new DecimalType(src);
                        }
                        case "uri": {
                            return new UriType(src);
                        }
                        case "base64Binary": {
                            return new Base64BinaryType(src);
                        }
                        case "instant": {
                            return new InstantType(src);
                        }
                        case "date": {
                            return new DateType(src);
                        }
                        case "dateTime": {
                            return new DateTimeType(src);
                        }
                        case "time": {
                            return new TimeType(src);
                        }
                        case "code": {
                            return new CodeType(src);
                        }
                        case "oid": {
                            return new OidType(src);
                        }
                        case "id": {
                            return new IdType(src);
                        }
                        case "markdown": {
                            return new MarkdownType(src);
                        }
                        case "unsignedInt": {
                            return new UnsignedIntType(src);
                        }
                        case "positiveInt": {
                            return new PositiveIntType(src);
                        }
                        case "uuid": {
                            return new UuidType(src);
                        }
                        case "url": {
                            return new UrlType(src);
                        }
                        case "canonical": {
                            return new CanonicalType(src);
                        }
                    }
                    throw new FHIRException("cast to " + t + " not yet supported");
                }
                case APPEND: {
                    StringBuilder sb = new StringBuilder(this.getParamString(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(0)));
                    int i = 1;
                    while (i < tgt.getParameter().size()) {
                        sb.append(this.getParamString(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(i)));
                        ++i;
                    }
                    return new StringType(sb.toString());
                }
                case TRANSLATE: {
                    return this.translate(context, map, vars, tgt.getParameter());
                }
                case REFERENCE: {
                    Base b = this.getParam(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(0));
                    if (b == null) {
                        throw new FHIRException("Rule \"" + rulePath + "\": Unable to find parameter " + ((IdType)((StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(0)).getValue()).asStringValue());
                    }
                    if (!b.isResource()) {
                        throw new FHIRException("Rule \"" + rulePath + "\": Transform engine cannot point at an element of type " + b.fhirType());
                    }
                    String id = b.getIdBase();
                    if (id != null) return new StringType(b.fhirType() + "/" + id);
                    id = UUID.randomUUID().toString().toLowerCase();
                    b.setIdBase(id);
                    return new StringType(b.fhirType() + "/" + id);
                }
                case DATEOP: {
                    throw new FHIRException("Rule \"" + rulePath + "\": Transform " + tgt.getTransform().toCode() + " not supported yet");
                }
                case UUID: {
                    return new IdType(UUID.randomUUID().toString());
                }
                case POINTER: {
                    Base b = this.getParam(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(0));
                    if (!(b instanceof Resource)) throw new FHIRException("Rule \"" + rulePath + "\": Transform engine cannot point at an element of type " + b.fhirType());
                    return new UriType("urn:uuid:" + ((Resource)b).getId());
                }
                case CC: {
                    CodeableConcept cc = new CodeableConcept();
                    cc.addCoding(this.buildCoding(this.getParamStringNoNull(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(0), tgt.toString()), this.getParamStringNoNull(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(1), tgt.toString())));
                    return cc;
                }
                case C: {
                    return this.buildCoding(this.getParamStringNoNull(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(0), tgt.toString()), this.getParamStringNoNull(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(1), tgt.toString()));
                }
            }
            throw new FHIRException("Rule \"" + rulePath + "\": Transform Unknown: " + tgt.getTransform().toCode());
        }
        catch (Exception e) {
            throw new FHIRException("Exception executing transform " + tgt.toString() + " on Rule \"" + rulePath + "\": " + e.getMessage(), (Throwable)e);
        }
    }

    private Base typeFactory(String tn) {
        if (Utilities.isAbsoluteUrl((String)tn) && !tn.startsWith("http://hl7.org/fhir/StructureDefinition")) {
            StructureDefinition sd = this.worker.fetchTypeDefinition(tn);
            if (sd == null && Utilities.existsInList((String)tn, (String[])new String[]{"http://hl7.org/fhirpath/System.String"})) {
                sd = this.worker.fetchTypeDefinition("string");
            }
            if (sd == null) {
                throw new FHIRException("Unable to create type " + tn);
            }
            return Manager.build((IWorkerContext)this.worker, (StructureDefinition)sd);
        }
        return ResourceFactory.createResourceOrType((String)tn);
    }

    private Coding buildCoding(String uri, String code) throws FHIRException {
        ValidationResult vr;
        ValueSet vs;
        String system = null;
        String display = null;
        String version = null;
        ValueSet valueSet = vs = Utilities.noString((String)uri) ? null : (ValueSet)this.worker.fetchResourceWithException(ValueSet.class, uri);
        if (vs != null) {
            ValueSetExpansionOutcome vse = this.worker.expandVS(vs, true, false);
            if (vse.getError() != null) {
                throw new FHIRException(vse.getError());
            }
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (ValueSet.ValueSetExpansionContainsComponent t : vse.getValueset().getExpansion().getContains()) {
                if (t.hasCode()) {
                    b.append(t.getCode());
                }
                if (code.equals(t.getCode()) && t.hasSystem()) {
                    system = t.getSystem();
                    version = t.getVersion();
                    display = t.getDisplay();
                    break;
                }
                if (!code.equalsIgnoreCase(t.getDisplay()) || !t.hasSystem()) continue;
                system = t.getSystem();
                version = t.getVersion();
                display = t.getDisplay();
                break;
            }
            if (system == null) {
                throw new FHIRException("The code '" + code + "' is not in the value set '" + uri + "' (valid codes: " + b.toString() + "; also checked displays)");
            }
        } else {
            system = uri;
        }
        if ((vr = this.worker.validateCode(this.terminologyServiceOptions.withVersionFlexible(true), system, version, code, null)) != null && vr.getDisplay() != null) {
            display = vr.getDisplay();
        }
        return new Coding().setSystem(system).setCode(code).setDisplay(display);
    }

    private String getParamStringNoNull(Variables vars, StructureMap.StructureMapGroupRuleTargetParameterComponent parameter, String message) throws FHIRException {
        Base b = this.getParam(vars, parameter);
        if (b == null) {
            throw new FHIRException("Unable to find a value for " + parameter.toString() + ". Context: " + message);
        }
        if (!b.hasPrimitiveValue()) {
            throw new FHIRException("Found a value for " + parameter.toString() + ", but it has a type of " + b.fhirType() + " and cannot be treated as a string. Context: " + message);
        }
        return b.primitiveValue();
    }

    private String getParamString(Variables vars, StructureMap.StructureMapGroupRuleTargetParameterComponent parameter) throws DefinitionException {
        Base b = this.getParam(vars, parameter);
        if (b == null || !b.hasPrimitiveValue()) {
            return null;
        }
        return b.primitiveValue();
    }

    private Base getParam(Variables vars, StructureMap.StructureMapGroupRuleTargetParameterComponent parameter) throws DefinitionException {
        DataType p = parameter.getValue();
        if (!(p instanceof IdType)) {
            return p;
        }
        String n = ((IdType)p).asStringValue();
        Base b = vars.get(VariableMode.INPUT, n);
        if (b == null) {
            b = vars.get(VariableMode.OUTPUT, n);
        }
        if (b == null) {
            throw new DefinitionException("Variable " + n + " not found (" + vars.summary() + ")");
        }
        return b;
    }

    private Base translate(TransformContext context, StructureMap map, Variables vars, List<StructureMap.StructureMapGroupRuleTargetParameterComponent> parameter) throws FHIRException {
        Base src = this.getParam(vars, parameter.get(0));
        String id = this.getParamString(vars, parameter.get(1));
        String fld = parameter.size() > 2 ? this.getParamString(vars, parameter.get(2)) : null;
        return this.translate(context, map, src, id, fld);
    }

    public Base translate(TransformContext context, StructureMap map, Base source, String conceptMapUrl, String fieldToReturn) throws FHIRException {
        Coding src = new Coding();
        if (source.isPrimitive()) {
            src.setCode(source.primitiveValue());
        } else if ("Coding".equals(source.fhirType())) {
            b = source.getProperty("system".hashCode(), "system", true);
            if (b.length == 1) {
                src.setSystem(b[0].primitiveValue());
            }
            if ((b = source.getProperty("code".hashCode(), "code", true)).length == 1) {
                src.setCode(b[0].primitiveValue());
            }
        } else if ("CE".equals(source.fhirType())) {
            b = source.getProperty("codeSystem".hashCode(), "codeSystem", true);
            if (b.length == 1) {
                src.setSystem(b[0].primitiveValue());
            }
            if ((b = source.getProperty("code".hashCode(), "code", true)).length == 1) {
                src.setCode(b[0].primitiveValue());
            }
        } else {
            throw new FHIRException("Unable to translate source " + source.fhirType());
        }
        Object su = conceptMapUrl;
        if (conceptMapUrl.equals("http://hl7.org/fhir/ConceptMap/special-oid2uri")) {
            Object uri = new ContextUtilities(this.worker).oid2Uri(src.getCode());
            if (uri == null) {
                uri = "urn:oid:" + src.getCode();
            }
            if ("uri".equals(fieldToReturn)) {
                return new UriType((String)uri);
            }
            throw new FHIRException("Error in return code");
        }
        ConceptMap cmap = null;
        if (conceptMapUrl.startsWith("#")) {
            for (Resource r : map.getContained()) {
                if (!(r instanceof ConceptMap) || !r.getId().equals(conceptMapUrl.substring(1))) continue;
                cmap = (ConceptMap)r;
                su = map.getUrl() + "#" + conceptMapUrl;
            }
            if (cmap == null) {
                throw new FHIRException("Unable to translate - cannot find map " + conceptMapUrl);
            }
        } else {
            if (conceptMapUrl.contains("#")) {
                String[] p = conceptMapUrl.split("\\#");
                StructureMap mapU = (StructureMap)this.worker.fetchResource(StructureMap.class, p[0]);
                for (Resource r : mapU.getContained()) {
                    if (!(r instanceof ConceptMap) || !r.getId().equals(p[1])) continue;
                    cmap = (ConceptMap)r;
                    su = conceptMapUrl;
                }
            }
            if (cmap == null) {
                cmap = (ConceptMap)this.worker.fetchResource(ConceptMap.class, conceptMapUrl);
            }
        }
        Coding outcome = null;
        boolean done = false;
        String message = null;
        if (cmap == null) {
            if (this.services == null) {
                message = "No map found for " + conceptMapUrl;
            } else {
                outcome = this.services.translate(context.getAppInfo(), src, conceptMapUrl);
                done = true;
            }
        } else {
            ArrayList<SourceElementComponentWrapper> list = new ArrayList<SourceElementComponentWrapper>();
            for (ConceptMap.ConceptMapGroupComponent g : cmap.getGroup()) {
                for (ConceptMap.SourceElementComponent e : g.getElement()) {
                    if (!src.hasSystem() && src.getCode().equals(e.getCode())) {
                        list.add(new SourceElementComponentWrapper(g, e));
                        continue;
                    }
                    if (!src.hasSystem() || !src.getSystem().equals(g.getSource()) || !src.getCode().equals(e.getCode())) continue;
                    list.add(new SourceElementComponentWrapper(g, e));
                }
            }
            if (list.size() == 0) {
                done = true;
            } else if (((SourceElementComponentWrapper)list.get(0)).getComp().getTarget().size() == 0) {
                message = "Concept map " + (String)su + " found no translation for " + src.getCode();
            } else {
                for (ConceptMap.TargetElementComponent tgt : ((SourceElementComponentWrapper)list.get(0)).getComp().getTarget()) {
                    if (tgt.getRelationship() != null && !EnumSet.of(Enumerations.ConceptMapRelationship.RELATEDTO, Enumerations.ConceptMapRelationship.EQUIVALENT, Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET).contains(tgt.getRelationship())) continue;
                    if (done) {
                        message = "Concept map " + (String)su + " found multiple matches for " + src.getCode();
                        done = false;
                        continue;
                    }
                    done = true;
                    outcome = new Coding().setCode(tgt.getCode()).setSystem(((SourceElementComponentWrapper)list.get(0)).getGroup().getTarget());
                }
                if (!done) {
                    message = "Concept map " + (String)su + " found no usable translation for " + src.getCode();
                }
            }
        }
        if (!done) {
            throw new FHIRException(message);
        }
        if (outcome == null) {
            return null;
        }
        if ("code".equals(fieldToReturn)) {
            return new CodeType(outcome.getCode());
        }
        return outcome;
    }

    public StructureMapAnalysis analyse(Object appInfo, StructureMap map) throws FHIRException {
        this.ids.clear();
        StructureMapAnalysis result = new StructureMapAnalysis();
        TransformContext context = new TransformContext(appInfo);
        VariablesForProfiling vars = new VariablesForProfiling(this, false, false);
        if (map.hasGroup()) {
            StructureMap.StructureMapGroupComponent start = (StructureMap.StructureMapGroupComponent)map.getGroup().get(0);
            for (StructureMap.StructureMapGroupInputComponent t : start.getInput()) {
                PropertyWithType ti = this.resolveType(map, t.getType(), t.getMode());
                if (t.getMode() == StructureMap.StructureMapInputMode.SOURCE) {
                    vars.add(VariableMode.INPUT, t.getName(), ti);
                    continue;
                }
                vars.add(VariableMode.OUTPUT, t.getName(), this.createProfile(map, result.profiles, ti, start.getName(), (Base)start));
            }
            result.summary = new XhtmlNode(NodeType.Element, "table").setAttribute("class", "grid");
            XhtmlNode tr = result.summary.addTag("tr");
            tr.addTag("td").addTag("b").addText("Source");
            tr.addTag("td").addTag("b").addText("Target");
            this.log("Start Profiling Transform " + map.getUrl());
            this.analyseGroup("", context, map, vars, start, result);
        }
        ProfileUtilities pu = new ProfileUtilities(this.worker, null, this.pkp);
        for (StructureDefinition sd : result.getProfiles()) {
            pu.cleanUpDifferential(sd);
        }
        return result;
    }

    private void analyseGroup(String indent, TransformContext context, StructureMap map, VariablesForProfiling vars, StructureMap.StructureMapGroupComponent group, StructureMapAnalysis result) throws FHIRException {
        this.log(indent + "Analyse Group : " + group.getName());
        XhtmlNode tr = result.summary.addTag("tr").setAttribute("class", "diff-title");
        XhtmlNode xs = tr.addTag("td");
        XhtmlNode xt = tr.addTag("td");
        for (StructureMap.StructureMapGroupInputComponent inp : group.getInput()) {
            if (inp.getMode() == StructureMap.StructureMapInputMode.SOURCE) {
                this.noteInput(vars, inp, VariableMode.INPUT, xs);
            }
            if (inp.getMode() != StructureMap.StructureMapInputMode.TARGET) continue;
            this.noteInput(vars, inp, VariableMode.OUTPUT, xt);
        }
        for (StructureMap.StructureMapGroupRuleComponent r : group.getRule()) {
            this.analyseRule(indent + "  ", context, map, vars, group, r, result);
        }
    }

    private void noteInput(VariablesForProfiling vars, StructureMap.StructureMapGroupInputComponent inp, VariableMode mode, XhtmlNode xs) {
        VariableForProfiling v = vars.get(mode, inp.getName());
        if (v != null) {
            xs.addText("Input: " + v.getProperty().getPath());
        }
    }

    private void analyseRule(String indent, TransformContext context, StructureMap map, VariablesForProfiling vars, StructureMap.StructureMapGroupComponent group, StructureMap.StructureMapGroupRuleComponent rule, StructureMapAnalysis result) throws FHIRException {
        this.log(indent + "Analyse rule : " + rule.getName());
        XhtmlNode tr = result.summary.addTag("tr");
        XhtmlNode xs = tr.addTag("td");
        XhtmlNode xt = tr.addTag("td");
        VariablesForProfiling srcVars = vars.copy();
        if (rule.getSource().size() != 1) {
            throw new FHIRException("Rule \"" + rule.getName() + "\": not handled yet");
        }
        VariablesForProfiling source = this.analyseSource(rule.getName(), context, srcVars, rule.getSourceFirstRep(), xs);
        TargetWriter tw = new TargetWriter();
        for (StructureMap.StructureMapGroupRuleTargetComponent t : rule.getTarget()) {
            this.analyseTarget(rule.getName(), context, source, map, t, rule.getSourceFirstRep().getVariable(), tw, result.profiles, rule.getName());
        }
        tw.commit(xt);
        for (StructureMap.StructureMapGroupRuleComponent childrule : rule.getRule()) {
            this.analyseRule(indent + "  ", context, map, source, group, childrule, result);
        }
    }

    private VariablesForProfiling analyseSource(String ruleId, TransformContext context, VariablesForProfiling vars, StructureMap.StructureMapGroupRuleSourceComponent src, XhtmlNode td) throws FHIRException {
        VariableForProfiling var = vars.get(VariableMode.INPUT, src.getContext());
        if (var == null) {
            throw new FHIRException("Rule \"" + ruleId + "\": Unknown input variable " + src.getContext());
        }
        PropertyWithType prop = var.getProperty();
        boolean optional = false;
        boolean repeating = false;
        if (src.hasCondition()) {
            optional = true;
        }
        if (src.hasElement()) {
            Property element = prop.getBaseProperty().getChild(prop.getTypes().getType(), src.getElement());
            if (element == null) {
                throw new FHIRException("Rule \"" + ruleId + "\": Unknown element name " + src.getElement());
            }
            if (element.getDefinition().getMin() == 0) {
                optional = true;
            }
            if (element.getDefinition().getMax().equals("*")) {
                repeating = true;
            }
            VariablesForProfiling result = vars.copy(optional, repeating);
            TypeDetails type = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
            for (ElementDefinition.TypeRefComponent tr : element.getDefinition().getType()) {
                if (!tr.hasCode()) {
                    throw new FHIRException("Rule \"" + ruleId + "\": Element has no type");
                }
                TypeDetails.ProfiledType pt = new TypeDetails.ProfiledType(tr.getWorkingCode());
                if (tr.hasProfile()) {
                    pt.addProfiles(tr.getProfile());
                }
                if (element.getDefinition().hasBinding()) {
                    pt.addBinding(element.getDefinition().getBinding());
                }
                type.addType(pt);
            }
            td.addText(prop.getPath() + "." + src.getElement());
            if (src.hasVariable()) {
                result.add(VariableMode.INPUT, src.getVariable(), new PropertyWithType(prop.getPath() + "." + src.getElement(), element, null, type));
            }
            return result;
        }
        td.addText(prop.getPath());
        return vars.copy(optional, repeating);
    }

    private void analyseTarget(String ruleId, TransformContext context, VariablesForProfiling vars, StructureMap map, StructureMap.StructureMapGroupRuleTargetComponent tgt, String tv, TargetWriter tw, List<StructureDefinition> profiles, String sliceName) throws FHIRException {
        VariableForProfiling var = null;
        if (tgt.hasContext()) {
            var = vars.get(VariableMode.OUTPUT, tgt.getContext());
            if (var == null) {
                throw new FHIRException("Rule \"" + ruleId + "\": target context not known: " + tgt.getContext());
            }
            if (!tgt.hasElement()) {
                throw new FHIRException("Rule \"" + ruleId + "\": Not supported yet");
            }
        }
        TypeDetails type = null;
        if (tgt.hasTransform()) {
            type = this.analyseTransform(context, map, tgt, var, vars);
        } else {
            Property vp = var.getProperty().getBaseProperty().getChild(tgt.getElement(), tgt.getElement());
            if (vp == null) {
                throw new FHIRException("Unknown Property " + tgt.getElement() + " on " + var.getProperty().getPath());
            }
            type = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[]{vp.getType(tgt.getElement())});
        }
        if (tgt.getTransform() == StructureMap.StructureMapTransform.CREATE) {
            String s = this.getParamString(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(0));
            if (this.worker.getResourceNames().contains(s)) {
                tw.newResource(tgt.getVariable(), s);
            }
        } else {
            String td;
            boolean mapsSrc = false;
            for (StructureMap.StructureMapGroupRuleTargetParameterComponent p : tgt.getParameter()) {
                DataType pr = p.getValue();
                if (!(pr instanceof IdType) || !((IdType)pr).asStringValue().equals(tv)) continue;
                mapsSrc = true;
            }
            if (mapsSrc) {
                if (var == null) {
                    throw new FHIRException("Rule \"" + ruleId + "\": Attempt to assign with no context");
                }
                tw.valueAssignment(tgt.getContext(), var.getProperty().getPath() + "." + tgt.getElement() + this.getTransformSuffix(tgt.getTransform()));
            } else if (tgt.hasContext() && this.isSignificantElement(var.getProperty(), tgt.getElement()) && (td = this.describeTransform(tgt)) != null) {
                tw.keyAssignment(tgt.getContext(), var.getProperty().getPath() + "." + tgt.getElement() + " = " + td);
            }
        }
        DataType fixed = this.generateFixedValue(tgt);
        PropertyWithType prop = this.updateProfile(var, tgt.getElement(), type, map, profiles, sliceName, fixed, tgt);
        if (tgt.hasVariable()) {
            if (tgt.hasElement()) {
                vars.add(VariableMode.OUTPUT, tgt.getVariable(), prop);
            } else {
                vars.add(VariableMode.OUTPUT, tgt.getVariable(), prop);
            }
        }
    }

    private DataType generateFixedValue(StructureMap.StructureMapGroupRuleTargetComponent tgt) {
        if (!this.allParametersFixed(tgt)) {
            return null;
        }
        if (!tgt.hasTransform()) {
            return null;
        }
        switch (tgt.getTransform()) {
            case COPY: {
                return ((StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(0)).getValue();
            }
            case TRUNCATE: {
                return null;
            }
            case TRANSLATE: {
                return null;
            }
            case CC: {
                CodeableConcept cc = new CodeableConcept();
                cc.addCoding(this.buildCoding(((StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(0)).getValue(), ((StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(1)).getValue()));
                return cc;
            }
            case C: {
                return this.buildCoding(((StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(0)).getValue(), ((StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(1)).getValue());
            }
            case QTY: {
                return null;
            }
        }
        return null;
    }

    private Coding buildCoding(DataType value1, DataType value2) {
        return new Coding().setSystem(((PrimitiveType)value1).asStringValue()).setCode(((PrimitiveType)value2).asStringValue());
    }

    private boolean allParametersFixed(StructureMap.StructureMapGroupRuleTargetComponent tgt) {
        for (StructureMap.StructureMapGroupRuleTargetParameterComponent p : tgt.getParameter()) {
            DataType pr = p.getValue();
            if (!(pr instanceof IdType)) continue;
            return false;
        }
        return true;
    }

    private String describeTransform(StructureMap.StructureMapGroupRuleTargetComponent tgt) throws FHIRException {
        switch (tgt.getTransform()) {
            case COPY: {
                return null;
            }
            case TRUNCATE: {
                return null;
            }
            case TRANSLATE: {
                return null;
            }
            case CC: {
                return this.describeTransformCCorC(tgt);
            }
            case C: {
                return this.describeTransformCCorC(tgt);
            }
            case QTY: {
                return null;
            }
        }
        return null;
    }

    private String describeTransformCCorC(StructureMap.StructureMapGroupRuleTargetComponent tgt) throws FHIRException {
        if (tgt.getParameter().size() < 2) {
            return null;
        }
        DataType p1 = ((StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(0)).getValue();
        DataType p2 = ((StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(1)).getValue();
        if (p1 instanceof IdType || p2 instanceof IdType) {
            return null;
        }
        if (!(p1 instanceof PrimitiveType) || !(p2 instanceof PrimitiveType)) {
            return null;
        }
        String uri = ((PrimitiveType)p1).asStringValue();
        String code = ((PrimitiveType)p2).asStringValue();
        if (Utilities.noString((String)uri)) {
            throw new FHIRException("Describe Transform, but the uri is blank");
        }
        if (Utilities.noString((String)code)) {
            throw new FHIRException("Describe Transform, but the code is blank");
        }
        Coding c = this.buildCoding(uri, code);
        return c.getSystem() + "#" + c.getCode() + (String)(c.hasDisplay() ? "(" + c.getDisplay() + ")" : "");
    }

    private boolean isSignificantElement(PropertyWithType property, String element) {
        if ("Observation".equals(property.getPath())) {
            return "code".equals(element);
        }
        if ("Bundle".equals(property.getPath())) {
            return "type".equals(element);
        }
        return false;
    }

    private String getTransformSuffix(StructureMap.StructureMapTransform transform) {
        switch (transform) {
            case COPY: {
                return "";
            }
            case TRUNCATE: {
                return " (truncated)";
            }
            case TRANSLATE: {
                return " (translated)";
            }
            case CC: {
                return " (--> CodeableConcept)";
            }
            case C: {
                return " (--> Coding)";
            }
            case QTY: {
                return " (--> Quantity)";
            }
        }
        return " {??)";
    }

    private PropertyWithType updateProfile(VariableForProfiling var, String element, TypeDetails type, StructureMap map, List<StructureDefinition> profiles, String sliceName, DataType fixed, StructureMap.StructureMapGroupRuleTargetComponent tgt) throws FHIRException {
        if (var == null) {
            assert (Utilities.noString((String)element));
            StructureDefinition sdn = (StructureDefinition)this.worker.fetchResource(StructureDefinition.class, type.getType());
            if (sdn == null) {
                throw new FHIRException("Unable to find definition for " + type.getType());
            }
            ElementDefinition edn = sdn.getSnapshot().getElementFirstRep();
            PropertyWithType pn = this.createProfile(map, profiles, new PropertyWithType(sdn.getId(), new Property(this.worker, edn, sdn), null, type), sliceName, (Base)tgt);
            return pn;
        }
        assert (!Utilities.noString((String)element));
        Property pvb = var.getProperty().getBaseProperty();
        Property pvd = var.getProperty().getProfileProperty();
        Property pc = pvb.getChild(element, var.getProperty().getTypes());
        if (pc == null) {
            throw new DefinitionException("Unable to find a definition for " + pvb.getDefinition().getPath() + "." + element);
        }
        StructureDefinition sd = var.getProperty().getProfileProperty().getStructure();
        ElementDefinition ednew = sd.getDifferential().addElement();
        ednew.setPath(var.getProperty().getProfileProperty().getDefinition().getPath() + "." + pc.getName());
        ednew.setUserData("slice-name", (Object)sliceName);
        ednew.setFixed(fixed);
        for (TypeDetails.ProfiledType pt : type.getProfiledTypes()) {
            if (pt.hasBindings()) {
                ednew.setBinding((ElementDefinition.ElementDefinitionBindingComponent)pt.getBindings().get(0));
            }
            if (!pt.getUri().startsWith("http://hl7.org/fhir/StructureDefinition/")) continue;
            String t = pt.getUri().substring(40);
            if ((t = this.checkType(t, pc, pt.getProfiles())) == null) continue;
            if (pt.hasProfiles()) {
                for (String p : pt.getProfiles()) {
                    if (t.equals("Reference")) {
                        ednew.getType(t).addTargetProfile(p);
                        continue;
                    }
                    ednew.getType(t).addProfile(p);
                }
                continue;
            }
            ednew.getType(t);
        }
        return new PropertyWithType(var.getProperty().getPath() + "." + element, pc, new Property(this.worker, ednew, sd), type);
    }

    private String checkType(String t, Property pvb, List<String> profiles) throws FHIRException {
        if (pvb.getDefinition().getType().size() == 1 && this.isCompatibleType(t, ((ElementDefinition.TypeRefComponent)pvb.getDefinition().getType().get(0)).getWorkingCode()) && this.profilesMatch(profiles, ((ElementDefinition.TypeRefComponent)pvb.getDefinition().getType().get(0)).getProfile())) {
            return null;
        }
        for (ElementDefinition.TypeRefComponent tr : pvb.getDefinition().getType()) {
            if (!this.isCompatibleType(t, tr.getWorkingCode())) continue;
            return tr.getWorkingCode();
        }
        throw new FHIRException("The type " + t + " is not compatible with the allowed types for " + pvb.getDefinition().getPath());
    }

    private boolean profilesMatch(List<String> profiles, List<CanonicalType> profile) {
        return profiles == null || profiles.size() == 0 || profile.size() == 0 || profiles.size() == 1 && profiles.get(0).equals(profile.get(0).getValue());
    }

    private boolean isCompatibleType(String t, String code) {
        if (t.equals(code)) {
            return true;
        }
        if (t.equals("string")) {
            StructureDefinition sd = this.worker.fetchTypeDefinition(code);
            return sd != null && sd.getBaseDefinition().equals("http://hl7.org/fhir/StructureDefinition/string");
        }
        return false;
    }

    private TypeDetails analyseTransform(TransformContext context, StructureMap map, StructureMap.StructureMapGroupRuleTargetComponent tgt, VariableForProfiling var, VariablesForProfiling vars) throws FHIRException {
        switch (tgt.getTransform()) {
            case CREATE: {
                String p = this.getParamString(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(0));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[]{p});
            }
            case COPY: {
                return this.getParam(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(0));
            }
            case EVALUATE: {
                ExpressionNode expr = (ExpressionNode)tgt.getUserData(MAP_EXPRESSION);
                if (expr == null) {
                    expr = this.fpe.parse(this.getParamString(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(tgt.getParameter().size() - 1)));
                    tgt.setUserData(MAP_WHERE_EXPRESSION, (Object)expr);
                }
                return this.fpe.check(vars, null, expr);
            }
            case TRANSLATE: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[]{"CodeableConcept"});
            }
            case CC: {
                TypeDetails td;
                TypeDetails.ProfiledType res = new TypeDetails.ProfiledType("CodeableConcept");
                if (tgt.getParameter().size() >= 2 && this.isParamId(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(1)) && (td = vars.get(null, this.getParamId(vars, (StructureMap.StructureMapGroupRuleTargetParameterComponent)tgt.getParameter().get(1))).getProperty().getTypes()) != null && td.hasBinding()) {
                    res.addBinding(td.getBinding());
                }
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, res);
            }
            case C: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[]{"Coding"});
            }
            case QTY: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[]{"Quantity"});
            }
            case REFERENCE: {
                VariableForProfiling vrs = vars.get(VariableMode.OUTPUT, this.getParamId(vars, tgt.getParameterFirstRep()));
                if (vrs == null) {
                    throw new FHIRException("Unable to resolve variable \"" + this.getParamId(vars, tgt.getParameterFirstRep()) + "\"");
                }
                String profile = vrs.getProperty().getProfileProperty().getStructure().getUrl();
                TypeDetails td = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
                td.addType("Reference", profile);
                return td;
            }
            case UUID: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[]{"id"});
            }
        }
        throw new FHIRException("Transform Unknown or not handled yet: " + tgt.getTransform().toCode());
    }

    private String getParamString(VariablesForProfiling vars, StructureMap.StructureMapGroupRuleTargetParameterComponent parameter) {
        DataType p = parameter.getValue();
        if (p == null || p instanceof IdType) {
            return null;
        }
        if (!p.hasPrimitiveValue()) {
            return null;
        }
        return p.primitiveValue();
    }

    private String getParamId(VariablesForProfiling vars, StructureMap.StructureMapGroupRuleTargetParameterComponent parameter) {
        DataType p = parameter.getValue();
        if (p == null || !(p instanceof IdType)) {
            return null;
        }
        return p.primitiveValue();
    }

    private boolean isParamId(VariablesForProfiling vars, StructureMap.StructureMapGroupRuleTargetParameterComponent parameter) {
        DataType p = parameter.getValue();
        if (p == null || !(p instanceof IdType)) {
            return false;
        }
        return vars.get(null, p.primitiveValue()) != null;
    }

    private TypeDetails getParam(VariablesForProfiling vars, StructureMap.StructureMapGroupRuleTargetParameterComponent parameter) throws DefinitionException {
        DataType p = parameter.getValue();
        if (!(p instanceof IdType)) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[]{ProfileUtilities.sdNs((String)p.fhirType(), null)});
        }
        String n = ((IdType)p).asStringValue();
        VariableForProfiling b = vars.get(VariableMode.INPUT, n);
        if (b == null) {
            b = vars.get(VariableMode.OUTPUT, n);
        }
        if (b == null) {
            throw new DefinitionException("Variable " + n + " not found (" + vars.summary() + ")");
        }
        return b.getProperty().getTypes();
    }

    private PropertyWithType createProfile(StructureMap map, List<StructureDefinition> profiles, PropertyWithType prop, String sliceName, Base ctxt) throws FHIRException {
        if (prop.getBaseProperty().getDefinition().getPath().contains(".")) {
            throw new DefinitionException("Unable to process entry point");
        }
        String type = prop.getBaseProperty().getDefinition().getPath();
        Object suffix = "";
        if (this.ids.containsKey(type)) {
            int id = this.ids.get(type);
            this.ids.put(type, ++id);
            suffix = "-" + id;
        } else {
            this.ids.put(type, 0);
        }
        StructureDefinition profile = new StructureDefinition();
        profiles.add(profile);
        profile.setDerivation(StructureDefinition.TypeDerivationRule.CONSTRAINT);
        profile.setType(type);
        profile.setBaseDefinition(prop.getBaseProperty().getStructure().getUrl());
        profile.setName("Profile for " + profile.getType() + " for " + sliceName);
        profile.setUrl(map.getUrl().replace("StructureMap", "StructureDefinition") + "-" + profile.getType() + (String)suffix);
        ctxt.setUserData("profile", (Object)profile.getUrl());
        profile.setId(map.getId() + "-" + profile.getType() + (String)suffix);
        profile.setStatus(map.getStatus());
        profile.setExperimental(map.getExperimental());
        profile.setDescription("Generated automatically from the mapping by the Java Reference Implementation");
        for (ContactDetail c : map.getContact()) {
            ContactDetail p = profile.addContact();
            p.setName(c.getName());
            for (ContactPoint cc : c.getTelecom()) {
                p.addTelecom(cc);
            }
        }
        profile.setDate(map.getDate());
        profile.setCopyright(map.getCopyright());
        profile.setFhirVersion(Enumerations.FHIRVersion.fromCode((String)"5.0.0"));
        profile.setKind(prop.getBaseProperty().getStructure().getKind());
        profile.setAbstract(false);
        ElementDefinition ed = profile.getDifferential().addElement();
        ed.setPath(profile.getType());
        prop.setProfileProperty(new Property(this.worker, ed, profile));
        return prop;
    }

    private PropertyWithType resolveType(StructureMap map, String type, StructureMap.StructureMapInputMode mode) throws FHIRException {
        for (StructureMap.StructureMapStructureComponent imp : map.getStructure()) {
            if ((imp.getMode() != StructureMap.StructureMapModelMode.SOURCE || mode != StructureMap.StructureMapInputMode.SOURCE) && (imp.getMode() != StructureMap.StructureMapModelMode.TARGET || mode != StructureMap.StructureMapInputMode.TARGET)) continue;
            StructureDefinition sd = (StructureDefinition)this.worker.fetchResource(StructureDefinition.class, imp.getUrl());
            if (sd == null) {
                throw new FHIRException("Import " + imp.getUrl() + " cannot be resolved");
            }
            if (!sd.getId().equals(type)) continue;
            return new PropertyWithType(sd.getType(), new Property(this.worker, (ElementDefinition)sd.getSnapshot().getElement().get(0), sd), null, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[]{sd.getUrl()}));
        }
        throw new FHIRException("Unable to find structure definition for " + type + " in imports");
    }

    public StructureMap generateMapFromMappings(StructureDefinition sd) throws IOException, FHIRException {
        String id = this.getLogicalMappingId(sd);
        if (id == null) {
            return null;
        }
        String prefix = ToolingExtensions.readStringExtension((DomainResource)sd, (String)"http://hl7.org/fhir/tools/StructureDefinition/logical-mapping-prefix");
        String suffix = ToolingExtensions.readStringExtension((DomainResource)sd, (String)"http://hl7.org/fhir/tools/StructureDefinition/logical-mapping-suffix");
        if (prefix == null || suffix == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append(prefix);
        ElementDefinition root = sd.getSnapshot().getElementFirstRep();
        String m = this.getMapping(root, id);
        if (m != null) {
            b.append(m + "\r\n");
        }
        this.addChildMappings(b, id, "", sd, root, false);
        b.append("\r\n");
        b.append(suffix);
        b.append("\r\n");
        StructureMap map = this.parse(b.toString(), sd.getUrl());
        map.setId(this.tail(map.getUrl()));
        if (!map.hasStatus()) {
            map.setStatus(Enumerations.PublicationStatus.DRAFT);
        }
        if (!map.hasDescription() && map.hasTitle()) {
            map.setDescription(map.getTitle());
        }
        map.getText().setStatus(Narrative.NarrativeStatus.GENERATED);
        map.getText().setDiv(new XhtmlNode(NodeType.Element, "div"));
        map.getText().getDiv().addTag("pre").addText(StructureMapUtilities.render(map));
        return map;
    }

    private String tail(String url) {
        return url.substring(url.lastIndexOf("/") + 1);
    }

    private void addChildMappings(StringBuilder b, String id, String indent, StructureDefinition sd, ElementDefinition ed, boolean inner) throws DefinitionException {
        boolean first = true;
        List children = this.profileUtilities.getChildMap(sd, ed).getList();
        for (ElementDefinition child : children) {
            String map;
            if (first && inner) {
                b.append(" then {\r\n");
                first = false;
            }
            if ((map = this.getMapping(child, id)) == null) continue;
            b.append(indent + "  " + child.getPath() + ": " + map);
            this.addChildMappings(b, id, indent + "  ", sd, child, true);
            b.append("\r\n");
        }
        if (!first && inner) {
            b.append(indent + "}");
        }
    }

    private String getMapping(ElementDefinition ed, String id) {
        for (ElementDefinition.ElementDefinitionMappingComponent map : ed.getMapping()) {
            if (!id.equals(map.getIdentity())) continue;
            return map.getMap();
        }
        return null;
    }

    private String getLogicalMappingId(StructureDefinition sd) {
        Object id = null;
        for (StructureDefinition.StructureDefinitionMappingComponent map : sd.getMapping()) {
            if (!"http://hl7.org/fhir/logical".equals(map.getUri())) continue;
            return map.getIdentity();
        }
        return null;
    }

    public ValidationOptions getTerminologyServiceOptions() {
        return this.terminologyServiceOptions;
    }

    public void setTerminologyServiceOptions(ValidationOptions terminologyServiceOptions) {
        this.terminologyServiceOptions = terminologyServiceOptions;
    }

    public boolean isExceptionsForChecks() {
        return this.exceptionsForChecks;
    }

    public void setExceptionsForChecks(boolean exceptionsForChecks) {
        this.exceptionsForChecks = exceptionsForChecks;
    }

    public List<StructureMap> getMapsForUrl(List<StructureMap> maps, String url, StructureMap.StructureMapInputMode mode) {
        ArrayList<StructureMap> res = new ArrayList<StructureMap>();
        for (StructureMap map : maps) {
            if (!this.mapIsForUrl(map, url, mode)) continue;
            res.add(map);
        }
        return res;
    }

    private boolean mapIsForUrl(StructureMap map, String url, StructureMap.StructureMapInputMode mode) {
        for (StructureMap.StructureMapGroupComponent grp : map.getGroup()) {
            if (grp.getTypeMode() == StructureMap.StructureMapGroupTypeMode.NULL) continue;
            for (StructureMap.StructureMapGroupInputComponent p : grp.getInput()) {
                String t;
                if (mode != null && mode != p.getMode() || !url.equals(t = this.resolveInputType(p, map))) continue;
                return true;
            }
        }
        return false;
    }

    public List<StructureMap> getMapsForUrlPrefix(List<StructureMap> maps, String url, StructureMap.StructureMapInputMode mode) {
        ArrayList<StructureMap> res = new ArrayList<StructureMap>();
        for (StructureMap map : maps) {
            if (!this.mapIsForUrlPrefix(map, url, mode)) continue;
            res.add(map);
        }
        return res;
    }

    private boolean mapIsForUrlPrefix(StructureMap map, String url, StructureMap.StructureMapInputMode mode) {
        for (StructureMap.StructureMapGroupComponent grp : map.getGroup()) {
            if (grp.getTypeMode() == StructureMap.StructureMapGroupTypeMode.NULL) continue;
            for (StructureMap.StructureMapGroupInputComponent p : grp.getInput()) {
                String t;
                if (mode != null && mode != p.getMode() || (t = this.resolveInputType(p, map)) == null || !t.startsWith(url)) continue;
                return true;
            }
        }
        return false;
    }

    private String resolveInputType(StructureMap.StructureMapGroupInputComponent p, StructureMap map) {
        for (StructureMap.StructureMapStructureComponent struc : map.getStructure()) {
            if (!struc.hasAlias() || !struc.getAlias().equals(p.getType())) continue;
            return struc.getUrl();
        }
        return null;
    }

    public ResolvedGroup getGroupForUrl(StructureMap map, String url, StructureMap.StructureMapInputMode mode) {
        for (StructureMap.StructureMapGroupComponent grp : map.getGroup()) {
            if (grp.getTypeMode() == StructureMap.StructureMapGroupTypeMode.NULL) continue;
            for (StructureMap.StructureMapGroupInputComponent p : grp.getInput()) {
                String t;
                if (mode != null && mode != p.getMode() || !url.equals(t = this.resolveInputType(p, map))) continue;
                return new ResolvedGroup(map, grp);
            }
        }
        return null;
    }

    public String getInputType(ResolvedGroup grp, StructureMap.StructureMapInputMode mode) {
        if (grp.getTargetGroup().getInput().size() != 2 || ((StructureMap.StructureMapGroupInputComponent)grp.getTargetGroup().getInput().get(0)).getMode() == ((StructureMap.StructureMapGroupInputComponent)grp.getTargetGroup().getInput().get(1)).getMode()) {
            return null;
        }
        if (((StructureMap.StructureMapGroupInputComponent)grp.getTargetGroup().getInput().get(0)).getMode() == mode) {
            return this.resolveInputType((StructureMap.StructureMapGroupInputComponent)grp.getTargetGroup().getInput().get(0), grp.getTargetMap());
        }
        return this.resolveInputType((StructureMap.StructureMapGroupInputComponent)grp.getTargetGroup().getInput().get(1), grp.getTargetMap());
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

