/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManagerLocks;
import org.hl7.fhir.utilities.npm.IPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.npm.PackageClient;
import org.hl7.fhir.utilities.npm.PackageList;
import org.hl7.fhir.utilities.npm.PackageServer;
import org.hl7.fhir.utilities.settings.FhirSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemPackageCacheManager
extends BasePackageCacheManager
implements IPackageCacheManager {
    private final FilesystemPackageCacheManagerLocks locks;
    private static final String VER_XVER_PROVIDED = "0.0.13";
    private static IPackageProvider packageProvider;
    public static final String PACKAGE_REGEX = "^[a-zA-Z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+$";
    public static final String PACKAGE_VERSION_REGEX = "^[A-Za-z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+\\#[A-Za-z0-9\\-\\_\\$]+(\\.[A-Za-z0-9\\-\\_\\$]+)*$";
    public static final String PACKAGE_VERSION_REGEX_OPT = "^[A-Za-z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+(\\#[A-Za-z0-9\\-\\_]+(\\.[A-Za-z0-9\\-\\_]+)*)?$";
    private static final Logger ourLog;
    private static final String CACHE_VERSION = "3";
    @Nonnull
    private final File cacheFolder;
    private final List<NpmPackage> temporaryPackages = new ArrayList<NpmPackage>();
    private boolean buildLoaded = false;
    private final Map<String, String> ciList = new HashMap<String, String>();
    private JsonArray buildInfo;
    private boolean suppressErrors;
    private boolean minimalMemory;

    private FilesystemPackageCacheManager(@Nonnull File cacheFolder, @Nonnull List<PackageServer> packageServers) throws IOException {
        super(packageServers);
        this.cacheFolder = cacheFolder;
        try {
            this.locks = FilesystemPackageCacheManagerLocks.getFilesystemPackageCacheManagerLocks((File)cacheFolder);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
        this.prepareCacheFolder();
    }

    protected void prepareCacheFolder() throws IOException {
        this.locks.getCacheLock().doWriteWithLock(() -> {
            if (!this.cacheFolder.exists()) {
                Utilities.createDirectory((String)this.cacheFolder.getAbsolutePath());
                this.createIniFile();
            } else if (!this.isCacheFolderValid()) {
                this.clearCache();
                this.createIniFile();
            } else {
                this.deleteOldTempDirectories();
            }
            return null;
        });
    }

    private boolean isCacheFolderValid() throws IOException {
        String iniPath = this.getPackagesIniPath();
        File iniFile = ManagedFileAccess.file((String)iniPath);
        if (!iniFile.exists()) {
            return false;
        }
        IniFile ini = new IniFile(iniPath);
        String v = ini.getStringProperty("cache", "version");
        return CACHE_VERSION.equals(v);
    }

    private void deleteOldTempDirectories() throws IOException {
        for (File f : Objects.requireNonNull(this.cacheFolder.listFiles())) {
            if (!f.isDirectory() || !Utilities.isValidUUID((String)f.getName())) continue;
            Utilities.clearDirectory((String)f.getAbsolutePath(), (String[])new String[0]);
            f.delete();
        }
    }

    private void initPackageServers() {
        this.myPackageServers.addAll(this.getConfiguredServers());
        if (!this.isIgnoreDefaultPackageServers()) {
            this.myPackageServers.addAll(this.getDefaultServers());
        }
    }

    protected boolean isIgnoreDefaultPackageServers() {
        return FhirSettings.isIgnoreDefaultPackageServers();
    }

    @Nonnull
    protected List<PackageServer> getDefaultServers() {
        return PackageServer.defaultServers();
    }

    protected List<PackageServer> getConfiguredServers() {
        return PackageServer.getConfiguredServers();
    }

    public String getFolder() {
        return this.cacheFolder.getAbsolutePath();
    }

    private NpmPackage loadPackageInfo(String path) throws IOException {
        return this.minimalMemory ? NpmPackage.fromFolderMinimal(path, false) : NpmPackage.fromFolder(path, false);
    }

    private void clearCache() throws IOException {
        for (File f : Objects.requireNonNull(this.cacheFolder.listFiles())) {
            if (f.isDirectory()) {
                Utilities.clearDirectory((String)f.getAbsolutePath(), (String[])new String[0]);
                try {
                    FileUtils.deleteDirectory((File)f);
                }
                catch (Exception e1) {
                    try {
                        FileUtils.deleteDirectory((File)f);
                    }
                    catch (Exception exception) {}
                }
                continue;
            }
            if (f.getName().equals("packages.ini")) continue;
            FileUtils.forceDelete((File)f);
        }
    }

    private void createIniFile() throws IOException {
        IniFile ini = new IniFile(this.getPackagesIniPath());
        ini.setStringProperty("cache", "version", CACHE_VERSION, null);
        ini.save();
    }

    private String getPackagesIniPath() throws IOException {
        return Utilities.path((File)this.cacheFolder, (String[])new String[]{"packages.ini"});
    }

    private void checkValidVersionString(String version, String id) {
        if (Utilities.noString((String)version)) {
            throw new FHIRException("Cannot add package " + id + " to the package cache - a version must be provided");
        }
        if (version.startsWith("file:")) {
            throw new FHIRException("Cannot add package " + id + " to the package cache - the version '" + version + "' is illegal in this context");
        }
        for (char ch : version.toCharArray()) {
            if (Character.isAlphabetic(ch) || Character.isDigit(ch) || Utilities.existsInList((int)ch, (int[])new int[]{46, 45, 36})) continue;
            throw new FHIRException("Cannot add package " + id + " to the package cache - the version '" + version + "' is illegal (ch '" + ch + "'");
        }
    }

    protected BasePackageCacheManager.InputStreamWithSrc loadFromPackageServer(String id, String version) {
        if ("hl7.fhir.xver-extensions".equals(id)) {
            ourLog.info("loading " + id + " from classpath");
            version = VER_XVER_PROVIDED;
            InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + id + "#" + version + ".tgz");
            if (stream == null) {
                ourLog.error("Unable to find/resolve/read from classpath (we dont' want go to the package server) for :" + id + "#" + version + ".tgz");
                throw new FHIRException("Unable to find/resolve/read from classpath (we dont' want go to the package server) for :" + id + "#" + version + ".tgz");
            }
            return new BasePackageCacheManager.InputStreamWithSrc(stream, "http://fhir.org/packages/hl7.fhir.xver-extensions", version);
        }
        if (id.startsWith("hl7.fhir") && id.endsWith("core")) {
            ourLog.info("loading from classpath " + id);
            InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + id + ".tgz");
            if (stream == null) {
                ourLog.error("Unable to find/resolve/read from classpath (we dont' want go to the package server) for :" + id + "#" + version + ".tgz");
                throw new FHIRException("Unable to find/resolve/read from classpath (we dont' want go to the package server) for :" + id + "#" + version + ".tgz");
            }
            return new BasePackageCacheManager.InputStreamWithSrc(stream, "https://hl7.org/fhir/R5/hl7.fhir.r5.core.tgz", version);
        }
        BasePackageCacheManager.InputStreamWithSrc retVal = super.loadFromPackageServer(id, version);
        if (retVal != null) {
            return retVal;
        }
        retVal = super.loadFromPackageServer(id, VersionUtilities.getMajMin((String)version) + ".x");
        if (retVal != null) {
            return retVal;
        }
        return this.fetchTheOldWay(id, version);
    }

    public String getLatestVersion(String id) throws IOException {
        for (PackageServer nextPackageServer : this.getPackageServers()) {
            if (Utilities.existsInList((String)id, (String[])new String[]{"hl7.fhir.pubpack", "hl7.terminology.r5"}) && "https://packages.fhir.org".equals(nextPackageServer.getUrl())) continue;
            PackageClient pc = new PackageClient(nextPackageServer);
            try {
                return pc.getLatestVersion(id);
            }
            catch (IOException e) {
                ourLog.info("Failed to determine latest version of package {} from server: {}", (Object)id, (Object)nextPackageServer.toString());
            }
        }
        try {
            return this.fetchVersionTheOldWay(id);
        }
        catch (Exception e) {
            ourLog.info("Failed to determine latest version of package {} from server: {}", (Object)id, (Object)"build.fhir.org");
            String version = this.getLatestVersionFromCache(id);
            if (version != null) {
                return version;
            }
            throw new FHIRException("Unable to find the last version for package " + id + ": no local copy, and no network access");
        }
    }

    public String getLatestVersionFromCache(String id) throws IOException {
        for (String f : Utilities.reverseSorted((String[])this.cacheFolder.list())) {
            File cf = ManagedFileAccess.file((String)Utilities.path((File)this.cacheFolder, (String[])new String[]{f}));
            if (!cf.isDirectory() || !f.startsWith(id + "#")) continue;
            String ver = f.substring(f.indexOf("#") + 1);
            ourLog.info("Latest version of package {} found locally is {} - using that", (Object)id, (Object)ver);
            return ver;
        }
        return null;
    }

    private NpmPackage loadPackageFromFile(String id, String folder) throws IOException {
        File f = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{folder, id}));
        if (!f.exists()) {
            throw new FHIRException("Package '" + id + "  not found in folder " + folder);
        }
        if (!f.isDirectory()) {
            throw new FHIRException("File for '" + id + "  found in folder " + folder + ", not a folder");
        }
        File fp = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{folder, id, "package", "package.json"}));
        if (!fp.exists()) {
            throw new FHIRException("Package '" + id + "  found in folder " + folder + ", but does not contain a package.json file in /package");
        }
        return NpmPackage.fromFolder(f.getAbsolutePath());
    }

    public void clear() throws IOException {
        this.locks.getCacheLock().doWriteWithLock(() -> {
            this.clearCache();
            return null;
        });
    }

    public void removePackage(String id, String version) throws IOException {
        this.locks.getPackageLock(id + "#" + version).doWriteWithLock(() -> {
            String f = Utilities.path((File)this.cacheFolder, (String[])new String[]{id + "#" + version});
            File ff = ManagedFileAccess.file((String)f);
            if (ff.exists()) {
                Utilities.clearDirectory((String)f, (String[])new String[0]);
                ff.delete();
            }
            return null;
        });
    }

    public NpmPackage loadPackageFromCacheOnly(String id, String version) throws IOException {
        NpmPackage foundPackage;
        if (!Utilities.noString((String)version) && version.startsWith("file:")) {
            return this.loadPackageFromFile(id, version.substring(5));
        }
        for (NpmPackage p : this.temporaryPackages) {
            if (p.name().equals(id) && ("current".equals(version) || "dev".equals(version) || p.version().equals(version))) {
                return p;
            }
            if (!p.name().equals(id) || !Utilities.noString((String)version)) continue;
            return p;
        }
        String foundPackageFolder = this.findPackageFolder(id, version);
        if (foundPackageFolder != null && (foundPackage = (NpmPackage)this.locks.getPackageLock(foundPackageFolder).doReadWithLock(() -> {
            String path = Utilities.path((File)this.cacheFolder, (String[])new String[]{foundPackageFolder});
            File directory = ManagedFileAccess.file((String)path);
            if (!directory.exists()) {
                return null;
            }
            return this.loadPackageInfo(path);
        })) != null) {
            if (foundPackage.isIndexed()) {
                return foundPackage;
            }
            return (NpmPackage)this.locks.getPackageLock(foundPackageFolder).doWriteWithLock(() -> {
                File directory = ManagedFileAccess.file((String)foundPackage.getPath());
                if (!directory.exists()) {
                    return null;
                }
                NpmPackage output = this.loadPackageInfo(foundPackage.getPath());
                if (output.isIndexed()) {
                    return output;
                }
                String path = Utilities.path((File)this.cacheFolder, (String[])new String[]{foundPackageFolder});
                output.checkIndexed(path);
                return output;
            });
        }
        if ("dev".equals(version)) {
            return this.loadPackageFromCacheOnly(id, "current");
        }
        return null;
    }

    private String findPackageFolder(String id, String version) throws IOException {
        String foundPackageFolder = null;
        String foundVersion = null;
        for (String currentPackageFolder : Utilities.reverseSorted((String[])this.cacheFolder.list())) {
            String[] parts;
            File cf = ManagedFileAccess.file((String)Utilities.path((File)this.cacheFolder, (String[])new String[]{currentPackageFolder}));
            if (!cf.isDirectory()) continue;
            if (currentPackageFolder.equals(id + "#" + version) || Utilities.noString((String)version) && currentPackageFolder.startsWith(id + "#")) {
                return currentPackageFolder;
            }
            if (version == null || version.equals("current") || !version.endsWith(".x") && Utilities.charCount((String)version, (char)'.') >= 2 || !currentPackageFolder.contains("#") || !(parts = currentPackageFolder.split("#"))[0].equals(id) || !VersionUtilities.isMajMinOrLaterPatch((String)(foundVersion != null ? foundVersion : version), (String)parts[1])) continue;
            foundVersion = parts[1];
            foundPackageFolder = currentPackageFolder;
        }
        return foundPackageFolder;
    }

    public NpmPackage addPackageToCache(String id, String version, InputStream packageTgzInputStream, String sourceDesc) throws IOException {
        if ("hl7.fhir.xver-extensions".equals(id)) {
            NpmPackage npm = NpmPackage.fromPackage(packageTgzInputStream, sourceDesc, true);
            return npm;
        }
        if ("hl7.cda.uv.core".equals(id)) {
            NpmPackage npm = NpmPackage.fromPackage(packageTgzInputStream, sourceDesc, true);
            return npm;
        }
        this.checkValidVersionString(version, id);
        return (NpmPackage)this.locks.getPackageLock(id + "#" + version).doWriteWithLock(() -> {
            String uuid = UUID.randomUUID().toString().toLowerCase();
            String tempDir = Utilities.path((File)this.cacheFolder, (String[])new String[]{uuid});
            NpmPackage npm = NpmPackage.extractFromTgz(packageTgzInputStream, sourceDesc, tempDir, this.minimalMemory);
            this.log("");
            this.log("Installing " + id + "#" + version);
            if (!(npm.name() == null || id == null || id.equalsIgnoreCase(npm.name()) || this.suppressErrors || id.equals("hl7.fhir.r5.core") || id.equals("hl7.fhir.us.immds"))) {
                throw new IOException("Attempt to import a mis-identified package. Expected " + id + ", got " + npm.name());
            }
            NpmPackage npmPackage = null;
            String packageRoot = Utilities.path((File)this.cacheFolder, (String[])new String[]{id + "#" + version});
            try {
                if (!ManagedFileAccess.file((String)packageRoot).exists() || Utilities.existsInList((String)version, (String[])new String[]{"current", "dev"})) {
                    Utilities.createDirectory((String)packageRoot);
                    try {
                        Utilities.clearDirectory((String)packageRoot, (String[])new String[0]);
                    }
                    catch (Throwable t) {
                        this.log("Unable to clear directory: " + packageRoot + ": " + t.getMessage() + " - this may cause problems later");
                    }
                    Utilities.renameDirectory((String)tempDir, (String)packageRoot);
                    this.log(" done.");
                } else {
                    Utilities.clearDirectory((String)tempDir, (String[])new String[0]);
                    ManagedFileAccess.file((String)tempDir).delete();
                }
                if (!id.equals(npm.getNpm().asString("name")) || !version.equals(npm.getNpm().asString("version"))) {
                    if (!id.equals(npm.getNpm().asString("name"))) {
                        npm.getNpm().add("original-name", npm.getNpm().asString("name"));
                        npm.getNpm().remove("name");
                        npm.getNpm().add("name", id);
                    }
                    if (!version.equals(npm.getNpm().asString("version"))) {
                        npm.getNpm().add("original-version", npm.getNpm().asString("version"));
                        npm.getNpm().remove("version");
                        npm.getNpm().add("version", version);
                    }
                    TextFile.stringToFile((String)JsonParser.compose((JsonElement)npm.getNpm(), (boolean)true), (String)Utilities.path((File)this.cacheFolder, (String[])new String[]{id + "#" + version, "package", "package.json"}));
                }
                if ((npmPackage = this.loadPackageInfo(packageRoot)) != null && !npmPackage.isIndexed()) {
                    npmPackage.checkIndexed(packageRoot);
                }
            }
            catch (Exception e) {
                try {
                    this.log("Clean up package " + packageRoot + " because installation failed: " + e.getMessage());
                    e.printStackTrace();
                    Utilities.clearDirectory((String)packageRoot, (String[])new String[0]);
                    ManagedFileAccess.file((String)packageRoot).delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            return npmPackage;
        });
    }

    private void log(String s) {
        if (!this.silent) {
            System.out.println(s);
        }
    }

    public String getPackageUrl(String packageId) throws IOException {
        String result = super.getPackageUrl(packageId);
        if (result == null) {
            result = this.getPackageUrlFromBuildList(packageId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFolder(String packagesFolder) throws IOException {
        assert (!this.minimalMemory);
        File[] files = ManagedFileAccess.file((String)packagesFolder).listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.getName().endsWith(".tgz")) continue;
                try (FileInputStream fs = ManagedFileAccess.inStream((File)f);){
                    this.temporaryPackages.add(NpmPackage.fromPackage(fs));
                }
            }
        }
    }

    public NpmPackage loadPackage(String id, String version) throws FHIRException, IOException {
        NpmPackage p;
        if ("hl7.fhir.xver-extensions".equals(id)) {
            BasePackageCacheManager.InputStreamWithSrc packageTgzInputStream = this.loadFromPackageServer(id, version);
            NpmPackage npm = NpmPackage.fromPackage(packageTgzInputStream.stream);
            npm.getNpm().set("version", "4.0");
            return npm;
        }
        if ("hl7.fhir.r5.core".equals(id)) {
            BasePackageCacheManager.InputStreamWithSrc packageTgzInputStream = this.loadFromPackageServer(id, version);
            NpmPackage npm = NpmPackage.fromPackage(packageTgzInputStream.stream);
            return npm;
        }
        if (!Utilities.noString((String)version) && version.startsWith("file:")) {
            return this.loadPackageFromFile(id, version.substring(5));
        }
        if (version == null && id.contains("#")) {
            version = id.substring(id.indexOf("#") + 1);
            id = id.substring(0, id.indexOf("#"));
        }
        if (version == null) {
            try {
                version = this.getLatestVersion(id);
            }
            catch (Exception e) {
                version = null;
            }
        }
        if ((p = this.loadPackageFromCacheOnly(id, version)) != null) {
            if ("current".equals(version)) {
                p = this.checkCurrency(id, p);
            }
            if (p != null) {
                return p;
            }
        }
        if ("dev".equals(version)) {
            p = this.loadPackageFromCacheOnly(id, "current");
            if ((p = this.checkCurrency(id, p)) != null) {
                return p;
            }
            version = "current";
        }
        this.log("Installing " + id + "#" + (version == null ? "?" : version) + " to the package cache");
        this.log("  Fetching:");
        BasePackageCacheManager.InputStreamWithSrc source = packageProvider != null && packageProvider.handlesPackage(id, version) ? packageProvider.provide(id, version) : (Utilities.isAbsoluteUrl((String)version) ? this.fetchSourceFromUrlSpecific(version) : ("current".equals(version) || version != null && version.startsWith("current$") ? this.loadFromCIBuild(id, version.startsWith("current$") ? version.substring(8) : null) : this.loadFromPackageServer(id, version)));
        if (source == null) {
            throw new FHIRException("Unable to find package " + id + "#" + version);
        }
        return this.addPackageToCache(id, source.version, source.stream, source.url);
    }

    private BasePackageCacheManager.InputStreamWithSrc fetchSourceFromUrlSpecific(String url) {
        return new BasePackageCacheManager.InputStreamWithSrc(this.fetchFromUrlSpecific(url, false), url, "current");
    }

    private InputStream fetchFromUrlSpecific(String source, boolean optional) throws FHIRException {
        try {
            HTTPResult res = ManagedWebAccess.get((String)source);
            res.checkThrowException();
            return new ByteArrayInputStream(res.getContent());
        }
        catch (Exception e) {
            if (optional) {
                return null;
            }
            throw new FHIRException("Unable to fetch: " + e.getMessage(), (Throwable)e);
        }
    }

    private BasePackageCacheManager.InputStreamWithSrc loadFromCIBuild(String id, String branch) throws IOException {
        this.checkBuildLoaded();
        if (this.ciList.containsKey(id)) {
            if (branch == null) {
                InputStream stream;
                try {
                    stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{this.ciList.get(id), "package.tgz"}), false);
                }
                catch (Exception e) {
                    stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{this.ciList.get(id), "branches", "main", "package.tgz"}), false);
                }
                return new BasePackageCacheManager.InputStreamWithSrc(stream, Utilities.pathURL((String[])new String[]{this.ciList.get(id), "package.tgz"}), "current");
            }
            InputStream stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{this.ciList.get(id), "branches", branch, "package.tgz"}), false);
            return new BasePackageCacheManager.InputStreamWithSrc(stream, Utilities.pathURL((String[])new String[]{this.ciList.get(id), "branches", branch, "package.tgz"}), "current$" + branch);
        }
        if (id.startsWith("hl7.fhir.r6")) {
            InputStream stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{"https://build.fhir.org", id + ".tgz"}), false);
            return new BasePackageCacheManager.InputStreamWithSrc(stream, Utilities.pathURL((String[])new String[]{"https://build.fhir.org", id + ".tgz"}), "current");
        }
        throw new FHIRException("The package '" + id + "' has no entry on the current build server (" + String.valueOf(this.ciList) + ")");
    }

    private String getPackageUrlFromBuildList(String packageId) throws IOException {
        this.checkBuildLoaded();
        for (JsonObject o : this.buildInfo.asJsonObjects()) {
            if (!packageId.equals(o.asString("package-id"))) continue;
            return o.asString("url");
        }
        return null;
    }

    public String getPackageId(String canonicalUrl) throws IOException {
        String retVal = this.findCanonicalInLocalCache(canonicalUrl);
        if (retVal == null) {
            retVal = super.getPackageId(canonicalUrl);
        }
        if (retVal == null) {
            retVal = this.getPackageIdFromBuildList(canonicalUrl);
        }
        return retVal;
    }

    public String findCanonicalInLocalCache(String canonicalUrl) {
        try {
            for (String pf : this.listPackages()) {
                JsonObject npm;
                if (!ManagedFileAccess.file((String)Utilities.path((File)this.cacheFolder, (String[])new String[]{pf, "package", "package.json"})).exists() || !canonicalUrl.equals((npm = JsonParser.parseObjectFromFile((String)Utilities.path((File)this.cacheFolder, (String[])new String[]{pf, "package", "package.json"}))).asString("canonical"))) continue;
                return npm.asString("name");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private String getPackageIdFromBuildList(String canonical) {
        if (canonical == null) {
            return null;
        }
        this.checkBuildLoaded();
        if (this.buildInfo != null) {
            JsonObject o;
            for (JsonElement n : this.buildInfo) {
                o = (JsonObject)n;
                if (!canonical.equals(o.asString("url"))) continue;
                return o.asString("package-id");
            }
            for (JsonElement n : this.buildInfo) {
                o = (JsonObject)n;
                if (!o.asString("url").startsWith(canonical + "/ImplementationGuide/")) continue;
                return o.asString("package-id");
            }
        }
        return null;
    }

    private NpmPackage checkCurrency(String id, NpmPackage p) {
        this.checkBuildLoaded();
        try {
            String url = this.ciList.get(id);
            JsonObject json = JsonParser.parseObjectFromUrl((String)Utilities.pathURL((String[])new String[]{url, "package.manifest.json"}));
            String currDate = json.asString("date");
            String packDate = p.date();
            if (!currDate.equals(packDate)) {
                return null;
            }
        }
        catch (Exception e) {
            this.log("Unable to check package currency: " + id + ": " + id);
        }
        return p;
    }

    private void checkBuildLoaded() {
        if (!this.buildLoaded) {
            try {
                this.loadFromBuildServer();
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                    this.loadFromBuildServer();
                }
                catch (Exception e2) {
                    this.log("Error connecting to build server - running without build (" + e2.getMessage() + ")");
                }
            }
        }
    }

    private void loadFromBuildServer() throws IOException {
        HTTPResult res = ManagedWebAccess.get((String)("https://build.fhir.org/ig/qas.json?nocache=" + System.currentTimeMillis()));
        res.checkThrowException();
        this.buildInfo = (JsonArray)JsonParser.parse((String)TextFile.bytesToString((byte[])res.getContent()));
        ArrayList<BuildRecord> builds = new ArrayList<BuildRecord>();
        for (JsonElement n : this.buildInfo) {
            JsonObject o = (JsonObject)n;
            if (!o.has("url") || !o.has("package-id") || !o.asString("package-id").contains(".")) continue;
            String u = o.asString("url");
            if (u.contains("/ImplementationGuide/")) {
                u = u.substring(0, u.indexOf("/ImplementationGuide/"));
            }
            builds.add(new BuildRecord(this, u, o.asString("package-id"), this.getRepo(o.asString("repo")), this.readDate(o.asString("date"))));
        }
        Collections.sort(builds, new BuildRecordSorter(this));
        for (BuildRecord bld : builds) {
            if (this.ciList.containsKey(bld.getPackageId())) continue;
            this.ciList.put(bld.getPackageId(), "https://build.fhir.org/ig/" + bld.getRepo());
        }
        this.buildLoaded = true;
    }

    private String getRepo(String path) {
        String[] p = path.split("\\/");
        return p[0] + "/" + p[1];
    }

    private Date readDate(String s) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM, yyyy HH:mm:ss Z", new Locale("en", "US"));
        try {
            return sdf.parse(s);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    private BasePackageCacheManager.InputStreamWithSrc fetchTheOldWay(String id, String v) {
        PackageList pl;
        String url = this.getUrlForPackage(id);
        if (url == null) {
            try {
                url = this.getPackageUrlFromBuildList(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (url == null) {
            throw new FHIRException("Unable to resolve package id " + id + "#" + v);
        }
        if (url.contains("/ImplementationGuide/")) {
            url = url.substring(0, url.indexOf("/ImplementationGuide/"));
        }
        String pu = Utilities.pathURL((String[])new String[]{url, "package-list.json"});
        try {
            pl = PackageList.fromUrl((String)pu);
        }
        catch (Exception e) {
            String pv = Utilities.pathURL((String[])new String[]{url, v, "package.tgz"});
            try {
                return new BasePackageCacheManager.InputStreamWithSrc(this.fetchFromUrlSpecific(pv, false), pv, v);
            }
            catch (Exception e1) {
                throw new FHIRException("Error fetching package directly (" + pv + "), or fetching package list for " + id + " from " + pu + ": " + e1.getMessage(), (Throwable)e1);
            }
        }
        if (!id.equals(pl.pid())) {
            throw new FHIRException("Package ids do not match in " + pu + ": " + id + " vs " + pl.pid());
        }
        for (PackageList.PackageListEntry vo : pl.versions()) {
            if (!v.equals(vo.version())) continue;
            String u = Utilities.pathURL((String[])new String[]{vo.path(), "package.tgz"});
            return new BasePackageCacheManager.InputStreamWithSrc(this.fetchFromUrlSpecific(u, true), u, v);
        }
        return null;
    }

    private String fetchVersionTheOldWay(String id) throws IOException {
        String url = this.getUrlForPackage(id);
        if (url == null) {
            try {
                url = this.getPackageUrlFromBuildList(id);
            }
            catch (Exception e) {
                url = null;
            }
        }
        if (url == null) {
            throw new FHIRException("Unable to resolve package id " + id);
        }
        PackageList pl = PackageList.fromUrl((String)Utilities.pathURL((String[])new String[]{url, "package-list.json"}));
        if (!id.equals(pl.pid())) {
            throw new FHIRException("Package ids do not match in " + pl.source() + ": " + id + " vs " + pl.pid());
        }
        for (PackageList.PackageListEntry vo : pl.versions()) {
            if (!vo.current()) continue;
            return vo.version();
        }
        return null;
    }

    private String getUrlForPackage(String id) {
        if ("hl7.fhir.xver-extensions".equals(id)) {
            return "https://fhir.org/packages/hl7.fhir.xver-extensions";
        }
        return null;
    }

    public List<String> listPackages() {
        ArrayList<String> res = new ArrayList<String>();
        for (File f : this.cacheFolder.listFiles()) {
            if (!f.isDirectory() || !f.getName().contains("#")) continue;
            res.add(f.getName());
        }
        return res;
    }

    public boolean packageExists(String id, String ver) throws IOException {
        if (this.packageInstalled(id, ver)) {
            return true;
        }
        for (PackageServer s : this.getPackageServers()) {
            if (!new PackageClient(s).exists(id, ver)) continue;
            return true;
        }
        return false;
    }

    public boolean packageInstalled(String id, String version) {
        for (NpmPackage p : this.temporaryPackages) {
            if (p.name().equals(id) && ("current".equals(version) || "dev".equals(version) || p.version().equals(version))) {
                return true;
            }
            if (!p.name().equals(id) || !Utilities.noString((String)version)) continue;
            return true;
        }
        for (String f : Utilities.sorted((String[])this.cacheFolder.list())) {
            if (!f.equals(id + "#" + version) && (!Utilities.noString((String)version) || !f.startsWith(id + "#"))) continue;
            return true;
        }
        if ("dev".equals(version)) {
            return this.packageInstalled(id, "current");
        }
        return false;
    }

    public boolean isSuppressErrors() {
        return this.suppressErrors;
    }

    public void setSuppressErrors(boolean suppressErrors) {
        this.suppressErrors = suppressErrors;
    }

    public static IPackageProvider getPackageProvider() {
        return packageProvider;
    }

    public static void setPackageProvider(IPackageProvider packageProvider) {
        FilesystemPackageCacheManager.packageProvider = packageProvider;
    }

    public void setMinimalMemory(boolean minimalMemory) {
        this.minimalMemory = minimalMemory;
    }

    public boolean isMinimalMemory() {
        return this.minimalMemory;
    }

    static {
        ourLog = LoggerFactory.getLogger(FilesystemPackageCacheManager.class);
    }

    public static interface CacheLockFunction<T> {
        public T get() throws IOException;
    }

    public static interface IPackageProvider {
        public boolean handlesPackage(String var1, String var2);

        public BasePackageCacheManager.InputStreamWithSrc provide(String var1, String var2) throws IOException;
    }

    public class BuildRecord {
        private final String url;
        private final String packageId;
        private final String repo;
        private final Date date;

        public BuildRecord(FilesystemPackageCacheManager this$0, String url, String packageId, String repo, Date date) {
            this.url = url;
            this.packageId = packageId;
            this.repo = repo;
            this.date = date;
        }

        public String getUrl() {
            return this.url;
        }

        public String getPackageId() {
            return this.packageId;
        }

        public String getRepo() {
            return this.repo;
        }

        public Date getDate() {
            return this.date;
        }
    }

    public class BuildRecordSorter
    implements Comparator<BuildRecord> {
        public BuildRecordSorter(FilesystemPackageCacheManager this$0) {
        }

        @Override
        public int compare(BuildRecord arg0, BuildRecord arg1) {
            return arg1.date.compareTo(arg0.date);
        }
    }

    public static class Builder {
        private final File cacheFolder;
        private final List<PackageServer> packageServers;

        public Builder() throws IOException {
            this.cacheFolder = this.getUserCacheFolder();
            this.packageServers = this.getPackageServersFromFHIRSettings();
        }

        private File getUserCacheFolder() throws IOException {
            return ManagedFileAccess.file((String)Utilities.path((String[])new String[]{System.getProperty("user.home"), ".fhir", "packages"}));
        }

        private List<PackageServer> getPackageServersFromFHIRSettings() {
            ArrayList<PackageServer> packageServers = new ArrayList<PackageServer>(this.getConfiguredServers());
            if (!this.isIgnoreDefaultPackageServers()) {
                packageServers.addAll(this.getDefaultServers());
            }
            return packageServers;
        }

        protected boolean isIgnoreDefaultPackageServers() {
            return FhirSettings.isIgnoreDefaultPackageServers();
        }

        @Nonnull
        protected List<PackageServer> getDefaultServers() {
            return PackageServer.defaultServers();
        }

        protected List<PackageServer> getConfiguredServers() {
            return PackageServer.getConfiguredServers();
        }

        private Builder(File cacheFolder, List<PackageServer> packageServers) {
            this.cacheFolder = cacheFolder;
            this.packageServers = packageServers;
        }

        public Builder withCacheFolder(String cacheFolderPath) throws IOException {
            File cacheFolder = ManagedFileAccess.file((String)cacheFolderPath);
            if (!cacheFolder.exists()) {
                throw new FHIRException("The folder '" + String.valueOf(cacheFolder) + "' could not be found");
            }
            return new Builder(cacheFolder, this.packageServers);
        }

        public Builder withSystemCacheFolder() throws IOException {
            File systemCacheFolder = Utilities.isWindows() ? ManagedFileAccess.file((String)Utilities.path((String[])new String[]{System.getenv("ProgramData"), ".fhir", "packages"})) : ManagedFileAccess.file((String)Utilities.path((String[])new String[]{"/var", "lib", ".fhir", "packages"}));
            return new Builder(systemCacheFolder, this.packageServers);
        }

        public Builder withTestingCacheFolder() throws IOException {
            return new Builder(ManagedFileAccess.file((String)Utilities.path((String[])new String[]{"[tmp]", ".fhir", "packages"})), this.packageServers);
        }

        public FilesystemPackageCacheManager build() throws IOException {
            return new FilesystemPackageCacheManager(this.cacheFolder, this.packageServers);
        }

        public File getCacheFolder() {
            return this.cacheFolder;
        }

        public Builder withPackageServers(List<PackageServer> packageServers) {
            return this.packageServers == packageServers ? this : new Builder(this.cacheFolder, packageServers);
        }

        public List<PackageServer> getPackageServers() {
            return this.packageServers;
        }
    }
}

