/*
 * Decompiled with CFR 0.152.
 */
package help.swgoh.api;

import help.swgoh.api.SwgohAPIFilter;
import help.swgoh.api.response.RegistrationResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public interface SwgohAPI {
    public CompletableFuture<String> getPlayers(List<Integer> var1, Language var2, SwgohAPIFilter var3);

    default public CompletableFuture<String> getPlayers(List<Integer> allyCodes, SwgohAPIFilter filter) {
        return this.getPlayers(allyCodes, null, filter);
    }

    default public CompletableFuture<String> getPlayers(List<Integer> allyCodes) {
        return this.getPlayers(allyCodes, null, SwgohAPIFilter.ALL);
    }

    default public CompletableFuture<String> getPlayer(int allyCode, Language language, SwgohAPIFilter filter) {
        return this.getPlayers(Collections.singletonList(allyCode), language, filter);
    }

    default public CompletableFuture<String> getPlayer(int allyCode, Language language) {
        return this.getPlayer(allyCode, language, SwgohAPIFilter.ALL);
    }

    default public CompletableFuture<String> getPlayer(int allyCode, SwgohAPIFilter filter) {
        return this.getPlayer(allyCode, null, filter);
    }

    default public CompletableFuture<String> getPlayer(int allyCode) {
        return this.getPlayer(allyCode, null, SwgohAPIFilter.ALL);
    }

    public CompletableFuture<String> getGuild(int var1, Language var2, SwgohAPIFilter var3);

    default public CompletableFuture<String> getGuild(int allyCode, Language language) {
        return this.getGuild(allyCode, language, SwgohAPIFilter.ALL);
    }

    default public CompletableFuture<String> getGuild(int allyCode, SwgohAPIFilter filter) {
        return this.getGuild(allyCode, null, filter);
    }

    default public CompletableFuture<String> getGuild(int allyCode) {
        return this.getGuild(allyCode, SwgohAPIFilter.ALL);
    }

    public CompletableFuture<String> getLargeGuild(int var1, Language var2, SwgohAPIFilter var3);

    default public CompletableFuture<String> getLargeGuild(int allyCode, SwgohAPIFilter filter) {
        return this.getLargeGuild(allyCode, null, filter);
    }

    default public CompletableFuture<String> getLargeGuild(int allyCode, Language language) {
        return this.getLargeGuild(allyCode, language, SwgohAPIFilter.ALL);
    }

    default public CompletableFuture<String> getLargeGuild(int allyCode) {
        return this.getLargeGuild(allyCode, null, SwgohAPIFilter.ALL);
    }

    public CompletableFuture<String> getRosters(List<Integer> var1, Language var2, SwgohAPIFilter var3);

    default public CompletableFuture<String> getRosters(List<Integer> allyCodes, Language language) {
        return this.getRosters(allyCodes, language, SwgohAPIFilter.ALL);
    }

    default public CompletableFuture<String> getRosters(List<Integer> allyCodes, SwgohAPIFilter filter) {
        return this.getRosters(allyCodes, null, filter);
    }

    default public CompletableFuture<String> getRosters(List<Integer> allyCodes) {
        return this.getRosters(allyCodes, null, SwgohAPIFilter.ALL);
    }

    default public CompletableFuture<String> getRoster(int allyCode, Language language, SwgohAPIFilter filter) {
        return this.getRosters(Collections.singletonList(allyCode), language, filter);
    }

    default public CompletableFuture<String> getRoster(int allyCode, Language language) {
        return this.getRoster(allyCode, language, SwgohAPIFilter.ALL);
    }

    default public CompletableFuture<String> getRoster(int allyCode, SwgohAPIFilter filter) {
        return this.getRoster(allyCode, null, filter);
    }

    default public CompletableFuture<String> getRoster(int allyCode) {
        return this.getRoster(allyCode, null, SwgohAPIFilter.ALL);
    }

    public CompletableFuture<String> getZetaRecommendations(SwgohAPIFilter var1);

    default public CompletableFuture<String> getZetaRecommandations() {
        return this.getZetaRecommendations(SwgohAPIFilter.ALL);
    }

    public CompletableFuture<String> getSquadRecommendations(SwgohAPIFilter var1);

    default public CompletableFuture<String> getSquadRecommendations() {
        return this.getSquadRecommendations(SwgohAPIFilter.ALL);
    }

    public CompletableFuture<String> getEvents(Language var1, SwgohAPIFilter var2);

    default public CompletableFuture<String> getEvents(Language language) {
        return this.getEvents(language, SwgohAPIFilter.ALL);
    }

    default public CompletableFuture<String> getEvents(SwgohAPIFilter filter) {
        return this.getEvents(null, filter);
    }

    default public CompletableFuture<String> getEvents() {
        return this.getEvents(null, SwgohAPIFilter.ALL);
    }

    public CompletableFuture<String> getBattles(Language var1, SwgohAPIFilter var2);

    default public CompletableFuture<String> getBattles(Language language) {
        return this.getBattles(language, SwgohAPIFilter.ALL);
    }

    default public CompletableFuture<String> getBattles(SwgohAPIFilter filter) {
        return this.getBattles(null, filter);
    }

    default public CompletableFuture<String> getBattles() {
        return this.getBattles(null, SwgohAPIFilter.ALL);
    }

    public CompletableFuture<String> getSupportData(Collection var1, Map<String, Object> var2, Language var3, SwgohAPIFilter var4);

    default public CompletableFuture<String> getSupportData(Collection collection, Language language, SwgohAPIFilter filter) {
        return this.getSupportData(collection, null, language, filter);
    }

    default public CompletableFuture<String> getSupportData(Collection collection, Map<String, Object> matchCriteria, Language language) {
        return this.getSupportData(collection, matchCriteria, language, SwgohAPIFilter.ALL);
    }

    default public CompletableFuture<String> getSupportData(Collection collection, Map<String, Object> matchCriteria, SwgohAPIFilter filter) {
        return this.getSupportData(collection, matchCriteria, null, filter);
    }

    default public CompletableFuture<String> getSupportData(Collection collection, SwgohAPIFilter filter) {
        return this.getSupportData(collection, null, null, filter);
    }

    default public CompletableFuture<String> getSupportData(Collection collection, Map<String, Object> matchCriteria) {
        return this.getSupportData(collection, matchCriteria, null, SwgohAPIFilter.ALL);
    }

    public CompletableFuture<RegistrationResponse> register(Map<Integer, String> var1);

    default public CompletableFuture<RegistrationResponse> register(int allyCode, String discordId) {
        return this.register(Collections.singletonMap(allyCode, discordId));
    }

    public CompletableFuture<RegistrationResponse> unregister(List<Integer> var1, List<String> var2);

    default public CompletableFuture<RegistrationResponse> unregisterAllyCodes(List<Integer> allyCodes) {
        return this.unregister(allyCodes, null);
    }

    default public CompletableFuture<RegistrationResponse> unregisterAllyCode(int allyCode) {
        return this.unregister(Collections.singletonList(allyCode), null);
    }

    default public CompletableFuture<RegistrationResponse> unregisterDiscordIds(List<String> discordIds) {
        return this.unregister(null, discordIds);
    }

    default public CompletableFuture<RegistrationResponse> unregisterDiscordId(String discordId) {
        return this.unregister(null, Collections.singletonList(discordId));
    }

    public CompletableFuture<RegistrationResponse> getRegistrationByAllyCodes(List<Integer> var1);

    default public CompletableFuture<RegistrationResponse> getRegistrationByAllyCode(int allyCode) {
        return this.getRegistrationByAllyCodes(Collections.singletonList(allyCode));
    }

    public CompletableFuture<RegistrationResponse> getRegistrationByDiscordIds(List<String> var1);

    default public CompletableFuture<RegistrationResponse> getRegistrationByDiscordId(String discordId) {
        return this.getRegistrationByDiscordIds(Collections.singletonList(discordId));
    }

    public static enum Collection {
        abilityList,
        battleEnvironmentsList,
        battleTargetingRuleList,
        categoryList,
        challengeList,
        challengeStyleList,
        effectList,
        environmentCollectionList,
        equipmentList,
        eventSamplingList,
        guildExchangeItemList,
        guildRaidList,
        helpEntryList,
        materialList,
        playerTitleList,
        powerUpBundleList,
        raidConfigList,
        recipeList,
        requirementList,
        skillList,
        starterGuildList,
        statModList,
        statModSetList,
        statProgressionList,
        tableList,
        targetingSetList,
        territoryBattleDefinitionList,
        territoryWarDefinitionList,
        unitsList,
        unlockAnnouncementDefinitionList,
        warDefinitionList,
        xpTableList;

    }

    public static enum Language {
        English("eng_us", Locale.US, "English", "\ud83c\uddfa\ud83c\uddf8"),
        ChineseSimplified("chs_cn", Locale.SIMPLIFIED_CHINESE, "\u7b80\u4f53\u4e2d\u6587", "\ud83c\udde8\ud83c\uddf3"),
        ChineseTraditional("cht_cn", Locale.TRADITIONAL_CHINESE, "\u7e41\u9ad4\u4e2d\u6587", "\ud83c\uddf9\ud83c\uddfc"),
        French("fre_fr", Locale.FRANCE, "Fran\u00e7ais", "\ud83c\uddeb\ud83c\uddf7"),
        German("ger_de", Locale.GERMANY, "Deutsch", "\ud83c\udde9\ud83c\uddea"),
        Indonesian("ind_id", new Locale("ind"), "Bahasa Indonesia", "\ud83c\uddee\ud83c\udde9"),
        Italian("ita_it", Locale.ITALY, "Italiano", "\ud83c\uddee\ud83c\uddf9"),
        Japanese("jpn_jp", Locale.JAPAN, "\u65e5\u672c\u8a9e", "\ud83c\uddef\ud83c\uddf5"),
        Korean("kor_kr", Locale.KOREA, "\ud55c\uad6d\uc5b4", "\ud83c\uddf0\ud83c\uddf7"),
        Portuguese("por_br", new Locale("por"), "Portugu\u00eas", "\ud83c\udde7\ud83c\uddf7"),
        Russian("rus_ru", new Locale("rus"), "\u0440\u0443\u0441\u0441\u043a\u0438\u0439", "\ud83c\uddf7\ud83c\uddfa"),
        Spanish("spa_xm", new Locale("spa"), "Espa\u00f1ol", "\ud83c\uddea\ud83c\uddf8"),
        Thai("tha_th", new Locale("tha"), "\u0e44\u0e17\u0e22", "\ud83c\uddf9\ud83c\udded"),
        Turkish("tur_tr", new Locale("tur"), "T\u00fcrk\u00e7e", "\ud83c\uddf9\ud83c\uddf7");

        private final String swgohCode;
        private final Locale locale;
        private final String displayName;
        private final String unicode;

        private Language(String swgohCode, Locale locale, String displayName, String unicode) {
            this.swgohCode = swgohCode;
            this.locale = locale;
            this.displayName = displayName;
            this.unicode = unicode;
        }

        public String getSwgohCode() {
            return this.swgohCode;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getUnicode() {
            return this.unicode;
        }

        public static Optional<Language> fromSwgohCode(String swgohCode) {
            return Arrays.stream(Language.values()).filter(language -> language.getSwgohCode().equalsIgnoreCase(swgohCode)).findFirst();
        }

        public static Optional<Language> fromLocale(Locale locale) {
            return Arrays.stream(Language.values()).filter(language -> language.getLocale().equals(locale)).findFirst();
        }

        public static Optional<Language> fromDisplayName(String displayName) {
            return Arrays.stream(Language.values()).filter(language -> language.getDisplayName().equalsIgnoreCase(displayName)).findFirst();
        }

        public static Optional<Language> fromUnicode(String unicode) {
            return Arrays.stream(Language.values()).filter(language -> language.getUnicode().equals(unicode)).findFirst();
        }
    }
}

