/*
 * Decompiled with CFR 0.152.
 */
package help.swgoh.api;

import com.google.gson.Gson;
import help.swgoh.api.SwgohAPI;
import help.swgoh.api.SwgohAPIFilter;
import help.swgoh.api.SwgohAPISettings;
import help.swgoh.api.SwgohAPIToken;
import help.swgoh.api.exception.SwgohAPIDuplicateRequestException;
import help.swgoh.api.exception.SwgohAPIException;
import help.swgoh.api.exception.SwgohAPINotFoundException;
import help.swgoh.api.exception.SwgohAPIRateLimitException;
import help.swgoh.api.exception.SwgohAPITimeoutException;
import help.swgoh.api.response.RegistrationResponse;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;

public class SwgohAPIClient
implements SwgohAPI {
    private static final Gson GSON = new Gson();
    private static final SwgohAPIToken TOKEN = new SwgohAPIToken();
    private static final ScheduledExecutorService TOKEN_REFRESHER_SERVICE = new ScheduledThreadPoolExecutor(1);
    private final String urlBase;
    private final String username;
    private final String password;
    private final String defaultLanguage;
    private final Boolean defaultEnums;

    SwgohAPIClient(SwgohAPISettings settings) {
        this.urlBase = settings.getUrlBase();
        this.username = settings.getUsername();
        this.password = settings.getPassword();
        this.defaultLanguage = settings.getDefaultLanguage() == null ? null : settings.getDefaultLanguage().getSwgohCode();
        this.defaultEnums = settings.getDefaultEnums();
    }

    public CompletableFuture<String> call(API api, String username, String password, Map<String, Object> payload) {
        return CompletableFuture.supplyAsync(() -> this.getJson(api, username, password, payload));
    }

    public <T> CompletableFuture<T> call(API api, String username, String password, Map<String, Object> payload, Class<T> resultType) {
        return CompletableFuture.supplyAsync(() -> GSON.fromJson(this.getJson(api, username, password, payload), resultType));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getJson(API api, String username, String password, Map<String, Object> payload) {
        try (BufferedReader br = new BufferedReader(SwgohAPIClient.getInputReader(this.getAuthorizedConnection(api, username, password, payload)));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (FileNotFoundException exception) {
            throw new SwgohAPINotFoundException(exception);
        }
        catch (IOException ioException) {
            if (ioException.getMessage() == null) throw new SwgohAPIException("Unable to complete request.", ioException);
            if (ioException.getMessage().contains("429")) throw new SwgohAPIRateLimitException(ioException);
            if (ioException.getMessage().contains("502")) {
                throw new SwgohAPIRateLimitException(ioException);
            }
            if (ioException.getMessage().contains("409")) {
                throw new SwgohAPIDuplicateRequestException(ioException);
            }
            if (!ioException.getMessage().contains("504")) throw new SwgohAPIException("Unable to complete request.", ioException);
            throw new SwgohAPITimeoutException(ioException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection getAuthorizedConnection(API api, String username, String password, Map<String, Object> payload) throws IOException {
        if (SwgohAPIClient.TOKEN.access_token == null) {
            SwgohAPIToken swgohAPIToken = TOKEN;
            synchronized (swgohAPIToken) {
                if (SwgohAPIClient.TOKEN.access_token == null) {
                    SwgohAPIClient.login(this.urlBase, username, password);
                }
            }
        }
        byte[] postData = GSON.toJson(payload).getBytes(StandardCharsets.UTF_8);
        HttpURLConnection connection = SwgohAPIClient.createConnection(this.urlBase, api, postData);
        connection.setRequestProperty("Authorization", "Bearer " + SwgohAPIClient.TOKEN.access_token);
        connection.setRequestProperty("Content-Type", "application/json");
        try (DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());){
            outputStream.write(postData);
        }
        return connection;
    }

    private static HttpURLConnection createConnection(String urlBase, API api, byte[] postData) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)SwgohAPIClient.getUrl(urlBase, api).openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty("charset", "utf-8");
        connection.setRequestProperty("Content-Length", postData.length + "");
        connection.setRequestProperty("Accept-Encoding", "gzip");
        return connection;
    }

    public static void login(String urlBase, String username, String password) {
        try {
            long requestStartMillis = System.currentTimeMillis();
            SwgohAPIToken token = SwgohAPIClient.fetchToken(urlBase, username, password);
            SwgohAPIClient.TOKEN.access_token = token.access_token;
            long requestMillis = System.currentTimeMillis() - requestStartMillis;
            TOKEN_REFRESHER_SERVICE.schedule(() -> {
                SwgohAPIClient.TOKEN.access_token = null;
                return null;
            }, Math.max(0L, (long)(token.expires_in * 1000) - requestMillis - 50L), TimeUnit.MILLISECONDS);
        }
        catch (Throwable exception) {
            throw new SwgohAPIException("Unable to authorize with API.", exception);
        }
    }

    private static SwgohAPIToken fetchToken(String urlBase, String username, String password) throws IOException {
        String loginCredentials = "username=" + username + "&password=" + password + "&grant_type=password&client_id=abc&client_secret=123";
        byte[] postData = loginCredentials.getBytes(StandardCharsets.UTF_8);
        HttpURLConnection connection = SwgohAPIClient.createConnection(urlBase, API.signin, postData);
        try (DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());){
            outputStream.write(postData);
        }
        return (SwgohAPIToken)GSON.fromJson(SwgohAPIClient.getInputReader(connection), SwgohAPIToken.class);
    }

    private static Reader getInputReader(HttpURLConnection connection) throws IOException {
        InputStreamReader reader = "gzip".equals(connection.getContentEncoding()) ? new InputStreamReader(new GZIPInputStream(connection.getInputStream())) : new InputStreamReader(connection.getInputStream());
        return reader;
    }

    private static URL getUrl(String urlBase, API api) throws MalformedURLException {
        return new URL(urlBase + api.getPath());
    }

    @Override
    public CompletableFuture<String> getPlayers(List<Integer> allyCodes, SwgohAPI.Language language, SwgohAPIFilter filter) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("allycodes", allyCodes);
        payload.put("enums", this.defaultEnums);
        payload.put("language", language == null ? this.defaultLanguage : language.getSwgohCode());
        this.createProjection(payload, filter);
        return this.call(API.players, this.username, this.password, payload);
    }

    @Override
    public CompletableFuture<String> getGuild(int allyCode, SwgohAPI.Language language, SwgohAPIFilter filter) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("allycode", allyCode);
        payload.put("enums", this.defaultEnums);
        payload.put("language", language == null ? this.defaultLanguage : language.getSwgohCode());
        this.createProjection(payload, filter);
        return this.call(API.guilds, this.username, this.password, payload);
    }

    @Override
    public CompletableFuture<String> getLargeGuild(int allyCode, SwgohAPI.Language language, SwgohAPIFilter filter) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("allycode", allyCode);
        payload.put("roster", true);
        payload.put("enums", this.defaultEnums);
        payload.put("language", language == null ? this.defaultLanguage : language.getSwgohCode());
        this.createProjection(payload, filter);
        return this.call(API.guilds, this.username, this.password, payload);
    }

    @Override
    public CompletableFuture<String> getRosters(List<Integer> allyCodes, SwgohAPI.Language language, SwgohAPIFilter filter) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("allycode", allyCodes);
        payload.put("enums", this.defaultEnums);
        payload.put("language", language == null ? this.defaultLanguage : language.getSwgohCode());
        this.createProjection(payload, filter);
        return this.call(API.roster, this.username, this.password, payload);
    }

    @Override
    public CompletableFuture<String> getZetaRecommendations(SwgohAPIFilter filter) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        this.createProjection(payload, filter);
        return this.call(API.zetas, this.username, this.password, payload);
    }

    @Override
    public CompletableFuture<String> getSquadRecommendations(SwgohAPIFilter filter) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        this.createProjection(payload, filter);
        return this.call(API.squads, this.username, this.password, payload);
    }

    @Override
    public CompletableFuture<String> getEvents(SwgohAPI.Language language, SwgohAPIFilter filter) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("enums", this.defaultEnums);
        payload.put("language", language == null ? this.defaultLanguage : language.getSwgohCode());
        this.createProjection(payload, filter);
        return this.call(API.events, this.username, this.password, payload);
    }

    @Override
    public CompletableFuture<String> getBattles(SwgohAPI.Language language, SwgohAPIFilter filter) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("enums", this.defaultEnums);
        payload.put("language", language == null ? this.defaultLanguage : language.getSwgohCode());
        this.createProjection(payload, filter);
        return this.call(API.battles, this.username, this.password, payload);
    }

    @Override
    public CompletableFuture<String> getSupportData(SwgohAPI.Collection collection, Map<String, Object> matchCriteria, SwgohAPI.Language language, SwgohAPIFilter filter) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("collection", collection.name());
        payload.put("enums", this.defaultEnums);
        payload.put("language", language == null ? this.defaultLanguage : language.getSwgohCode());
        if (matchCriteria != null) {
            payload.put("match", matchCriteria);
        }
        this.createProjection(payload, filter);
        return this.call(API.data, this.username, this.password, payload);
    }

    @Override
    public CompletableFuture<RegistrationResponse> register(Map<Integer, String> allyCodeDiscordIdMappings) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        ArrayList mappings = new ArrayList();
        for (Integer allyCode : allyCodeDiscordIdMappings.keySet()) {
            ArrayList<Object> mapping = new ArrayList<Object>();
            mapping.add(allyCode);
            mapping.add(allyCodeDiscordIdMappings.get(allyCode));
            mappings.add(mapping);
        }
        payload.put("put", mappings);
        return this.call(API.registration, this.username, this.password, payload, RegistrationResponse.class);
    }

    @Override
    public CompletableFuture<RegistrationResponse> unregister(List<Integer> allyCodes, List<String> discordIds) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        ArrayList<Object> allyCodesOrDiscordIds = new ArrayList<Object>();
        if (allyCodes != null) {
            allyCodesOrDiscordIds.addAll(allyCodes);
        }
        if (discordIds != null) {
            allyCodesOrDiscordIds.addAll(discordIds);
        }
        payload.put("del", allyCodesOrDiscordIds);
        return this.call(API.registration, this.username, this.password, payload, RegistrationResponse.class);
    }

    @Override
    public CompletableFuture<RegistrationResponse> getRegistrationByAllyCodes(List<Integer> allyCodes) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("get", allyCodes);
        return this.call(API.registration, this.username, this.password, payload, RegistrationResponse.class);
    }

    @Override
    public CompletableFuture<RegistrationResponse> getRegistrationByDiscordIds(List<String> discordIds) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("get", discordIds);
        return this.call(API.registration, this.username, this.password, payload, RegistrationResponse.class);
    }

    private void createProjection(Map<String, Object> payload, SwgohAPIFilter filter) {
        if (filter != null && filter.getFilters().size() > 0) {
            payload.put("project", this.convertInnerFilters(filter));
        }
    }

    private Map<String, Object> convertInnerFilters(SwgohAPIFilter filter) {
        HashMap<String, Object> fieldsMap = new HashMap<String, Object>();
        for (Object element : filter.getFilters()) {
            if (element instanceof SwgohAPIFilter.InnerFilter) {
                fieldsMap.put(((SwgohAPIFilter.InnerFilter)element).element, this.convertInnerFilters(((SwgohAPIFilter.InnerFilter)element).filter));
                continue;
            }
            fieldsMap.put((String)element, 1);
        }
        return fieldsMap;
    }

    private void createProjection(Map<String, Object> payload, String ... fields) {
        if (fields != null && fields.length > 0) {
            HashMap<String, Integer> fieldsMap = new HashMap<String, Integer>();
            for (String field : fields) {
                fieldsMap.put(field, 1);
            }
            payload.put("project", fieldsMap);
        }
    }

    public static enum API {
        signin("/auth/signin"),
        players("/swgoh/players"),
        guilds("/swgoh/guilds"),
        roster("/swgoh/roster"),
        zetas("/swgoh/zetas"),
        squads("/swgoh/squads"),
        events("/swgoh/events"),
        battles("/swgoh/battles"),
        data("/swgoh/data"),
        registration("/registration");

        private final String path;

        private API(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

