/*
 * Decompiled with CFR 0.152.
 */
package help.swgoh.api;

import help.swgoh.api.SwgohAPI;
import help.swgoh.api.SwgohAPIClient;
import help.swgoh.api.exception.SwgohAPIException;

public class SwgohAPISettings {
    private String urlBase = "https://api.swgoh.help";
    private String username;
    private String password;
    private SwgohAPI.Language defaultLanguage;
    private Boolean defaultEnums;

    public String getUrlBase() {
        return this.urlBase;
    }

    public void setUrlBase(String urlBase) {
        this.urlBase = urlBase;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SwgohAPI.Language getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(SwgohAPI.Language defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public Boolean getDefaultEnums() {
        return this.defaultEnums;
    }

    public void setDefaultEnums(Boolean defaultEnums) {
        this.defaultEnums = defaultEnums;
    }

    public void validate() {
        boolean isPasswordUsed;
        if (this.urlBase == null || "".equals(this.urlBase)) {
            throw new SwgohAPIException("urlBase is required.");
        }
        boolean isUsernameUsed = this.username != null && !"".equals(this.username);
        boolean bl = isPasswordUsed = this.password != null && !"".equals(this.password);
        if (isUsernameUsed || isPasswordUsed) {
            if (!isUsernameUsed) {
                throw new SwgohAPIException("username is required.");
            }
            if (!isPasswordUsed) {
                throw new SwgohAPIException("password is required.");
            }
        }
        try {
            SwgohAPIClient.login(this.urlBase, this.username, this.password);
        }
        catch (Exception exception) {
            throw new SwgohAPIException("urlBase, username, or password are invalid or the host is inaccessible.", exception);
        }
    }
}

