/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EmbeddableSuperclass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.cfg.HbmBinder;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConfiguration
extends Configuration {
    private static Log log = LogFactory.getLog(AnnotationConfiguration.class);
    private Map namedGenerators;
    private Map<String, Map<String, Join>> joins;
    private Map<Class, AnnotatedClassType> classTypes;
    private Map<String, Properties> generatorTables;
    private Map<Table, List<String[]>> tableUniqueConstraints;
    private Map<String, String> mappedByResolver;
    private Map<String, String> propertyRefResolver;
    private List<Class> annotatedClasses;
    private List<CacheHolder> caches;

    public AnnotationConfiguration() {
    }

    public AnnotationConfiguration(SettingsFactory sf) {
        super(sf);
    }

    public AnnotationConfiguration addAnnotatedClasses(List<Class> classes) {
        List<Class> newList = this.orderHierarchy(classes);
        for (Class clazz : newList) {
            this.addAnnotatedClass(clazz);
        }
        return this;
    }

    protected List<Class> orderHierarchy(List<Class> original) {
        ArrayList<Class> copy = new ArrayList<Class>(original);
        ArrayList<Class> newList = new ArrayList<Class>();
        while (copy.size() > 0) {
            Class clazz = (Class)copy.get(0);
            AnnotationConfiguration.orderHierarchy(copy, newList, original, clazz);
        }
        return newList;
    }

    private static void orderHierarchy(List<Class> copy, List<Class> newList, List<Class> original, Class clazz) {
        if (Object.class.equals((Object)clazz)) {
            return;
        }
        AnnotationConfiguration.orderHierarchy(copy, newList, original, clazz.getSuperclass());
        if (original.contains(clazz)) {
            if (!newList.contains(clazz)) {
                newList.add(clazz);
            }
            copy.remove(clazz);
        }
    }

    public AnnotationConfiguration addAnnotatedClass(Class persistentClass) throws MappingException {
        try {
            this.annotatedClasses.add(persistentClass);
            return this;
        }
        catch (MappingException me) {
            log.error((Object)"Could not compile the mapping annotations", (Throwable)me);
            throw me;
        }
    }

    public AnnotationConfiguration addPackage(String packageName) throws MappingException {
        log.info((Object)("Mapping package " + packageName));
        try {
            AnnotationBinder.bindPackage(packageName, this.createExtendedMappings());
            return this;
        }
        catch (MappingException me) {
            log.error((Object)"Could not compile the mapping annotations", (Throwable)me);
            throw me;
        }
    }

    public ExtendedMappings createExtendedMappings() {
        return new ExtendedMappings(this.classes, this.collections, this.tables, this.namedQueries, this.namedSqlQueries, this.sqlResultSetMappings, this.imports, this.secondPasses, this.propertyReferences, this.namingStrategy, this.typeDefs, this.filterDefinitions, this.namedGenerators, this.joins, this.classTypes, this.extendsQueue, this.generatorTables, this.tableUniqueConstraints, this.mappedByResolver, this.propertyRefResolver);
    }

    public void setCacheConcurrencyStrategy(String clazz, String concurrencyStrategy, String region) throws MappingException {
        this.caches.add(new CacheHolder(clazz, concurrencyStrategy, region, true));
    }

    public void setCollectionCacheConcurrencyStrategy(String collectionRole, String concurrencyStrategy, String region) throws MappingException {
        this.caches.add(new CacheHolder(collectionRole, concurrencyStrategy, region, false));
    }

    protected void reset() {
        super.reset();
        this.namedGenerators = new HashMap();
        this.joins = new HashMap<String, Map<String, Join>>();
        this.classTypes = new HashMap<Class, AnnotatedClassType>();
        this.generatorTables = new HashMap<String, Properties>();
        this.tableUniqueConstraints = new HashMap<Table, List<String[]>>();
        this.mappedByResolver = new HashMap<String, String>();
        this.propertyRefResolver = new HashMap<String, String>();
        this.annotatedClasses = new ArrayList<Class>();
        this.caches = new ArrayList<CacheHolder>();
    }

    protected void secondPassCompile() throws MappingException {
        log.debug((Object)"Executing first pass of annotated classes");
        List<Class> orderedClasses = this.orderHierarchy(this.annotatedClasses);
        orderedClasses = this.addImplicitEmbeddedSuperClasses(orderedClasses);
        Map<Class, InheritanceState> inheritanceStatePerClass = AnnotationBinder.buildInheritanceStates(orderedClasses);
        for (Class clazz : orderedClasses) {
            InheritanceState state = inheritanceStatePerClass.get(clazz);
            if (!state.hasParents && !state.hasEmbeddedSuperclass && state.isEmbeddableSuperclass) continue;
        }
        for (Class clazz : orderedClasses) {
            AnnotationBinder.bindClass(clazz, inheritanceStatePerClass, this.createExtendedMappings());
        }
        this.annotatedClasses.clear();
        int cacheNbr = this.caches.size();
        for (int index = 0; index < cacheNbr; ++index) {
            CacheHolder cacheHolder = this.caches.get(index);
            if (cacheHolder.isClass) {
                super.setCacheConcurrencyStrategy(cacheHolder.role, cacheHolder.usage, cacheHolder.region);
                continue;
            }
            super.setCollectionCacheConcurrencyStrategy(cacheHolder.role, cacheHolder.usage, cacheHolder.region);
        }
        this.caches.clear();
        log.debug((Object)"processing manytoone fk mappings");
        Iterator iter = this.secondPasses.iterator();
        while (iter.hasNext()) {
            HbmBinder.SecondPass sp = (HbmBinder.SecondPass)iter.next();
            if (!(sp instanceof FkSecondPass)) continue;
            sp.doSecondPass(this.classes, Collections.EMPTY_MAP);
            iter.remove();
        }
        super.secondPassCompile();
        for (Map.Entry<Table, List<String[]>> entry : this.tableUniqueConstraints.entrySet()) {
            Table table = entry.getKey();
            List<String[]> uniqueConstraints = entry.getValue();
            int uniqueIndexPerTable = 0;
            for (String[] columnNames : uniqueConstraints) {
                String keyName = "key" + uniqueIndexPerTable++;
                this.buildUniqueKeyFromColumnNames(columnNames, table, keyName);
            }
        }
    }

    private List<Class> addImplicitEmbeddedSuperClasses(List<Class> orderedClasses) {
        ArrayList<Class> newOrderedClasses = new ArrayList<Class>(orderedClasses);
        for (Class clazz : orderedClasses) {
            Class superClazz = clazz.getSuperclass();
            if (newOrderedClasses.contains(superClazz)) continue;
            this.addEmbeddedSuperclasses(clazz, newOrderedClasses);
        }
        return newOrderedClasses;
    }

    private void addEmbeddedSuperclasses(Class clazz, List<Class> newOrderedClasses) {
        Class superClass = clazz.getSuperclass();
        boolean hasToStop = false;
        while (!hasToStop) {
            if (superClass.isAnnotationPresent(EmbeddableSuperclass.class)) {
                newOrderedClasses.add(0, superClass);
                superClass = superClass.getSuperclass();
                continue;
            }
            hasToStop = true;
        }
    }

    private void buildUniqueKeyFromColumnNames(String[] columnNames, Table table, String keyName) {
        int size = columnNames.length;
        Column[] columns = new Column[size];
        HashSet<Column> unbound = new HashSet<Column>();
        for (int index = 0; index < size; ++index) {
            columns[index] = new Column(columnNames[index]);
            unbound.add(columns[index]);
        }
        for (Column column : columns) {
            if (!table.containsColumn(column)) continue;
            UniqueKey uc = table.getOrCreateUniqueKey(keyName);
            uc.addColumn(table.getColumn(column));
            unbound.remove(column);
        }
        if (unbound.size() > 0) {
            StringBuffer sb = new StringBuffer("Unable to create unique key constraint (");
            for (String columnName : columnNames) {
                sb.append(columnName).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(") on table ").append(table.getName()).append(": ");
            for (Column column : unbound) {
                sb.append(column.getName()).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(" not found");
            throw new AnnotationException(sb.toString());
        }
    }

    protected void parseMappingElement(Element subelement, String name) {
        Attribute rsrc = subelement.attribute("resource");
        Attribute file = subelement.attribute("file");
        Attribute jar = subelement.attribute("jar");
        Attribute pckg = subelement.attribute("package");
        Attribute clazz = subelement.attribute("class");
        if (rsrc != null) {
            log.debug((Object)(name + "<-" + rsrc));
            this.addResource(rsrc.getValue());
        } else if (jar != null) {
            log.debug((Object)(name + "<-" + jar));
            this.addJar(new File(jar.getValue()));
        } else if (file != null) {
            log.debug((Object)(name + "<-" + file));
            this.addFile(file.getValue());
        } else if (pckg != null) {
            log.debug((Object)(name + "<-" + pckg));
            this.addPackage(pckg.getValue());
        } else if (clazz != null) {
            log.debug((Object)(name + "<-" + clazz));
            Class loadedClass = null;
            try {
                loadedClass = ReflectHelper.classForName((String)clazz.getValue());
            }
            catch (ClassNotFoundException cnf) {
                throw new MappingException("Unable to load class declared as <mapping class=\"" + clazz.getValue() + "\"/> in the configuration:", (Throwable)cnf);
            }
            this.addAnnotatedClass(loadedClass);
        } else {
            throw new MappingException("<mapping> element in configuration specifies no attributes");
        }
    }

    private class CacheHolder {
        public String role;
        public String usage;
        public String region;
        public boolean isClass;

        public CacheHolder(String role, String usage, String region, boolean isClass) {
            this.role = role;
            this.usage = usage;
            this.region = region;
            this.isClass = isClass;
        }
    }
}

