/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.Index;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyInferredData;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3Column {
    private static final Log log = LogFactory.getLog(Ejb3Column.class);
    private Column mappingColumn;
    private boolean insertable = true;
    private boolean updatable = true;
    private String secondaryTableName;
    protected Map<String, Join> joins;
    protected PropertyHolder propertyHolder;
    private Mappings mappings;
    private boolean isImplicit;
    public static final int DEFAULT_COLUMN_LENGTH = 255;
    public String sqlType;
    private int length = 255;
    private int precision;
    private int scale;
    private String columnName;
    private boolean unique;
    private boolean nullable = true;
    private String formulaString;
    private org.hibernate.mapping.Formula formula;

    public String getSqlType() {
        return this.sqlType;
    }

    public int getLength() {
        return this.length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String getFormulaString() {
        return this.formulaString;
    }

    public String getSecondaryTableName() {
        return this.secondaryTableName;
    }

    public void setFormula(String formula) {
        this.formulaString = formula;
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public void setMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    public void setImplicit(boolean implicit) {
        this.isImplicit = implicit;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isNullable() {
        return this.mappingColumn.isNullable();
    }

    public void bind() {
        if (StringHelper.isNotEmpty((String)this.formulaString)) {
            log.debug((Object)("binding formula " + this.formulaString));
            this.formula = new org.hibernate.mapping.Formula();
            this.formula.setFormula(this.formulaString);
        } else {
            log.debug((Object)("Binding column " + this.columnName + " unique " + this.unique));
            this.initMappingColumn(this.columnName, this.length, this.precision, this.scale, this.nullable, this.sqlType, this.unique);
        }
    }

    protected void initMappingColumn(String name, int length, int precision, int scale, boolean nullable, String sqlType, boolean unique) {
        this.mappingColumn = new Column();
        this.redefineColumnName(name);
        this.mappingColumn.setLength(length);
        if (precision > 0) {
            this.mappingColumn.setPrecision(precision);
            this.mappingColumn.setScale(scale);
        }
        this.mappingColumn.setNullable(nullable);
        this.mappingColumn.setSqlType(sqlType);
        this.mappingColumn.setUnique(unique);
    }

    public boolean isNameDeferred() {
        return this.mappingColumn == null || StringHelper.isEmpty((String)this.mappingColumn.getName());
    }

    public void redefineColumnName(String name) {
        if (name != null) {
            this.mappingColumn.setName(this.mappings.getNamingStrategy().columnName(name));
        }
    }

    public String getName() {
        return this.mappingColumn.getName();
    }

    public Column getMappingColumn() {
        return this.mappingColumn;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setNullable(boolean nullable) {
        if (this.mappingColumn != null) {
            this.mappingColumn.setNullable(nullable);
        } else {
            this.nullable = nullable;
        }
    }

    public void setJoins(Map<String, Join> joins) {
        this.joins = joins;
    }

    public PropertyHolder getPropertyHolder() {
        return this.propertyHolder;
    }

    public void setPropertyHolder(PropertyHolder propertyHolder) {
        this.propertyHolder = propertyHolder;
    }

    protected void setMappingColumn(Column mappingColumn) {
        this.mappingColumn = mappingColumn;
    }

    public void linkWithValue(SimpleValue value) {
        if (this.formula != null) {
            value.addFormula(this.formula);
        } else {
            this.getMappingColumn().setValue((Value)value);
            value.addColumn(this.getMappingColumn());
            value.getTable().addColumn(this.getMappingColumn());
        }
    }

    public Table getTable() {
        if (this.isSecondary()) {
            return this.getJoin().getTable();
        }
        return this.propertyHolder.getTable();
    }

    public boolean isSecondary() {
        if (this.propertyHolder == null) {
            throw new AssertionFailure("Should not call getTable() on column wo persistent class defined");
        }
        return StringHelper.isNotEmpty((String)this.secondaryTableName);
    }

    private Join getJoin() {
        Join join = this.joins.get(this.secondaryTableName);
        if (join == null) {
            throw new AnnotationException("Cannot find the expected secondary table: no " + this.secondaryTableName + " in " + this.propertyHolder.getClassName());
        }
        return join;
    }

    public void addPropertyToMappingContainer(Property prop) {
        if (this.isSecondary()) {
            this.getJoin().addProperty(prop);
        } else {
            this.propertyHolder.addProperty(prop);
        }
    }

    public void forceNotNull() {
        this.mappingColumn.setNullable(false);
    }

    public void setSecondaryTableName(String secondaryTableName) {
        this.secondaryTableName = secondaryTableName;
    }

    public static Ejb3Column[] buildColumnFromAnnotation(javax.persistence.Column[] anns, Formula formulaAnn, Nullability nullability, PropertyHolder propertyHolder, PropertyInferredData inferredData, Map<String, Join> secondaryTables, ExtendedMappings mappings) {
        Ejb3Column[] columns;
        if (formulaAnn != null) {
            Ejb3Column formulaColumn = new Ejb3Column();
            formulaColumn.setFormula(formulaAnn.value());
            formulaColumn.setImplicit(false);
            formulaColumn.setMappings(mappings);
            formulaColumn.setPropertyHolder(propertyHolder);
            formulaColumn.bind();
            columns = new Ejb3Column[]{formulaColumn};
        } else {
            javax.persistence.Column[] actualCols = anns;
            javax.persistence.Column[] overriddenCols = propertyHolder.getOverriddenColumn(inferredData.getPropertyName());
            if (overriddenCols != null) {
                if (anns != null && overriddenCols.length != anns.length) {
                    throw new AnnotationException("AttributeOverride.column() should override all columns for now");
                }
                actualCols = overriddenCols.length == 0 ? null : overriddenCols;
                log.debug((Object)("Column(s) overridden for property " + inferredData.getPropertyName()));
            }
            if (actualCols == null) {
                columns = Ejb3Column.buildImplicitColumn(inferredData, secondaryTables, propertyHolder, nullability, mappings);
            } else {
                int length = actualCols.length;
                columns = new Ejb3Column[length];
                for (int index = 0; index < length; ++index) {
                    javax.persistence.Column col = actualCols[index];
                    String sqlType = col.columnDefinition().equals("") ? null : col.columnDefinition();
                    String name = col.name().equals("") ? inferredData.getPropertyName() : col.name();
                    Ejb3Column column = new Ejb3Column();
                    column.setImplicit(false);
                    column.setSqlType(sqlType);
                    column.setLength(col.length());
                    column.setPrecision(col.precision());
                    column.setScale(col.scale());
                    column.setColumnName(name);
                    column.setNullable(col.nullable());
                    column.setUnique(col.unique());
                    column.setInsertable(col.insertable());
                    column.setUpdatable(col.updatable());
                    column.setSecondaryTableName(col.secondaryTable());
                    column.setPropertyHolder(propertyHolder);
                    column.setJoins(secondaryTables);
                    column.setMappings(mappings);
                    column.bind();
                    columns[index] = column;
                }
            }
        }
        return columns;
    }

    private static Ejb3Column[] buildImplicitColumn(PropertyInferredData inferredData, Map<String, Join> secondaryTables, PropertyHolder propertyHolder, Nullability nullability, ExtendedMappings mappings) {
        Ejb3Column[] columns = new Ejb3Column[1];
        Ejb3Column column = new Ejb3Column();
        column.setImplicit(false);
        if (nullability != Nullability.FORCED_NULL && inferredData.getReturnedClassOrElement().isPrimitive() && !inferredData.isArray()) {
            column.setNullable(false);
        }
        column.setLength(255);
        column.setColumnName(inferredData.getPropertyName());
        column.setPropertyHolder(propertyHolder);
        column.setJoins(secondaryTables);
        column.setMappings(mappings);
        column.bind();
        columns[0] = column;
        return columns;
    }

    public static void checkPropertyConsistency(Ejb3Column[] columns, String propertyName) {
        int nbrOfColumns = columns.length;
        if (nbrOfColumns > 1) {
            for (int currentIndex = 1; currentIndex < nbrOfColumns; ++currentIndex) {
                if (columns[currentIndex].isInsertable() != columns[currentIndex - 1].isInsertable()) {
                    throw new AnnotationException("Mixing insertable and non insertable columns in a property is not allowed: " + propertyName);
                }
                if (columns[currentIndex].isNullable() != columns[currentIndex - 1].isNullable()) {
                    throw new AnnotationException("Mixing nullable and non nullable columns in a property is not allowed: " + propertyName);
                }
                if (columns[currentIndex].isUpdatable() != columns[currentIndex - 1].isUpdatable()) {
                    throw new AnnotationException("Mixing updatable and non updatable columns in a property is not allowed: " + propertyName);
                }
                if (columns[currentIndex].getTable().equals(columns[currentIndex - 1].getTable())) continue;
                throw new AnnotationException("Mixing different tables in a property is not allowed: " + propertyName);
            }
        }
    }

    public void addIndex(Index index) {
        if (index == null) {
            return;
        }
        if (this.mappingColumn == null) {
            throw new AnnotationException("Index on formula not allowed: " + this.propertyHolder.getEntityName());
        }
        if (StringHelper.isEmpty((String)this.secondaryTableName)) {
            this.propertyHolder.getPersistentClass().getRootTable().getOrCreateIndex(index.name()).addColumn(this.mappingColumn);
        } else {
            this.getJoin().getTable().getOrCreateIndex(index.name()).addColumn(this.mappingColumn);
        }
    }
}

