/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.annotations.CollectionBinder;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;

public class MapBinder
extends CollectionBinder {
    protected Collection createCollection(PersistentClass persistentClass) {
        return new org.hibernate.mapping.Map(persistentClass);
    }

    public SecondPass getSecondPass(final ExtendedMappings mappings, final Ejb3JoinColumn[] keyColumns, final Ejb3JoinColumn[] inverseColumns, final String collType, final FetchMode fetchMode, final boolean unique) {
        if (inverseColumns != null) {
            return new SecondPass(mappings, this.collection){

                public void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
                    CollectionBinder.bindManyToManySecondPass(MapBinder.this.collection, persistentClasses, keyColumns, inverseColumns, collType, fetchMode, unique, MapBinder.this.cascadeDeleteEnabled, mappings);
                    MapBinder.this.bindKeyFromAssociationTable(collType, persistentClasses, MapBinder.this.mapKeyPropertyName, mappings);
                }
            };
        }
        return new SecondPass(mappings, this.collection){

            public void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
                CollectionBinder.bindCollectionSecondPass(MapBinder.this.collection, persistentClasses, keyColumns, MapBinder.this.cascadeDeleteEnabled, MapBinder.this.hqlOrderBy, mappings);
                if (!MapBinder.this.collection.isOneToMany()) {
                    throw new AssertionFailure("Should be a one to many");
                }
                OneToMany oneToMany = (OneToMany)MapBinder.this.collection.getElement();
                String collType = oneToMany.getReferencedEntityName();
                MapBinder.this.bindKeyFromAssociationTable(collType, persistentClasses, MapBinder.this.mapKeyPropertyName, mappings);
            }
        };
    }

    private void bindKeyFromAssociationTable(String collType, Map persistentClasses, String mapKeyPropertyName, ExtendedMappings mappings) {
        if (mapKeyPropertyName == null) {
            throw new AnnotationException("A Map must declare a @MapKey element");
        }
        PersistentClass associatedClass = (PersistentClass)persistentClasses.get(collType);
        if (associatedClass == null) {
            throw new AnnotationException("Associated class not found: " + collType);
        }
        Property property = BinderHelper.findPropertyByName(associatedClass, mapKeyPropertyName);
        if (property == null) {
            throw new AnnotationException("Map key property not found: " + collType + "." + mapKeyPropertyName);
        }
        org.hibernate.mapping.Map map = (org.hibernate.mapping.Map)this.collection;
        map.setIndex(property.getValue());
    }
}

