/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2java;

import java.util.HashSet;
import java.util.Set;
import net.sf.hibernate.util.StringHelper;

public class ClassName {
    static final Set PRIMITIVES = new HashSet();
    private String fullyQualifiedName = null;
    private String name = null;
    private String packageName = null;

    public ClassName(String fqn) {
        this.initFullyQualifiedName(fqn);
    }

    public boolean equals(Object other) {
        ClassName otherClassName = (ClassName)other;
        return otherClassName.fullyQualifiedName.equals(this.fullyQualifiedName);
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean inJavaLang() {
        return "java.lang".equals(this.packageName);
    }

    public boolean inSamePackage(ClassName other) {
        return other.packageName == this.packageName || other.packageName != null && other.packageName.equals(this.packageName);
    }

    public boolean isArray() {
        return this.fullyQualifiedName.endsWith("[]");
    }

    public boolean isPrimitive() {
        String baseTypeName = StringHelper.replace((String)this.fullyQualifiedName, (String)"[]", (String)"");
        return PRIMITIVES.contains(baseTypeName);
    }

    private void initFullyQualifiedName(String fqn) {
        this.fullyQualifiedName = fqn;
        if (!this.isPrimitive()) {
            if (fqn != null) {
                int lastDot = fqn.lastIndexOf(".");
                if (lastDot < 0) {
                    this.name = fqn;
                    this.packageName = null;
                } else {
                    this.name = fqn.substring(lastDot + 1);
                    this.packageName = fqn.substring(0, lastDot);
                }
            } else {
                this.name = fqn;
                this.packageName = null;
            }
        } else {
            this.name = fqn;
            this.packageName = null;
        }
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }

    static {
        PRIMITIVES.add("byte");
        PRIMITIVES.add("short");
        PRIMITIVES.add("int");
        PRIMITIVES.add("long");
        PRIMITIVES.add("float");
        PRIMITIVES.add("double");
        PRIMITIVES.add("char");
        PRIMITIVES.add("boolean");
    }
}

