/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2java;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.tool.hbm2java.ClassMapping;
import net.sf.hibernate.tool.hbm2java.Generator;
import net.sf.hibernate.tool.hbm2java.MappingElement;
import net.sf.hibernate.tool.hbm2java.MetaAttributeHelper;
import net.sf.hibernate.util.DTDEntityResolver;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class CodeGenerator {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$tool$hbm2java$CodeGenerator == null ? (class$net$sf$hibernate$tool$hbm2java$CodeGenerator = CodeGenerator.class$("net.sf.hibernate.tool.hbm2java.CodeGenerator")) : class$net$sf$hibernate$tool$hbm2java$CodeGenerator));
    static /* synthetic */ Class class$net$sf$hibernate$tool$hbm2java$CodeGenerator;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("No arguments provided. Nothing to do. Exit.");
            System.exit(-1);
        }
        try {
            ArrayList<String> mappingFiles = new ArrayList<String>();
            SAXBuilder builder = new SAXBuilder(true);
            builder.setEntityResolver((EntityResolver)new DTDEntityResolver());
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException error) {
                    log.error((Object)("Error parsing XML: " + error.getSystemId() + '(' + error.getLineNumber() + ')'), (Throwable)error);
                }

                public void fatalError(SAXParseException error) {
                    this.error(error);
                }

                public void warning(SAXParseException error) {
                    log.warn((Object)("Warning parsing XML: " + error.getSystemId() + '(' + error.getLineNumber() + ')'));
                }
            });
            String outputDir = null;
            ArrayList<Generator> generators = new ArrayList<Generator>();
            MultiHashMap globalMetas = new MultiHashMap();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("--")) {
                    if (args[i].startsWith("--config=")) {
                        builder.setValidation(false);
                        Document document = builder.build(new File(args[i].substring(9)));
                        globalMetas = MetaAttributeHelper.loadAndMergeMetaMap(document.getRootElement(), null);
                        Iterator generateElements = document.getRootElement().getChildren("generate").iterator();
                        while (generateElements.hasNext()) {
                            generators.add(new Generator((Element)generateElements.next()));
                        }
                        builder.setValidation(true);
                        continue;
                    }
                    if (!args[i].startsWith("--output=")) continue;
                    outputDir = args[i].substring(9);
                    continue;
                }
                mappingFiles.add(args[i]);
            }
            if (generators.size() == 0) {
                generators.add(new Generator());
            }
            HashMap classMappings = new HashMap();
            builder.setValidation(true);
            Iterator iter = mappingFiles.iterator();
            while (iter.hasNext()) {
                File file = new File((String)iter.next());
                Document document = builder.build(file);
                Element rootElement = document.getRootElement();
                Attribute a = rootElement.getAttribute("package");
                String pkg = null;
                if (a != null) {
                    pkg = a.getValue();
                }
                MappingElement me = new MappingElement(rootElement, null);
                Iterator classElements = rootElement.getChildren("class").iterator();
                MultiMap mm = MetaAttributeHelper.loadAndMergeMetaMap(rootElement, (MultiMap)globalMetas);
                CodeGenerator.handleClass(pkg, me, classMappings, classElements, mm, false);
                classElements = rootElement.getChildren("subclass").iterator();
                CodeGenerator.handleClass(pkg, me, classMappings, classElements, mm, true);
                classElements = rootElement.getChildren("joined-subclass").iterator();
                CodeGenerator.handleClass(pkg, me, classMappings, classElements, mm, true);
            }
            Iterator iterator = generators.iterator();
            while (iterator.hasNext()) {
                Generator g = (Generator)iterator.next();
                g.setBaseDirName(outputDir);
                g.generate(classMappings);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void handleClass(String classPackage, MappingElement me, HashMap classMappings, Iterator classElements, MultiMap mm, boolean extendz) throws MappingException {
        while (classElements.hasNext()) {
            Element clazz = (Element)classElements.next();
            if (!extendz) {
                ClassMapping cmap = new ClassMapping(classPackage, clazz, me, mm);
                cmap.storeIn(classMappings);
                continue;
            }
            String ex = clazz.getAttributeValue("extends");
            if (ex == null) {
                throw new MappingException("Missing extends attribute on <" + clazz.getName() + " name=" + clazz.getAttributeValue("name") + ">");
            }
            ClassMapping superclass = (ClassMapping)classMappings.get(ex);
            if (superclass == null) {
                throw new MappingException("Cannot extend unmapped class " + ex);
            }
            ClassMapping subclassMapping = new ClassMapping(classPackage, me, superclass.getClassName(), superclass, clazz, mm);
            subclassMapping.storeIn(classMappings);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

