/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.management.mbeans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import mx4j.AbstractDynamicMBean;
import org.apache.hivemind.management.impl.PerformanceCollector;
import org.apache.hivemind.management.mbeans.Counter;
import org.apache.hivemind.service.MethodSignature;

public class PerformanceMonitorMBean
extends AbstractDynamicMBean
implements PerformanceCollector {
    protected static final String DATA_TYPE_MAXIMUM_TIME = "Maximum time";
    protected static final String DATA_TYPE_MINIMUM_TIME = "Minimum time";
    protected static final String DATA_TYPE_LAST_TIME = "Last time";
    protected static final String DATA_TYPE_AVERAGE_TIME = "Average time";
    protected static final String DATA_TYPE_COUNT = "Count";
    private static final String DATA_TYPE_SEPARATOR = " : ";
    private Set _methods;
    private Map _countersByMethodSignature = new HashMap();
    private Map _countersByMethodId = new HashMap();
    private MBeanAttributeInfo[] mBeanAttributeInfos;
    static /* synthetic */ Class class$java$lang$Long;

    public PerformanceMonitorMBean(Set methods) {
        this._methods = methods;
        this.initCounters();
        this.initAttributes();
    }

    protected void initCounters() {
        Iterator methodIterator = this._methods.iterator();
        while (methodIterator.hasNext()) {
            MethodSignature method = (MethodSignature)methodIterator.next();
            Counter counter = new Counter();
            this._countersByMethodSignature.put(method, counter);
            this._countersByMethodId.put(method.getUniqueId(), counter);
        }
    }

    protected void initAttributes() {
        ArrayList mBeanAttributeInfoList = new ArrayList();
        Iterator methodIterator = this._methods.iterator();
        while (methodIterator.hasNext()) {
            MethodSignature method = (MethodSignature)methodIterator.next();
            this.addAttribute(mBeanAttributeInfoList, method, class$java$lang$Long == null ? PerformanceMonitorMBean.class$("java.lang.Long") : class$java$lang$Long, DATA_TYPE_COUNT, "Number of method calls for method " + method);
            this.addAttribute(mBeanAttributeInfoList, method, class$java$lang$Long == null ? PerformanceMonitorMBean.class$("java.lang.Long") : class$java$lang$Long, DATA_TYPE_AVERAGE_TIME, "Average execution time in ms of method " + method);
            this.addAttribute(mBeanAttributeInfoList, method, class$java$lang$Long == null ? PerformanceMonitorMBean.class$("java.lang.Long") : class$java$lang$Long, DATA_TYPE_LAST_TIME, "Last execution time in ms of method " + method);
            this.addAttribute(mBeanAttributeInfoList, method, class$java$lang$Long == null ? PerformanceMonitorMBean.class$("java.lang.Long") : class$java$lang$Long, DATA_TYPE_MINIMUM_TIME, "Minimum execution time in ms of method " + method);
            this.addAttribute(mBeanAttributeInfoList, method, class$java$lang$Long == null ? PerformanceMonitorMBean.class$("java.lang.Long") : class$java$lang$Long, DATA_TYPE_MAXIMUM_TIME, "Maximum execution time in ms of method " + method);
        }
        this.mBeanAttributeInfos = mBeanAttributeInfoList.toArray(new MBeanAttributeInfo[mBeanAttributeInfoList.size()]);
    }

    private void addAttribute(List mBeanAttributeInfoList, MethodSignature method, Class attributeType, String performanceDataType, String description) {
        String attributeName = this.buildAttributeName(method, performanceDataType);
        MBeanAttributeInfo infoCount = new MBeanAttributeInfo(attributeName, attributeType.getName(), description, true, false, false);
        mBeanAttributeInfoList.add(infoCount);
    }

    protected String buildAttributeName(MethodSignature method, String performanceDataType) {
        String attributeName = method.getUniqueId() + DATA_TYPE_SEPARATOR + performanceDataType;
        return attributeName;
    }

    public void addMeasurement(MethodSignature method, long executionTime) {
        Counter counter = (Counter)this._countersByMethodSignature.get(method);
        counter.addMeasurement(executionTime);
    }

    protected MBeanAttributeInfo[] createMBeanAttributeInfo() {
        return this.mBeanAttributeInfos;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        int posSep = attribute.indexOf(DATA_TYPE_SEPARATOR);
        String methodId = attribute.substring(0, posSep);
        String type = attribute.substring(posSep + DATA_TYPE_SEPARATOR.length(), attribute.length());
        Counter counter = (Counter)this._countersByMethodId.get(methodId);
        if (type.equals(DATA_TYPE_COUNT)) {
            return new Long(counter.count);
        }
        if (type.equals(DATA_TYPE_AVERAGE_TIME)) {
            return new Long(counter.average);
        }
        if (type.equals(DATA_TYPE_LAST_TIME)) {
            return new Long(counter.last);
        }
        if (type.equals(DATA_TYPE_MINIMUM_TIME)) {
            return new Long(counter.min);
        }
        if (type.equals(DATA_TYPE_MAXIMUM_TIME)) {
            return new Long(counter.max);
        }
        throw new IllegalArgumentException("Unknown performance data type");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

