/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.management.mbeans;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;

public abstract class AbstractDynamicMBean
implements DynamicMBean {
    private MBeanInfo _mBeanInfo;

    public MBeanInfo getMBeanInfo() {
        if (this._mBeanInfo == null) {
            this.setMBeanInfo(this.createMBeanInfo());
        }
        return this._mBeanInfo;
    }

    protected void setMBeanInfo(MBeanInfo info) {
        this._mBeanInfo = info;
    }

    private MBeanInfo createMBeanInfo() {
        MBeanAttributeInfo[] attrs = this.createMBeanAttributeInfo();
        MBeanConstructorInfo[] ctors = this.createMBeanConstructorInfo();
        MBeanOperationInfo[] opers = this.createMBeanOperationInfo();
        MBeanNotificationInfo[] notifs = this.createMBeanNotificationInfo();
        String className = this.getMBeanClassName();
        String description = this.getMBeanDescription();
        return new MBeanInfo(className, description, attrs, ctors, opers, notifs);
    }

    protected MBeanAttributeInfo[] createMBeanAttributeInfo() {
        return null;
    }

    protected MBeanConstructorInfo[] createMBeanConstructorInfo() {
        return null;
    }

    protected MBeanOperationInfo[] createMBeanOperationInfo() {
        return null;
    }

    protected MBeanNotificationInfo[] createMBeanNotificationInfo() {
        return null;
    }

    protected String getMBeanClassName() {
        return this.getClass().getName();
    }

    protected String getMBeanDescription() {
        return null;
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return null;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        if (attributes != null) {
            for (int i = 0; i < attributes.length; ++i) {
                String attribute = attributes[i];
                try {
                    Object result = this.getAttribute(attribute);
                    list.add(new Attribute(attribute, result));
                    continue;
                }
                catch (AttributeNotFoundException ignored) {
                    continue;
                }
                catch (MBeanException ignored) {
                    continue;
                }
                catch (ReflectionException ignored) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList list = new AttributeList();
        if (attributes != null) {
            for (int i = 0; i < attributes.size(); ++i) {
                Attribute attribute = (Attribute)attributes.get(i);
                try {
                    this.setAttribute(attribute);
                    list.add(attribute);
                    continue;
                }
                catch (AttributeNotFoundException ignored) {
                    continue;
                }
                catch (InvalidAttributeValueException ignored) {
                    continue;
                }
                catch (MBeanException ignored) {
                    continue;
                }
                catch (ReflectionException ignored) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    public Object invoke(String method, Object[] arguments, String[] params) throws MBeanException, ReflectionException {
        return null;
    }
}

