/*
 * Decompiled with CFR 0.152.
 */
package hm.binkley.util.concurrent;

import hm.binkley.util.Mixin;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CompletableExecutors {
    @Nonnull
    public static CompletableExecutorService completable(@Nonnull ExecutorService threads) {
        return (CompletableExecutorService)Mixin.newMixin(CompletableExecutorService.class, (Object[])new Object[]{new Overrides(threads), threads});
    }

    public static final class Overrides {
        private final ExecutorService threads;

        private Overrides(ExecutorService threads) {
            this.threads = threads;
        }

        @Nonnull
        public <T> CompletableFuture<T> submit(@Nonnull Callable<T> task) {
            CompletableFuture cf = new CompletableFuture();
            this.threads.submit(() -> {
                try {
                    cf.complete(task.call());
                }
                catch (CancellationException e) {
                    cf.cancel(true);
                }
                catch (Exception e) {
                    cf.completeExceptionally(e);
                }
            });
            return cf;
        }

        @Nonnull
        public <T> CompletableFuture<T> submit(@Nonnull Runnable task, @Nullable T result) {
            return this.submit(Executors.callable(task, result));
        }

        @Nonnull
        public CompletableFuture<?> submit(@Nonnull Runnable task) {
            return this.submit(Executors.callable(task));
        }
    }

    public static interface CompletableExecutorService
    extends ExecutorService {
        @Nonnull
        public <T> CompletableFuture<T> submit(@Nonnull Callable<T> var1);

        @Nonnull
        public <T> CompletableFuture<T> submit(@Nonnull Runnable var1, @Nullable T var2);

        @Nonnull
        public CompletableFuture<?> submit(@Nonnull Runnable var1);
    }
}

