/*
 * Decompiled with CFR 0.152.
 */
package hm.binkley.util.concurrent;

import hm.binkley.util.Mixin;
import java.io.Closeable;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CompletableExecutors {
    @Nonnull
    public static CompletableExecutorService completable(@Nonnull ExecutorService threads) {
        return (CompletableExecutorService)Mixin.newMixin(CompletableExecutorService.class, (Object[])new Object[]{new Overrides(threads), threads});
    }

    private static final class UnwrappedCompletableFuture<T>
    extends CompletableFuture<T> {
        private UnwrappedCompletableFuture() {
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return (T)UnwrappedInterrupts.unwrap(() -> super.get());
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return (T)UnwrappedInterrupts.unwrap(() -> super.get(timeout, unit));
        }

        @FunctionalInterface
        private static interface UnwrappedInterrupts<T, E extends Exception> {
            public T get() throws InterruptedException, ExecutionException, E;

            public static <T, E extends Exception> T unwrap(UnwrappedInterrupts<T, E> wrapped) throws InterruptedException, ExecutionException, E {
                try {
                    return wrapped.get();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof InterruptedException) {
                        throw (InterruptedException)cause;
                    }
                    throw e;
                }
            }
        }
    }

    public static final class Overrides {
        private final ExecutorService threads;

        private Overrides(ExecutorService threads) {
            this.threads = threads;
        }

        @Nonnull
        public <T> CompletableFuture<T> submit(@Nonnull Callable<T> task) {
            UnwrappedCompletableFuture cf = new UnwrappedCompletableFuture();
            this.threads.submit(() -> {
                try {
                    cf.complete(task.call());
                }
                catch (CancellationException e) {
                    cf.cancel(true);
                }
                catch (Exception e) {
                    cf.completeExceptionally(e);
                }
            });
            return cf;
        }

        @Nonnull
        public <T> CompletableFuture<T> submit(@Nonnull Runnable task, @Nullable T result) {
            return this.submit(Executors.callable(task, result));
        }

        @Nonnull
        public CompletableFuture<?> submit(@Nonnull Runnable task) {
            return this.submit(Executors.callable(task));
        }

        public void close() {
            this.threads.shutdown();
        }
    }

    public static interface CompletableExecutorService
    extends ExecutorService,
    Closeable {
        @Nonnull
        public <T> CompletableFuture<T> submit(@Nonnull Callable<T> var1);

        @Nonnull
        public <T> CompletableFuture<T> submit(@Nonnull Runnable var1, @Nullable T var2);

        @Nonnull
        public CompletableFuture<?> submit(@Nonnull Runnable var1);

        @Override
        public void close();
    }
}

