/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware;

import house.inksoftware.degs.DEGSTest;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DegsTestRunner {
    private static final Logger log = LoggerFactory.getLogger(DegsTestRunner.class);
    private static final String PACKAGE_NAME = "house.inksoftware.degs";

    public static void run(List<String> excludedTests) {
        List<String> classNames = DegsTestRunner.getPathsOfClassesImplementingDegsTest(PACKAGE_NAME);
        DegsTestRunner.printViolationLogs(classNames, excludedTests);
        log.info("Executing tests from classes implementing DEGSTest:");
        classNames.forEach(className -> {
            try {
                if (!DegsTestRunner.isTestClassExcluded(className, excludedTests)) {
                    DegsTestRunner.runTestsFromClass(className);
                }
            }
            catch (Exception e) {
                log.error(e.getCause().toString());
                throw new RuntimeException("Test fails in class: " + className);
            }
        });
        log.info("Done.");
    }

    public static void run() {
        List<String> classNames = DegsTestRunner.getPathsOfClassesImplementingDegsTest(PACKAGE_NAME);
        DegsTestRunner.printViolationLogs(classNames);
        log.info("EXECUTING TESTS FROM CLASSES IMPLEMENTING DEGSTest:");
        classNames.forEach(className -> {
            try {
                DegsTestRunner.runTestsFromClass(className);
            }
            catch (Exception e) {
                log.error(e.getCause().toString());
                throw new RuntimeException("Test fails in class: " + className);
            }
        });
        log.info("Done.");
    }

    private static List<String> getPathsOfClassesImplementingDegsTest(String packageName) {
        ArrayList<String> classNames = new ArrayList<String>();
        String degsTestClassName = packageName + ".DEGSTest";
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String path = packageName.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(path);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if (resource.getProtocol().equals("file")) {
                    DegsTestRunner.processDirectory(resource, packageName, degsTestClassName, classNames);
                    continue;
                }
                if (!resource.getProtocol().equals("jar")) continue;
                DegsTestRunner.processJarFile(resource, path, degsTestClassName, classNames);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classNames;
    }

    private static void processDirectory(URL resource, String packageName, String degsTestClassName, List<String> classNames) {
        try {
            File directory = new File(resource.getFile());
            if (directory.isDirectory()) {
                for (String file : directory.list()) {
                    if (!file.endsWith(".class")) continue;
                    String className = packageName + "." + file.substring(0, file.length() - 6);
                    DegsTestRunner.addIfImplementsDegsTest(classNames, degsTestClassName, className);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void processJarFile(URL resource, String path, String degsTestClassName, List<String> classNames) {
        try {
            JarURLConnection jarConn = (JarURLConnection)resource.openConnection();
            JarFile jar = jarConn.getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.startsWith(path) || !entryName.endsWith(".class")) continue;
                String className = entryName.replace('/', '.').substring(0, entryName.length() - 6);
                DegsTestRunner.addIfImplementsDegsTest(classNames, degsTestClassName, className);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addIfImplementsDegsTest(List<String> classNames, String degsTestClassName, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            for (Class<?> intf : clazz.getInterfaces()) {
                if (!intf.getName().equals(degsTestClassName)) continue;
                classNames.add(className);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void runTestsFromClass(String className) throws InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        try {
            Method[] methods;
            Class<?> clazz = Class.forName(className);
            Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Method method : methods = clazz.getDeclaredMethods()) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = method.getAnnotations()) {
                    if (!(annotation instanceof Test)) continue;
                    if ((method.getModifiers() & 8) != 0) {
                        method.invoke(null, new Object[0]);
                        continue;
                    }
                    method.invoke(instance, new Object[0]);
                }
            }
        }
        catch (ClassNotFoundException e) {
            log.error("Class not found: " + className);
        }
        catch (Exception e) {
            throw e;
        }
    }

    private static boolean isTestClassExcluded(String className, List<String> excludedTests) {
        try {
            Class<?> clazz = Class.forName(className);
            if (DEGSTest.class.isAssignableFrom(clazz)) {
                DEGSTest testInstance = (DEGSTest)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return excludedTests.contains(testInstance.name());
            }
        }
        catch (Exception e) {
            log.error("Error checking if class is excluded: " + className);
        }
        return false;
    }

    private static void printViolationLogs(List<String> classNames, List<String> excludedTests) {
        log.info("PRINTING VIOLATION LOGS");
        classNames.forEach(className -> {
            try {
                if (!DegsTestRunner.isTestClassExcluded(className, excludedTests)) {
                    DegsTestRunner.runTestsFromClass(className);
                }
            }
            catch (Exception e) {
                log.error(e.getCause().toString());
            }
        });
        log.info("FINISHED PRINTING VIOLATION LOGS");
    }

    private static void printViolationLogs(List<String> classNames) {
        log.info("PRINTING VIOLATION LOGS");
        classNames.forEach(className -> {
            try {
                DegsTestRunner.runTestsFromClass(className);
            }
            catch (Exception e) {
                log.error(e.getCause().toString());
            }
        });
        log.info("FINISHED PRINTING VIOLATION LOGS");
    }
}

