/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware.degs;

import house.inksoftware.degs.DEGSTest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.yaml.snakeyaml.Yaml;

public class CircularReferenceConfigurationCheck
implements DEGSTest {
    private static final String VIOLATION_SOURCE = "[CIRCULAR REFERENCE CONFIG VIOLATION]: ";
    private static final String EXPLANATION = "Circular references can lead to undesired behavior in a Spring application.";

    @Test
    public void testCircularReferenceConfiguration() {
        Path resourcesPath = Paths.get("src/main/resources", new String[0]);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(resourcesPath, "application*.yml");){
            for (Path ymlFile : directoryStream) {
                this.checkYmlFile(ymlFile);
            }
        }
        catch (IOException e) {
            Assertions.fail((String)("[CIRCULAR REFERENCE CONFIG VIOLATION]: Failed to read application files: " + e.getMessage()));
        }
    }

    private void checkYmlFile(Path ymlFile) {
        Assertions.assertTrue((boolean)Files.exists(ymlFile, new LinkOption[0]), (String)(VIOLATION_SOURCE + String.valueOf(ymlFile.getFileName()) + " is not present."));
        try (InputStream inputStream = Files.newInputStream(ymlFile, new OpenOption[0]);){
            Yaml yaml = new Yaml();
            Map obj = (Map)yaml.load(inputStream);
            if (obj == null || !obj.containsKey("spring")) {
                Assertions.fail((String)("[CIRCULAR REFERENCE CONFIG VIOLATION]: spring property is missing in " + String.valueOf(ymlFile.getFileName()) + ". Circular references can lead to undesired behavior in a Spring application."));
                return;
            }
            Map spring = (Map)obj.get("spring");
            if (spring == null || !spring.containsKey("main")) {
                return;
            }
            Map main = (Map)spring.get("main");
            if (main == null) {
                return;
            }
            Object allowCircularReferences = main.get("allow-circular-references");
            if (Boolean.TRUE.equals(allowCircularReferences)) {
                Assertions.fail((String)("[CIRCULAR REFERENCE CONFIG VIOLATION]: spring.main.allow-circular-references is set to true in " + String.valueOf(ymlFile.getFileName()) + ". Circular references can lead to undesired behavior in a Spring application."));
            }
        }
        catch (IOException e) {
            Assertions.fail((String)("[CIRCULAR REFERENCE CONFIG VIOLATION]: Failed to read " + String.valueOf(ymlFile.getFileName()) + ": " + e.getMessage()));
        }
        catch (ClassCastException e) {
            Assertions.fail((String)("[CIRCULAR REFERENCE CONFIG VIOLATION]: Failed to cast YAML fields in " + String.valueOf(ymlFile.getFileName()) + ": " + e.getMessage()));
        }
    }

    @Override
    public String name() {
        return "circular-reference-configuration-check";
    }
}

