/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware.degs;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.ThrowStmt;
import house.inksoftware.degs.DEGSTest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CodingConventionTests
implements DEGSTest {
    private static final String PATH = "src/main/java";
    private static final String ERROR_LOGGING_REGEX = "(?s).*log\\.error\\(\"(.+?)\",\\s*ExceptionUtils\\.getStackTrace\\(e\\),\\s*now\\(\\)\\)(?s).*";
    private static final String INFO_LOGGING_REGEX = "(?s).*\\{\\s*log\\.info.*";
    private static final Pattern PATTERN = Pattern.compile("(?s).*log\\.error\\(\"(.+?)\",\\s*ExceptionUtils\\.getStackTrace\\(e\\),\\s*now\\(\\)\\)(?s).*");
    private static List<Path> allPaths;
    private static final String IGNORE_LOG = "// ignore";
    private static final Map<String, CompilationUnit> parsers;
    private static final String VIOLATION_SOURCE = "[CODING CONVENTIONS VIOLATION]: ";

    @Test
    public void runDEGSTests() {
        CodingConventionTests.findAllFilePaths();
        this.testLoggingExistsInCatchBlock();
        this.testControllerContainsLogStatement();
        this.testMethodReturnsVariableNamedResult();
        this.testControllerMethodIsNoMoreThanFiveLines();
    }

    public static void findAllFilePaths() throws IOException {
        allPaths = Files.walk(Paths.get(PATH, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> file.toString().endsWith(".java")).collect(Collectors.toList());
        allPaths.stream().map(Path::toFile).collect(Collectors.toList()).forEach(file -> parsers.put(file.getName(), CodingConventionTests.parseFile(file)));
    }

    private static CompilationUnit parseFile(File file) {
        ParserConfiguration parserConfiguration = new ParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_17);
        StaticJavaParser.setConfiguration((ParserConfiguration)parserConfiguration);
        try {
            return StaticJavaParser.parse((File)file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void testLoggingExistsInCatchBlock() {
        allPaths.forEach(file -> this.processFileToCheckIfLoggingExistsInCatchBlock(file.toFile()));
    }

    public void testControllerContainsLogStatement() {
        allPaths.stream().filter(file -> file.toString().endsWith("Controller.java")).forEach(this::processControllerFile);
    }

    public void testMethodReturnsVariableNamedResult() {
        allPaths.forEach(this::processFileToCheckReturnVariableNameFromMethod);
    }

    public void testControllerMethodIsNoMoreThanFiveLines() {
        allPaths.stream().filter(file -> file.toString().endsWith("Controller.java")).forEach(this::processControllerFileToCheckMethodLength);
    }

    private void processControllerFile(Path path) {
        CompilationUnit compilationUnit = parsers.get(path.toFile().getName());
        List methods = compilationUnit.findAll(MethodDeclaration.class);
        methods.stream().filter(methodDeclaration -> methodDeclaration.getBody().isPresent()).filter(methodDeclaration -> ((BlockStmt)methodDeclaration.getBody().get()).getStatements().size() > 0).filter(methodDeclaration -> !CodingConventionTests.isLoggingFirstStatementInController((BlockStmt)methodDeclaration.getBody().get())).forEach(method -> Assertions.fail((String)("[CODING CONVENTIONS VIOLATION]: Logging is not first statement in controller method:\n" + String.valueOf(method) + "\n Please add logs as first statement in the method. Example: log.info(\"....\");")));
    }

    public void processFileToCheckReturnVariableNameFromMethod(Path path) {
        CompilationUnit compilationUnit = parsers.get(path.toFile().getName());
        List methods = compilationUnit.findAll(MethodDeclaration.class);
        if (!methods.isEmpty()) {
            methods.stream().filter(methodDeclaration -> methodDeclaration.getBody().isPresent()).filter(methodDeclaration -> !CodingConventionTests.isVariableResultDefinedInMethodReturned(methodDeclaration)).forEach(method -> Assertions.fail((String)("[CODING CONVENTIONS VIOLATION]: Variable returned should be named result in method:\n" + String.valueOf(method) + "\n Please rename the returned variable to result.")));
        }
    }

    private void processFileToCheckIfLoggingExistsInCatchBlock(File file) {
        CompilationUnit compilationUnit = parsers.get(file.getName());
        List methods = compilationUnit.findAll(MethodDeclaration.class);
        methods.forEach(method -> method.findAll(CatchClause.class).stream().filter(catchClause -> !CodingConventionTests.catchHasIgnoreComment(catchClause)).filter(catchClause -> !CodingConventionTests.isLoggingStatementPresent((List<Statement>)catchClause.getBody().getStatements())).filter(catchClause -> !CodingConventionTests.catchClauseThrowsException(catchClause)).forEach(catchClause -> {
            if (catchClause.getTokenRange().isPresent()) {
                String location = ((TokenRange)catchClause.getTokenRange().get()).getBegin().toString();
                Assertions.fail((String)("[CODING CONVENTIONS VIOLATION]: Catch block without logging found in class:\n" + file.getName() + "method:\n" + method.getDeclarationAsString() + " at " + location.substring(location.indexOf("line"), location.indexOf(",", location.indexOf("line"))) + "\nYou can either add \"// ignore\" as first statement in catch block or follow the below steps to add logs:\n1. Add the following library to build.gradle: implementation 'org.apache.commons:commons-lang3:3.13.0'\n2. Add log.error(\"Exception: {} at: {}\", ExceptionUtils.getStackTrace(e), now());"));
            }
        }));
    }

    private static boolean isLoggingStatementPresent(List<Statement> statements) {
        return statements.stream().anyMatch(statement -> PATTERN.matcher(statement.toString()).find());
    }

    private static boolean isLoggingFirstStatementInController(BlockStmt body) {
        return body.toString().matches(INFO_LOGGING_REGEX);
    }

    private static boolean isVariableResultDefinedInMethodReturned(MethodDeclaration methodDeclaration) {
        Optional returnStmt = methodDeclaration.findFirst(ReturnStmt.class);
        List vars = methodDeclaration.findAll(VariableDeclarator.class).stream().map(VariableDeclarator::getName).map(SimpleName::getIdentifier).collect(Collectors.toList());
        if (returnStmt.isPresent()) {
            Expression returnExpression = ((ReturnStmt)returnStmt.get()).getExpression().orElse(null);
            if (returnExpression instanceof NameExpr) {
                String returnVariableName = ((NameExpr)returnExpression).getNameAsString();
                return !vars.contains(returnVariableName) || returnVariableName.equals("result");
            }
            return true;
        }
        return true;
    }

    private static boolean catchClauseThrowsException(CatchClause catchClause) {
        return catchClause.getBody().getStatements().stream().anyMatch(stmt -> stmt instanceof ThrowStmt);
    }

    private static boolean catchHasIgnoreComment(CatchClause catchClause) {
        List childNodes = catchClause.getAllContainedComments();
        return !childNodes.isEmpty() && ((Comment)childNodes.get(0)).toString().contains(IGNORE_LOG);
    }

    private void processControllerFileToCheckMethodLength(Path path) {
        CompilationUnit compilationUnit = parsers.get(path.toFile().getName());
        List methods = compilationUnit.findAll(MethodDeclaration.class);
        methods.stream().filter(methodDeclaration -> methodDeclaration.getBody().isPresent()).filter(methodDeclaration -> !((BlockStmt)methodDeclaration.getBody().get()).getStatements().isEmpty()).filter(methodDeclaration -> ((BlockStmt)methodDeclaration.getBody().get()).getStatements().size() > 5).forEach(method -> Assertions.fail((String)("[CODING CONVENTIONS VIOLATION]: Method: \n" + method.getDeclarationAsString() + "\n has more than 5 lines. \nPlease adjust the method length so that it would have less than 5 lines.")));
    }

    @Override
    public String name() {
        return "coding-convention-tests";
    }

    static {
        parsers = new HashMap<String, CompilationUnit>();
    }
}

