/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware.degs;

import house.inksoftware.degs.DEGSTest;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jgit.api.Git;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FlywayMigrationImmutabilityCheck
implements DEGSTest {
    private static final String VIOLATION_SOURCE = "[FLYWAY IMMUTABILITY VIOLATION]: ";
    private static final String EXPLANATION = "Flyway migration scripts should be immutable after their initial commit. Modifying a migration script can lead to inconsistent database states across environments.";

    @Test
    public void testMigrationScriptImmutability() {
        String migrationDirectoryPath = "src/main/resources/db/migration";
        File migrationDirectory = new File(migrationDirectoryPath);
        if (!migrationDirectory.isDirectory()) {
            return;
        }
        try (Stream<Path> paths = Files.walk(Paths.get(migrationDirectoryPath, new String[0]), new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".sql")).forEach(this::checkGitHistory);
        }
        catch (Exception e) {
            Assertions.fail((String)("[FLYWAY IMMUTABILITY VIOLATION]: Failed to check migrations: " + e.getMessage()));
        }
    }

    private void checkGitHistory(Path migrationPath) {
        File gitRoot = this.findGitRootDirectory(new File("."));
        if (gitRoot == null) {
            Assertions.fail((String)("[FLYWAY IMMUTABILITY VIOLATION]: Failed to find git root directory for " + String.valueOf(migrationPath)));
            return;
        }
        try (Git git = Git.open((File)gitRoot);){
            Set unstagedChanges = git.status().call().getModified();
            if (unstagedChanges.contains(migrationPath.toString())) {
                Assertions.fail((String)(VIOLATION_SOURCE + String.valueOf(migrationPath) + " has uncommitted local changes. Flyway migration scripts should be immutable after their initial commit. Modifying a migration script can lead to inconsistent database states across environments."));
                return;
            }
            Set stagedChanges = git.status().call().getChanged();
            if (stagedChanges.contains(migrationPath.toString())) {
                Assertions.fail((String)(VIOLATION_SOURCE + String.valueOf(migrationPath) + " has staged changes that are not yet committed. Flyway migration scripts should be immutable after their initial commit. Modifying a migration script can lead to inconsistent database states across environments."));
                return;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)("[FLYWAY IMMUTABILITY VIOLATION]: Failed to parse git history for " + String.valueOf(migrationPath) + ": " + e.getMessage()));
        }
    }

    private File findGitRootDirectory(File startDir) {
        File currentDir = startDir;
        int maxDepth = 3;
        String userHome = System.getProperty("user.home");
        for (int currentDepth = 0; currentDir != null && currentDepth < maxDepth; currentDir = currentDir.getParentFile(), ++currentDepth) {
            File gitDir = new File(currentDir, ".git");
            if (gitDir.exists() && gitDir.isDirectory()) {
                return currentDir;
            }
            if (currentDir.getAbsolutePath().equals(userHome)) break;
        }
        return null;
    }

    @Override
    public String name() {
        return "flyway-migration-immutability-check";
    }
}

