/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware.degs;

import house.inksoftware.degs.DEGSTest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.yaml.snakeyaml.Yaml;

public class FlywaySchemaVersionIsolationTest
implements DEGSTest {
    private static final String VIOLATION_SOURCE = "[FLYWAY SCHEMA VIOLATION]: ";
    private static final String EXPLANATION = "We must add it because one database can be shared between multiple \" +\n                        \"microservices that have Flyway and keeping migration history in one table would cause conflicts.";

    @Test
    public void testFlywaySchemaTableProperty() {
        String migrationDirectoryPath = "src/main/resources/db/migration/table";
        File migrationDirectory = new File(migrationDirectoryPath);
        if (!migrationDirectory.isDirectory()) {
            return;
        }
        String ymlFilePath = "src/main/resources/application.yml";
        Path ymlFile = Paths.get(ymlFilePath, new String[0]);
        Assertions.assertTrue((boolean)Files.exists(ymlFile, new LinkOption[0]), (String)"[FLYWAY SCHEMA VIOLATION]: application.yml is not present.");
        try (InputStream inputStream = Files.newInputStream(ymlFile, new OpenOption[0]);){
            Yaml yaml = new Yaml();
            Map obj = (Map)yaml.load(inputStream);
            if (obj == null || !obj.containsKey("spring")) {
                Assertions.fail((String)"[FLYWAY SCHEMA VIOLATION]: spring property is missing in application file. We must add it because one database can be shared between multiple \" +\n                        \"microservices that have Flyway and keeping migration history in one table would cause conflicts.");
                return;
            }
            Map spring = (Map)obj.get("spring");
            if (spring == null || !spring.containsKey("flyway")) {
                Assertions.fail((String)"[FLYWAY SCHEMA VIOLATION]: spring.flyway property is missing in application file.We must add it because one database can be shared between multiple \" +\n                        \"microservices that have Flyway and keeping migration history in one table would cause conflicts.");
                return;
            }
            Map flyway = (Map)spring.get("flyway");
            if (flyway == null || !flyway.containsKey("table")) {
                Assertions.fail((String)"[FLYWAY SCHEMA VIOLATION]: spring.flyway.table property is missing in application file.We must add it because one database can be shared between multiple \" +\n                        \"microservices that have Flyway and keeping migration history in one table would cause conflicts.");
                return;
            }
            Object table = flyway.get("table");
            Assertions.assertNotNull(table, (String)"[FLYWAY SCHEMA VIOLATION]: spring.flyway.table property is null in application file.");
        }
        catch (IOException e) {
            Assertions.fail((String)("[FLYWAY SCHEMA VIOLATION]: Failed to read application file: " + e.getMessage()));
        }
        catch (ClassCastException e) {
            Assertions.fail((String)("[FLYWAY SCHEMA VIOLATION]: Failed to cast YAML fields: " + e.getMessage()));
        }
    }

    @Override
    public String name() {
        return "flyway-schema-version-isolation-test";
    }
}

