/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware.degs;

import house.inksoftware.degs.DEGSTest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FlywayTableStructureTest
implements DEGSTest {
    private static final String VIOLATION_SOURCE = "[FLYWAY VIOLATION]: ";
    private static final String EXPLANATION = " Flyway is designed to evolve database table structures, not for one time migrations.";

    @Test
    public void testMigrationSQLContent() {
        String migrationDirectoryPath = "src/main/resources/db/migration/table";
        File migrationDirectory = new File(migrationDirectoryPath);
        if (!migrationDirectory.isDirectory()) {
            return;
        }
        File[] migrationFiles = migrationDirectory.listFiles();
        if (migrationFiles != null) {
            for (File migrationFile : migrationFiles) {
                String migrationFileName = migrationFile.getName();
                try {
                    this.assertSQLContent(migrationFile);
                }
                catch (IOException e) {
                    Assertions.fail((String)("[FLYWAY VIOLATION]: Error reading migration file: " + migrationFileName), (Throwable)e);
                }
            }
        } else {
            Assertions.fail((String)"[FLYWAY VIOLATION]: Migration directory is empty or not readable.");
        }
    }

    private void assertSQLContent(File migrationFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(migrationFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                Assertions.assertFalse((boolean)line.trim().toUpperCase().startsWith("DELETE"), (String)("[FLYWAY VIOLATION]: Migration script contains DELETE operation: " + migrationFile.getName() + EXPLANATION));
                Assertions.assertFalse((boolean)line.trim().toUpperCase().startsWith("TRUNCATE"), (String)("[FLYWAY VIOLATION]: Migration script contains TRUNCATE operation: " + migrationFile.getName() + EXPLANATION));
                Assertions.assertFalse((boolean)line.trim().toUpperCase().startsWith("INSERT"), (String)("[FLYWAY VIOLATION]: Migration script contains INSERT operation: " + migrationFile.getName() + EXPLANATION));
            }
        }
    }

    @Override
    public String name() {
        return "flyway-table-structure-tests";
    }
}

