/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware.degs;

import house.inksoftware.degs.DEGSTest;
import java.io.File;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FlywayTests
implements DEGSTest {
    private static final Pattern MIGRATION_FILE_PATTERN = Pattern.compile("V\\d{4}\\.\\d{2}\\.\\d{2}\\.\\d{2}\\.\\d{2}\\.\\d{2}__.*\\.sql");
    private static final String VIOLATION_SOURCE = "[FLYWAY VIOLATION]: ";

    @Test
    public void testMigrationFileNamingConvention() {
        File[] migrationFiles;
        String migrationDirectoryPath = "src/main/resources/db/migration/table";
        File migrationDirectory = new File(migrationDirectoryPath);
        Assertions.assertTrue((boolean)migrationDirectory.isDirectory(), (String)"[FLYWAY VIOLATION]: Migration directory is not present.");
        for (File migrationFile : migrationFiles = migrationDirectory.listFiles()) {
            String migrationFileName = migrationFile.getName();
            Assertions.assertTrue((boolean)MIGRATION_FILE_PATTERN.matcher(migrationFileName).matches(), (String)("[FLYWAY VIOLATION]: Migration file name does not match naming convention: " + migrationFileName));
        }
    }

    @Override
    public String name() {
        return "flyway-tests";
    }
}

