/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware.degs;

import house.inksoftware.degs.DEGSTest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.yaml.snakeyaml.Yaml;

public class HibernateValidateSchemeTest
implements DEGSTest {
    private static final String VIOLATION_SOURCE = "[HIBERNATE SCHEME VALIDATION VIOLATION]: ";

    @Test
    public void testApplicationYmlHasContextPathProperty() {
        String ymlFilePath = "src/main/resources/application.yml";
        Path ymlFile = Paths.get(ymlFilePath, new String[0]);
        Assertions.assertTrue((boolean)Files.exists(ymlFile, new LinkOption[0]), (String)"[HIBERNATE SCHEME VALIDATION VIOLATION]: application.yml is not present.");
        try (InputStream inputStream = Files.newInputStream(ymlFile, new OpenOption[0]);){
            Yaml yaml = new Yaml();
            Map obj = (Map)yaml.load(inputStream);
            if (obj == null || !obj.containsKey("jpa")) {
                Assertions.fail((String)"[HIBERNATE SCHEME VALIDATION VIOLATION]: jpa property is missing in application file. ");
                return;
            }
            Map jpa = (Map)obj.get("jpa");
            if (jpa == null || !jpa.containsKey("hibernate")) {
                Assertions.fail((String)"[HIBERNATE SCHEME VALIDATION VIOLATION]: hibernate property is missing in application file.");
                return;
            }
            Map hibernate = (Map)jpa.get("hibernate");
            if (hibernate == null || !hibernate.containsKey("ddl-auto")) {
                Assertions.fail((String)"[HIBERNATE SCHEME VALIDATION VIOLATION]: ddl-auto property is missing in application file.");
                return;
            }
            this.assertPropertyPresenceWithValue(hibernate, "ddl-auto", "validate");
        }
        catch (IOException e) {
            Assertions.fail((String)("[HIBERNATE SCHEME VALIDATION VIOLATION]: Failed to read application file: " + e.getMessage()));
        }
        catch (ClassCastException e) {
            Assertions.fail((String)("[HIBERNATE SCHEME VALIDATION VIOLATION]: Failed to cast to YAML fields: " + e.getMessage()));
        }
    }

    private void assertPropertyPresence(Map<String, Object> properties, String propertyName) {
        if (properties == null || !properties.containsKey(propertyName)) {
            Assertions.fail((String)("[HIBERNATE SCHEME VALIDATION VIOLATION]: Property \"" + propertyName + "\" is missing. "));
        }
        if (properties.get(propertyName) == null) {
            Assertions.fail((String)("[HIBERNATE SCHEME VALIDATION VIOLATION]: Property \"" + propertyName + "\" is missing value."));
        }
    }

    private void assertPropertyPresenceWithValue(Map<String, Object> properties, String propertyName, Object expectedValue) {
        this.assertPropertyPresence(properties, propertyName);
        Object actualValue = properties.get(propertyName);
        Assertions.assertEquals((Object)expectedValue, (Object)actualValue, (String)("[HIBERNATE SCHEME VALIDATION VIOLATION]: Property \"" + propertyName + "\" has an unexpected value. Expected: " + String.valueOf(expectedValue) + ", Actual: " + String.valueOf(actualValue)));
    }

    @Override
    public String name() {
        return "hibernate-validate-scheme-test";
    }
}

