/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware.degs;

import house.inksoftware.degs.DEGSTest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.yaml.snakeyaml.Yaml;

public class HikariSchemaConfigPresenceTest
implements DEGSTest {
    private static final String VIOLATION_SOURCE = "[HIKARI SCHEMA VIOLATION]: ";
    private static final String EXPLANATION = "Hikari schema is needed in the application file for defining the default database schema and ensuring proper data access management";

    @Test
    public void testHikariSchemaConfigPresence() {
        String migrationDirectoryPath = "src/main/resources/db/migration/table";
        File migrationDirectory = new File(migrationDirectoryPath);
        if (!migrationDirectory.isDirectory()) {
            return;
        }
        String ymlFilePath = "src/main/resources/application.yml";
        Path ymlFile = Paths.get(ymlFilePath, new String[0]);
        Assertions.assertTrue((boolean)Files.exists(ymlFile, new LinkOption[0]), (String)"[HIKARI SCHEMA VIOLATION]: application.yml is not present.");
        try (InputStream inputStream = Files.newInputStream(ymlFile, new OpenOption[0]);){
            Yaml yaml = new Yaml();
            Map obj = (Map)yaml.load(inputStream);
            if (obj == null || !obj.containsKey("spring")) {
                Assertions.fail((String)"[HIKARI SCHEMA VIOLATION]: spring property is missing in application file.Hikari schema is needed in the application file for defining the default database schema and ensuring proper data access management");
                return;
            }
            Map spring = (Map)obj.get("spring");
            if (spring == null || !spring.containsKey("datasource")) {
                Assertions.fail((String)"[HIKARI SCHEMA VIOLATION]: spring.datasource property is missing in application file.Hikari schema is needed in the application file for defining the default database schema and ensuring proper data access management");
                return;
            }
            Map datasource = (Map)spring.get("datasource");
            if (datasource == null || !datasource.containsKey("hikari")) {
                Assertions.fail((String)"[HIKARI SCHEMA VIOLATION]: spring.datasource.hikari property is missing in application file.Hikari schema is needed in the application file for defining the default database schema and ensuring proper data access management");
                return;
            }
            Map hikari = (Map)datasource.get("hikari");
            if (hikari == null || !hikari.containsKey("schema")) {
                Assertions.fail((String)"[HIKARI SCHEMA VIOLATION]: spring.datasource.hikari.schema property is missing in application file.Hikari schema is needed in the application file for defining the default database schema and ensuring proper data access management");
                return;
            }
            Object schema = hikari.get("schema");
            Assertions.assertNotNull(schema, (String)"[HIKARI SCHEMA VIOLATION]: spring.datasource.hikari.schema property is null.Hikari schema is needed in the application file for defining the default database schema and ensuring proper data access management");
        }
        catch (IOException e) {
            Assertions.fail((String)("[HIKARI SCHEMA VIOLATION]: Failed to read application file: " + e.getMessage()));
        }
        catch (ClassCastException e) {
            Assertions.fail((String)("[HIKARI SCHEMA VIOLATION]: Failed to cast to YAML fields: " + e.getMessage()));
        }
    }

    @Override
    public String name() {
        return "hikari-schema-config-presence";
    }
}

