/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware.degs;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import house.inksoftware.degs.DEGSTest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KafkaListenerCorrectnessTest
implements DEGSTest {
    private static final String VIOLATION_SOURCE = "[KAFKA LISTENER VIOLATION]: ";
    private static List<Path> allPaths;
    private static final String PATH = "src/main/java";
    private static final Map<String, CompilationUnit> parsers;

    @Test
    public void runDEGSTests() {
        KafkaListenerCorrectnessTest.findAllFilePaths();
        this.testTopicHasDefaultRetrialMechanism();
    }

    public static void findAllFilePaths() throws IOException {
        allPaths = Files.walk(Paths.get(PATH, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> file.toString().endsWith(".java")).collect(Collectors.toList());
        allPaths.stream().map(Path::toFile).collect(Collectors.toList()).forEach(file -> parsers.put(file.getName(), KafkaListenerCorrectnessTest.parseFile(file)));
    }

    private static CompilationUnit parseFile(File file) {
        ParserConfiguration parserConfiguration = new ParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_17);
        StaticJavaParser.setConfiguration((ParserConfiguration)parserConfiguration);
        try {
            return StaticJavaParser.parse((File)file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void testTopicHasDefaultRetrialMechanism() {
        allPaths.stream().filter(file -> file.toString().endsWith("KafkaIncomingEventHandler.java")).forEach(this::processHandlerMethods);
    }

    private void processHandlerMethods(Path path) {
        CompilationUnit compilationUnit = parsers.get(path.toFile().getName());
        List methods = compilationUnit.findAll(MethodDeclaration.class);
        methods.stream().filter(methodDeclaration -> methodDeclaration.getBody().isPresent()).filter(methodDeclaration -> methodDeclaration.getAnnotations().isEmpty()).forEach(method -> Assertions.fail((String)("[KAFKA LISTENER VIOLATION]: Method: " + method.getDeclarationAsString() + " should be annotated with @KafkaListener")));
        methods.stream().filter(methodDeclaration -> methodDeclaration.getBody().isPresent()).filter(methodDeclaration -> methodDeclaration.getAnnotationByName("KafkaListener").isPresent()).filter(methodDeclaration -> !this.hasConcurrencyAttribute((MethodDeclaration)methodDeclaration)).forEach(method -> Assertions.fail((String)("[KAFKA LISTENER VIOLATION]: Method: " + method.getDeclarationAsString() + " should have the 'concurrency' attribute defined in @KafkaListener annotation")));
        methods.stream().filter(methodDeclaration -> methodDeclaration.getBody().isPresent()).filter(methodDeclaration -> !methodDeclaration.getAnnotations().isEmpty()).filter(methodDeclaration -> !this.hasContainerFactory((MethodDeclaration)methodDeclaration)).forEach(method -> Assertions.fail((String)("[KAFKA LISTENER VIOLATION]: Method: " + method.getDeclarationAsString() + " should have containerFactory defined.\n Please add containerFactory as part of the topic to have a default retrial mechanism in case event processing has failed")));
    }

    private boolean hasAnnotation(MethodDeclaration methodDeclaration, String annotationName) {
        if (!methodDeclaration.getAnnotations().isEmpty()) {
            return ((AnnotationExpr)methodDeclaration.getAnnotations().get(0)).getChildNodes().stream().filter(node -> node instanceof MemberValuePair).anyMatch(node -> ((MemberValuePair)node).getName().getIdentifier().equals(annotationName));
        }
        return false;
    }

    private boolean hasConcurrencyAttribute(MethodDeclaration methodDeclaration) {
        return this.hasAnnotation(methodDeclaration, "concurrency");
    }

    private boolean hasContainerFactory(MethodDeclaration methodDeclaration) {
        return this.hasAnnotation(methodDeclaration, "containerFactory");
    }

    @Override
    public String name() {
        return "kafka-listener-correctness-test";
    }

    static {
        parsers = new HashMap<String, CompilationUnit>();
    }
}

