/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware.degs;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import house.inksoftware.degs.DEGSTest;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LoggingConventionsTest
implements DEGSTest {
    private static final String VIOLATION_SOURCE = "[LOGGING CONVENTION VIOLATION]: ";

    @Test
    public void testLoggingConventions() {
        String sourceDirectoryPath = "src/main/java";
        File sourceDirectory = new File(sourceDirectoryPath);
        if (!sourceDirectory.isDirectory()) {
            return;
        }
        try (Stream<Path> paths = Files.walk(Paths.get(sourceDirectoryPath, new String[0]), new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".java")).forEach(this::processJavaFile);
        }
        catch (IOException e) {
            Assertions.fail((String)("[LOGGING CONVENTION VIOLATION]: Failed to read source files: " + e.getMessage()));
        }
    }

    private void processJavaFile(Path path) {
        try {
            JavaParser javaParser = new JavaParser();
            CompilationUnit compilationUnit = javaParser.parse(path).getResult().orElse(null);
            compilationUnit.accept((VoidVisitor)new LoggingAnnotationVisitor(), null);
        }
        catch (IOException e) {
            Assertions.fail((String)("[LOGGING CONVENTION VIOLATION]: Failed to parse Java file: " + e.getMessage()));
        }
    }

    @Override
    public String name() {
        return "logging-conventions-test";
    }

    private static class LoggingAnnotationVisitor
    extends VoidVisitorAdapter<Void> {
        private LoggingAnnotationVisitor() {
        }

        public void visit(ClassOrInterfaceDeclaration n, Void arg) {
            super.visit(n, (Object)arg);
            for (AnnotationExpr annotation : n.getAnnotations()) {
                String annotationName = annotation.getNameAsString();
                if (!annotationName.equals("Log4j2") && !annotationName.equals("Log") && !annotationName.equals("CommonsLog") && !annotationName.equals("JBossLog") && !annotationName.equals("Flogger") && !annotationName.equals("XSlf4j")) continue;
                Assertions.fail((String)("[LOGGING CONVENTION VIOLATION]: Found annotation: @" + annotationName + ". We should use @Sl4j logging annotation, because Sl4j is the most generic logging interface."));
            }
        }
    }
}

