/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware.degs;

import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.importer.ClassFileImporter;
import com.tngtech.archunit.core.importer.ImportOption;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.ClassesShouldConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import house.inksoftware.degs.DEGSTest;
import house.inksoftware.utils.PackageResolver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProjectStructureTests
implements DEGSTest {
    private static String BASE_PACKAGE = PackageResolver.findActualRoot().replaceAll("\\\\", ".");
    private static String CONTROLLER_PACKAGE = BASE_PACKAGE + ".controller..";
    private static String SERVICE_PACKAGE = BASE_PACKAGE + ".service..";
    private static String DAO_PACKAGE = BASE_PACKAGE + ".dao..";
    private static String INFRASTRUCTURE_PACKAGE = BASE_PACKAGE + ".infrastructure..";
    private static final String VIOLATION_SOURCE = "[PROJECT STRUCTURE VIOLATION]: ";
    private JavaClasses classes;

    @Test
    public void runProjectStructureTests() throws IOException {
        this.initiateClasses();
        this.testPackagesFollowNamingConvention();
        this.testDependenciesHaveProperConfiguration();
    }

    private void initiateClasses() {
        this.classes = new ClassFileImporter().withImportOption((ImportOption)ImportOption.Predefined.DO_NOT_INCLUDE_TESTS).importPackages(new String[]{BASE_PACKAGE});
    }

    private void testPackagesFollowNamingConvention() throws IOException {
        List<String> directories = PackageResolver.findSubdirectories(PackageResolver.findActualRoot()).stream().map(Path::toString).collect(Collectors.toList());
        this.validateFolderNames(directories);
    }

    private void validateFolderNames(List<String> paths) {
        for (String path : paths) {
            String lastFolderName = Paths.get(path, new String[0]).getFileName().toString().toLowerCase();
            if (lastFolderName.equals("dao")) {
                File dir = new File(path);
                boolean hasRepository = new File(dir, "repository").exists();
                boolean hasModel = new File(dir, "model").exists();
                if (hasRepository && hasModel) continue;
                Assertions.fail((String)"[PROJECT STRUCTURE VIOLATION]: 'dao' package must contain 'repository' and 'model' subpackages");
                continue;
            }
            if (lastFolderName.equals("service") || lastFolderName.equals("controller") || lastFolderName.equals("infrastructure")) continue;
            Assertions.fail((String)("[PROJECT STRUCTURE VIOLATION]: Package cannot be named " + lastFolderName + ". There are allowed only 'service', 'controller, 'dao', 'infrastructure' packages in the root."));
        }
    }

    private void testDependenciesHaveProperConfiguration() {
        this.controllerDependsOnService();
        this.infrastructureDependsOnService();
        this.serviceDependsOnDao();
        this.daoDependsOnNothing();
    }

    private void controllerDependsOnService() {
        ((ClassesShouldConjunction)((GivenClassesConjunction)ArchRuleDefinition.noClasses().that().resideInAnyPackage(new String[]{CONTROLLER_PACKAGE})).should().dependOnClassesThat().resideInAnyPackage(new String[]{DAO_PACKAGE, INFRASTRUCTURE_PACKAGE})).allowEmptyShould(true).check(this.classes);
    }

    private void infrastructureDependsOnService() {
        ((ClassesShouldConjunction)((GivenClassesConjunction)ArchRuleDefinition.noClasses().that().resideInAnyPackage(new String[]{INFRASTRUCTURE_PACKAGE})).should().dependOnClassesThat().resideInAnyPackage(new String[]{DAO_PACKAGE, CONTROLLER_PACKAGE})).allowEmptyShould(true).check(this.classes);
    }

    private void serviceDependsOnDao() {
        ((ClassesShouldConjunction)((GivenClassesConjunction)ArchRuleDefinition.noClasses().that().resideInAnyPackage(new String[]{SERVICE_PACKAGE})).should().dependOnClassesThat().resideInAnyPackage(new String[]{CONTROLLER_PACKAGE, INFRASTRUCTURE_PACKAGE})).allowEmptyShould(true).check(this.classes);
    }

    private void daoDependsOnNothing() {
        ((ClassesShouldConjunction)((GivenClassesConjunction)ArchRuleDefinition.noClasses().that().resideInAnyPackage(new String[]{DAO_PACKAGE})).should().dependOnClassesThat().resideInAnyPackage(new String[]{SERVICE_PACKAGE, CONTROLLER_PACKAGE, INFRASTRUCTURE_PACKAGE})).allowEmptyShould(true).check(this.classes);
    }

    @Override
    public String name() {
        return "project-structure-tests";
    }
}

