/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware.degs;

import house.inksoftware.degs.DEGSTest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.yaml.snakeyaml.Yaml;

public class PropertySanityCheck
implements DEGSTest {
    private static final String VIOLATION_SOURCE = "[PROPERTY SANITY CHECK]: ";
    private Map<String, Object> defaultProperties = new HashMap<String, Object>();

    @Test
    public void testRedundantProperties() {
        try {
            Path defaultPath = Paths.get("src/main/resources/application.yml", new String[0]);
            try (InputStream inputStream = Files.newInputStream(defaultPath, new OpenOption[0]);){
                Yaml yaml = new Yaml();
                this.defaultProperties = this.flattenMap((Map)yaml.load(inputStream), "");
            }
            catch (IOException e) {
                Assertions.fail((String)("[PROPERTY SANITY CHECK]: Failed to read YAML file: " + e.getMessage()));
            }
            Files.walk(Paths.get("src/main/resources", new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().matches(".*application(-\\w+)?\\.yml$")).filter(path -> !path.equals(defaultPath)).forEach(path -> {
                try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                    Yaml yaml = new Yaml();
                    Map<String, Object> currentProperties = this.flattenMap((Map)yaml.load(inputStream), "");
                    this.checkRedundancy(currentProperties, path.toString());
                }
                catch (IOException e) {
                    Assertions.fail((String)("[PROPERTY SANITY CHECK]: Failed to read YAML file: " + e.getMessage()));
                }
            });
        }
        catch (IOException e) {
            Assertions.fail((String)("[PROPERTY SANITY CHECK]: Failed to read YAML files: " + e.getMessage()));
        }
    }

    private Map<String, Object> flattenMap(Map<String, Object> original, String prefix) {
        HashMap<String, Object> flatMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : original.entrySet()) {
            String fullKey;
            String key = entry.getKey();
            Object value = entry.getValue();
            String string = fullKey = prefix.isEmpty() ? key : prefix + "." + key;
            if (value instanceof Map) {
                flatMap.putAll(this.flattenMap((Map)value, fullKey));
                continue;
            }
            flatMap.put(fullKey, value);
        }
        return flatMap;
    }

    private void checkRedundancy(Map<String, Object> current, String filePath) {
        for (Map.Entry<String, Object> entry : current.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!this.defaultProperties.containsKey(key) || !this.defaultProperties.get(key).equals(value)) continue;
            Assertions.fail((String)("[PROPERTY SANITY CHECK]: Redundant property in " + filePath + ": " + key + "=" + String.valueOf(value)));
        }
    }

    @Override
    public String name() {
        return "property-sanity-check";
    }
}

