/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware.degs;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import house.inksoftware.degs.DEGSTest;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RequestBodyValidationCheck
implements DEGSTest {
    private static final String VIOLATION_SOURCE = "[REQUEST BODY VALIDATION VIOLATION]: ";
    private static final String EXPLANATION = "Every @RequestBody annotation must be accompanied by @Valid to ensure the request body adheres to validation constraints. This ensures the data integrity and prevents invalid or malformed data from entering the system.";

    @Test
    public void testRequestBodyValidation() {
        String sourceDirectoryPath = "src/main/java";
        File sourceDirectory = new File(sourceDirectoryPath);
        if (!sourceDirectory.isDirectory()) {
            return;
        }
        try (Stream<Path> paths = Files.walk(Paths.get(sourceDirectoryPath, new String[0]), new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".java")).forEach(this::processJavaFile);
        }
        catch (IOException e) {
            Assertions.fail((String)("[REQUEST BODY VALIDATION VIOLATION]: Failed to read source files: " + e.getMessage()));
        }
    }

    private void processJavaFile(Path path) {
        try {
            JavaParser javaParser = new JavaParser();
            CompilationUnit compilationUnit = javaParser.parse(path).getResult().orElse(null);
            compilationUnit.accept((VoidVisitor)new RequestBodyValidationVisitor(), null);
        }
        catch (IOException e) {
            Assertions.fail((String)("[REQUEST BODY VALIDATION VIOLATION]: Failed to parse Java file: " + e.getMessage()));
        }
    }

    @Override
    public String name() {
        return "request-body-validation-check";
    }

    private static class RequestBodyValidationVisitor
    extends VoidVisitorAdapter<Void> {
        private RequestBodyValidationVisitor() {
        }

        public void visit(MethodDeclaration n, Void arg) {
            super.visit(n, (Object)arg);
            for (Parameter param : n.getParameters()) {
                boolean hasRequestBody = false;
                boolean hasValid = false;
                for (AnnotationExpr annotation : param.getAnnotations()) {
                    if (annotation.getNameAsString().equals("RequestBody")) {
                        hasRequestBody = true;
                        continue;
                    }
                    if (!annotation.getNameAsString().equals("Valid")) continue;
                    hasValid = true;
                }
                if (!hasRequestBody || hasValid) continue;
                Assertions.fail((String)("[REQUEST BODY VALIDATION VIOLATION]: Found @RequestBody without @Valid annotation in method: " + n.getNameAsString() + " Every @RequestBody annotation must be accompanied by @Valid to ensure the request body adheres to validation constraints. This ensures the data integrity and prevents invalid or malformed data from entering the system."));
            }
        }
    }
}

