/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware.degs;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import house.inksoftware.degs.DEGSTest;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ScheduledLockCheck
implements DEGSTest {
    private static final String VIOLATION_SOURCE = "[SCHEDULED LOCK VIOLATION]: ";
    private static final String EXPLANATION = "Every @Scheduled method should also have a @SchedulerLock annotation to prevent overlapping executions.";

    @Test
    public void testScheduledLockConventions() {
        String sourceDirectoryPath = "src/main/java";
        File sourceDirectory = new File(sourceDirectoryPath);
        if (!sourceDirectory.isDirectory()) {
            return;
        }
        try (Stream<Path> paths = Files.walk(Paths.get(sourceDirectoryPath, new String[0]), new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".java")).forEach(this::processJavaFile);
        }
        catch (IOException e) {
            Assertions.fail((String)("[SCHEDULED LOCK VIOLATION]: Failed to read source files: " + e.getMessage()));
        }
    }

    private void processJavaFile(Path path) {
        try {
            JavaParser javaParser = new JavaParser();
            CompilationUnit compilationUnit = javaParser.parse(path).getResult().orElse(null);
            compilationUnit.accept((VoidVisitor)new ScheduledLockVisitor(), null);
        }
        catch (IOException e) {
            Assertions.fail((String)("[SCHEDULED LOCK VIOLATION]: Failed to parse Java file: " + e.getMessage()));
        }
    }

    @Override
    public String name() {
        return "scheduled-lock-check";
    }

    private static class ScheduledLockVisitor
    extends VoidVisitorAdapter<Void> {
        private ScheduledLockVisitor() {
        }

        public void visit(MethodDeclaration n, Void arg) {
            super.visit(n, (Object)arg);
            boolean hasScheduled = false;
            boolean hasSchedulerLock = false;
            for (AnnotationExpr annotation : n.getAnnotations()) {
                if (annotation.getNameAsString().equals("Scheduled")) {
                    hasScheduled = true;
                    continue;
                }
                if (!annotation.getNameAsString().equals("SchedulerLock")) continue;
                hasSchedulerLock = true;
            }
            if (hasScheduled && !hasSchedulerLock) {
                Assertions.fail((String)("[SCHEDULED LOCK VIOLATION]: Found @Scheduled without @SchedulerLock annotation in method: " + n.getNameAsString() + " Every @Scheduled method should also have a @SchedulerLock annotation to prevent overlapping executions."));
            }
        }
    }
}

