/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware.degs;

import house.inksoftware.degs.DEGSTest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.yaml.snakeyaml.Yaml;

public class SpringDataSourcePropertiesCompletenessTest
implements DEGSTest {
    private static final String VIOLATION_SOURCE = "[SPRING DATASOURCE PROPERTIES VIOLATION]: ";
    private static final String EXPLANATION = "Ensure completeness of spring.datasource properties.";

    @Test
    public void testSpringDataSourcePropertiesCompleteness() {
        String ymlFilePath = "src/main/resources/application.yml";
        Path ymlFile = Paths.get(ymlFilePath, new String[0]);
        Assertions.assertTrue((boolean)Files.exists(ymlFile, new LinkOption[0]), (String)"[SPRING DATASOURCE PROPERTIES VIOLATION]: application.yml is not present.");
        try (InputStream inputStream = Files.newInputStream(ymlFile, new OpenOption[0]);){
            Yaml yaml = new Yaml();
            Map obj = (Map)yaml.load(inputStream);
            if (obj == null || !obj.containsKey("spring")) {
                Assertions.fail((String)"[SPRING DATASOURCE PROPERTIES VIOLATION]: spring property is missing in application file. Ensure completeness of spring.datasource properties.");
                return;
            }
            Map spring = (Map)obj.get("spring");
            if (spring == null || !spring.containsKey("datasource")) {
                Assertions.fail((String)"[SPRING DATASOURCE PROPERTIES VIOLATION]: spring.datasource property is missing in application file.Ensure completeness of spring.datasource properties.");
                return;
            }
            Map datasource = (Map)spring.get("datasource");
            if (datasource == null || !datasource.containsKey("hikari")) {
                Assertions.fail((String)"[SPRING DATASOURCE PROPERTIES VIOLATION]: spring.datasource.hikari property is missing in application file. Ensure completeness of spring.datasource properties.");
                return;
            }
            Map hikariProperties = (Map)datasource.get("hikari");
            this.assertPropertyPresence(hikariProperties, "minimum-idle");
            this.assertPropertyPresence(hikariProperties, "maximum-pool-size");
            this.assertPropertyPresence(hikariProperties, "connection-timeout");
            this.assertPropertyPresenceWithValue(hikariProperties, "auto-commit", true);
            this.assertPropertyPresenceWithValue(hikariProperties, "connection-test-query", "SELECT 1");
            this.assertPropertyPresenceWithValue(datasource, "type", "com.zaxxer.hikari.HikariDataSource");
        }
        catch (IOException e) {
            Assertions.fail((String)("[SPRING DATASOURCE PROPERTIES VIOLATION]: Failed to read application file: " + e.getMessage()));
        }
        catch (ClassCastException e) {
            Assertions.fail((String)("[SPRING DATASOURCE PROPERTIES VIOLATION]: Failed to cast to YAML fields: " + e.getMessage()));
        }
    }

    private void assertPropertyPresence(Map<String, Object> properties, String propertyName) {
        if (properties == null || !properties.containsKey(propertyName)) {
            Assertions.fail((String)("[SPRING DATASOURCE PROPERTIES VIOLATION]: Property \"" + propertyName + "\" is missing. Ensure completeness of spring.datasource properties."));
        }
        if (properties.get(propertyName) == null) {
            Assertions.fail((String)("[SPRING DATASOURCE PROPERTIES VIOLATION]: Property \"" + propertyName + "\" is missing value."));
        }
    }

    private void assertPropertyPresenceWithValue(Map<String, Object> properties, String propertyName, Object expectedValue) {
        this.assertPropertyPresence(properties, propertyName);
        Object actualValue = properties.get(propertyName);
        Assertions.assertEquals((Object)expectedValue, (Object)actualValue, (String)("[SPRING DATASOURCE PROPERTIES VIOLATION]: Property \"" + propertyName + "\" has an unexpected value. Expected: " + String.valueOf(expectedValue) + ", Actual: " + String.valueOf(actualValue) + EXPLANATION));
    }

    @Override
    public String name() {
        return "spring-datasource-properties-completeness";
    }
}

