/*
 * Decompiled with CFR 0.152.
 */
package house.inksoftware.degs;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import house.inksoftware.degs.DEGSTest;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SystemOutPrintlnCheck
implements DEGSTest {
    private static final String VIOLATION_SOURCE = "[SYSTEM.OUT.PRINTLN VIOLATION]: ";
    private static final String EXPLANATION = "Found a System.out.println call which is not allowed.";

    @Test
    public void testSystemOutPrintlnConvention() {
        String sourceDirectoryPath = "src/main/java";
        File sourceDirectory = new File(sourceDirectoryPath);
        if (!sourceDirectory.isDirectory()) {
            return;
        }
        try (Stream<Path> paths = Files.walk(Paths.get(sourceDirectoryPath, new String[0]), FileVisitOption.FOLLOW_LINKS);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".java")).forEach(this::processJavaFile);
        }
        catch (IOException e) {
            Assertions.fail((String)("[SYSTEM.OUT.PRINTLN VIOLATION]: Failed to read source files: " + e.getMessage()));
        }
    }

    private void processJavaFile(Path path) {
        try {
            JavaParser javaParser = new JavaParser();
            CompilationUnit compilationUnit = javaParser.parse(path).getResult().orElse(null);
            compilationUnit.accept((VoidVisitor)new SystemOutPrintlnVisitor(), null);
        }
        catch (IOException e) {
            Assertions.fail((String)("[SYSTEM.OUT.PRINTLN VIOLATION]: Failed to parse Java file: " + e.getMessage()));
        }
    }

    @Override
    public String name() {
        return "system-out-println-check";
    }

    private static class SystemOutPrintlnVisitor
    extends VoidVisitorAdapter<Void> {
        private SystemOutPrintlnVisitor() {
        }

        public void visit(MethodCallExpr n, Void arg) {
            super.visit(n, (Object)arg);
            if (n.toString().contains("System.out.println")) {
                Assertions.fail((String)"[SYSTEM.OUT.PRINTLN VIOLATION]: Found a System.out.println call in file. Found a System.out.println call which is not allowed.");
            }
            if (n.toString().contains("System.out.print")) {
                Assertions.fail((String)"[SYSTEM.OUT.PRINTLN VIOLATION]: Found a System.out.print call in file. Found a System.out.println call which is not allowed.");
            }
        }
    }
}

